/* 
 * Author:
 *   Lloyd Zusman		UUCP:   ...!ames!fxgrp!ljz
 *   Master Byte Software	Internet:   ljz%fx.com@ames.arc.nasa.gov
 *   Los Gatos, California	or try:   fxgrp!ljz@ames.arc.nasa.gov
 *   "We take things well in hand."
 * 
 * Public Domain
 * C Durland 3/92 added stdarg support
 */

#ifdef __STDC__

#include <stdarg.h>
#define VA_START va_start

#else	/* __STDC__ */

#include <varargs.h>
#define VA_START(a,b) va_start(a)

#endif

/*
 * catstrs(result, string1, string2, ..., NULL)
 *
 * Concatenate string1, string2, ... together into the result,
 *   which must be big enough to hold all of them plus a trailing
 *   '\0'.  Returns the address of the result.
 *
 *   Example:
 *	char result[100];
 *	(void)catstrs(result, "This", " ", "is a ", "test", (char *)NULL);
 *	result now contains "This is a test".
 */
#ifdef __STDC__
char *catstrs(char *result, ...)
#else
char *catstrs(result, va_alist) char *result; va_dcl
#endif
{
  va_list ap;		/* argument list pointer */
  char *cp, *sp;

  VA_START(ap,result);

  sp = result;

  /*
   * Loop through all the arguments, concatenating each one to the
   *   result string.
   */
  for (cp = va_arg(ap, char *); cp; cp = va_arg(ap, char*))
      while (*cp != '\0') *sp++ = *cp++;
  *sp = '\0';		/* we need a trailing '\0' */

  va_end(ap);

  return result;
}








/* ****************  TEST ********************* */
#ifdef TEST

main()
{
  char result[100];

  (void)catstrs(result, "This", " ", "is a ", "test", (char *)0);

  puts(result);
}

#endif
