/*
 * ARGH(): simular to GETOPT(3)
 * C Durland 7/85	Public Domain
 *
 * argh(argc,argv,options)
 *  options string is CASE SENSITIVE.  If option letter is followed
 *	by a ':' it means option requires a word.
 *  returns: -1 (error), 0 (done), 1 (OK), 2 (no '-' but a word)
 *  argc, argv & options are unmodified by argh().
 * Notes: It is expected that you will only process the command line
 *	with this program ONCE! (unless you reset optind & optoff).
 *    if 1: &':'||2 (optarg!='\0')
 *    if -1: (optarg==?)
 */

#include <stdio.h>
#include <ctype.h>
#include "const.h"

	/* the next 3 vars are to be used by the calling pgm */
char *optarg,		/* pointer to word */
     optltr;		/* option letter */
int opterr = TRUE;	/* tell errors?	*/

	/* Next 2 vars can be used to restart argh() for example if you have
	 *   a recursive main()
	 */
int optind = 1,		/* index into argv */
    optoff = 0;		/* offset into argv[optind] */

argh(argc,argv,options) int argc; char **argv, *options;
{
  char *option, *strchr();

loop:
  if (optind>=argc) return 0;	/* no more args in arglist */
  optarg = argv[optind];
  if (optoff==0) /* new arg => check to see if an option */
    if (optarg[0]=='-') optoff++;		/* skip to next char */
    else { optind++; optltr = '?'; return 2; }	/* not option arg */
  if ((optltr = optarg[optoff++]) =='\0')	/* try next arg */
	{ optind++; optoff = 0; goto loop; }
/*  optltr = toupper(optltr); */
  if ((option = strchr(options,optltr)) ==(char *)NULL)
  {
    if (opterr) fprintf(stderr,"unknown option: '%c'\n",optltr);
    return -1;		/* not valid option */
  }
  if (option[1]==':')
  {		/* word expected, check next char & skip to next arg */
    optarg = argv[optind++] +optoff; optoff = 0;
    if ( (*optarg)=='\0' )
    		/* end of arg so check for word in next arg */
      if (optind>=argc)
      {	/* no more arguments */
        if (opterr)
	  fprintf(stderr,"'%c' option requires an argument\n",optltr);
        return -1;
      }
      else optarg = argv[optind++];
  }
  return 1;
}
