/* 
 *
 *	WORD.C MODULE
 *
 * The routines in this file implement commands that work word at a time.
 * There are all sorts of word mode commands. If I do any sentence and/or
 * paragraph mode commands, they are likely to be put in this file.
 */

/* Copyright 1990, 1991, 1992 Craig Durland
 *   Distributed under the terms of the GNU General Public License.
 *   Distributed "as is", without warranties of any kind, but comments,
 *     suggestions and bug reports are welcome.
 */

#include <char.h>
#include "me2.h"

static int inword();

/* Word wrap:  Special case for typing in text.
 * The following must be true: At end of line.
 * Back-over whatever precedes the point on the current line and stop on the
 *   first word-break or the beginning of the line.  If we reach the
 *   beginning of the line, jump back to the end of the word and start a new
 *   line.  Otherwise, break the line at the word-break, eat it, and jump
 *   back to the end of the word.
 * Returns TRUE on success, FALSE on errors.
 */
wrapword()
{
  register int i;
  int s;
  Line *line;

  line = the_dot->line; i = llength(line) - 1;
  while (0 <= i && !isspace(lgetc(line,i))) i--;	/* backup over word */
  if (i < 0) return FALSE;				/* no white space */
  while (0 <= i && isspace(lgetc(line,i))) i--;	/* backup over white space */
  the_dot->offset = i + 1;			/* set cursor between words */
  run_key((EKeyCode)(CTRL|'M'), FALSE,1, &s);
	/* delete leading white space */  
  while (the_dot->offset < llength(the_dot->line) &&
	 isspace(lgetc(the_dot->line,the_dot->offset)))
     ldelete((int32)1);
  goto_EoL();

  return TRUE;
}

    /* Move over words.  If n is less than zero, move backwords.
     * Input:
     *   nwords:  number of words to move over.
     *   n : pointer to a int.
     * Output:
     *   n :  number of characters moved over.  Only valid if TRUE is
     *        returned.
     * Returns:
     *   TRUE:  Everything went as expected.
     *   FALSE:  Hit the end or begining of the buffer before moved over
     *     nwords.
     */
int next_word(nwords,n) int nwords, *n;
{
  int x = 0, tick = 1, backwards = FALSE;

  if (nwords == 0) { *n = 0; return TRUE; }  /* easy to move over no words */

  if (nwords < 0)
  {
    backwards = TRUE;
    tick = -1;
    nwords = -nwords;
    if (!next_character(-1)) return FALSE;
  }

  while (nwords--)
  {
    while (!inword())			/* move over white space */
    {
      if (!next_character(tick)) return FALSE;
      x++;
    }
    while (inword())			/* move over word */
    {
      if (!next_character(tick))	/* hit buffer edge */
      {
	*n = x;
	return (nwords == 0);		/* OK if last word butts upto edge */
      }
      x++;
    }
  }
  *n = x;

  if (backwards) return next_character(1);
  return TRUE;
}

/*
 * Return TRUE if the character at dot is a character that is considered to be
 *   part of a word.
 */
static int inword()
{
  if (the_dot->offset == llength(the_dot->line)) return FALSE;
  return (int)isword(lgetc(the_dot->line, the_dot->offset));
}
