/*
 *
 *	SPAWN.C MODULE
 * Routines to create or run subjobs in the system command interpreter.
 */

/* Copyright 1990, 1991, 1992 Craig Durland
 *   Distributed under the terms of the GNU General Public License.
 *   Distributed "as is", without warranties of any kind, but comments,
 *     suggestions and bug reports are welcome.
 */

#include <stdio.h>
#include "me2.h"

#if MSDOZ
#include <process.h>
#endif

extern char *getenv();

/* Fork a shell so the user can mess around outside of ME and return to
 *   their edit session later.
 * When the command interpreter exits, mark the screen as garbage so that
 *   you do a full repaint.
 * Input:
 *   f :  An implementation defined f.  1 => do the "normal" thing (fork a
 *	  shell).
 *     For Unix, f != 1 => use job control and put ME into the background.
 * Output:
 *   TRUE!!!???
 */

int dont_spawn = FALSE;		/* So a driver, etc can disable spawning */

spawn_shell(f)
{
#if MSDOZ
  register char *ptr;

  if (dont_spawn) return FALSE;

  close_display(TRUE);	/* restore terminal for normal user interface */

  if ((ptr = getenv("SHELL")) != NULL && *ptr != '\0')
	spawnlp(P_WAIT,ptr,"ME",(char *)NULL);
  else spawnlp(P_WAIT,"command.com", "ME", (char *)NULL);

#if 0		/* old Lattice C */
  if ((ptr = getenv("SHELL")) != NULL && *ptr != '\0')
	forklp(ptr,"ME",(char *)NULL);
  else forklp("command.com", "ME", (char *)NULL);
#endif

  open_display();			/* set up terminal for editor */
  return TRUE;
#endif /* MSDOZ */



#if UX_OS
  register char *ptr;

  if (dont_spawn) return FALSE;

  if (f != 1) sig_pause(0);		/* try and use job control */
  else
  {
    close_display(TRUE);      /* restore terminal for normal user interface */

    if ((ptr = getenv("SHELL")) != NULL && *ptr != '\0')
#if 1
	system(ptr);			/* system("/bin/ksh"); */
#else	/* ??? */
    {
      char buf[300], *strcpy(), *strcat();

      system(strcat(strcpy(buf,"exec "), ptr));	/* system("exec /bin/ksh"); */
    }
#endif
    else system("exec sh");		/* default shell */
    open_display();		/* set up terminal for editor */
  }
  return TRUE;
#endif /* UX_OS */



#if ATARI
  register char *ptr;

  if (dont_spawn) return FALSE;

#ifdef __MINT__
  if (f != 1) sig_pause(0);		/* try and use job control */
  else
#endif /* __MINT__ */
  {
    close_display(TRUE);      /* restore terminal for normal user interface */
    if ((ptr = getenv("SHELL")) != NULL && *ptr != '\0')
	system(ptr);			/* system("/bin/ksh"); */
    open_display();		/* set up terminal for editor */
  }
  return TRUE;
#endif	/* ATARI */
}


/*
 * Have the shell (or OS) run a command (such as LS).
 * When the command returns and we should wait, print a prompt and wait for
 *   a single character to be typed and mark the screen as garbage so a full
 *   repaint is done.
 * Input:
 *   command : command to give the shell
 *   prompt  : If not NULL, what to ask the user (if ask-pgm).
 * Output:
 *   TRUE: Everything went as expected.
 *   FALSE: Command failed, for whatever reason.
 * Notes:
 *   Only asks the user if (ask-user) and there is a prompt.
 *   The command might garbage the screen and its only marked as garbage if
 *     we have to prompt so its up to the caller to take care of this
 *     possibility (if it wants to).
 */
shell_command(command, prompt) char *command, *prompt;
{
  extern int MMask_pgm;		/* in mm.c */

  int s, ask;

  ask = (!MMask_pgm && prompt);

  if (ask)		/* restore terminal for normal user interface */
	close_display(FALSE);

#if UX_OS || MSDOZ || ATARI
  if (ask) t_putchar('\n');  /* so the cmd doesn't overwrite the minibuffer */
  s = system(command);		/* !!!??? returns -1 or command return code */
#endif /* UX_OS || MSDOZ || ATARI */

  if (ask)
  {
    t_puts(prompt); t_flush();
    while ((s = t_getchar()) != '\r' && s != '\n') ;
    open_display();	/* takeover terminal AFTER resuming editing! */
  }

  return !s;
}

/* Filter some ME stuff through the OS (usually the shell).  
 * Output from the filter:
 *   Zip:  the filters output (stdout) is thrown away.
 *   bag:  the filter output is stored in a bag.  The old bag contents is
 *     lost.
 *   Might have inserted the output of the filter at dot.
 * Input to os_filter:
 *   filter_name:  name of the filter to invoke.
 *   in_bag: If !NULL, contains stuff to use as stdin.
 *   out_bag: If !NULL, store stdout in there.
 *   insert_output_at_dot: If TRUE, insert stdout at dot.
 * Returns:  TRUE if everything worked, FALSE if problems.
 * Notes:
 *   If !out_bag and !insert_output_at_dot then don't need to "> stdout"
 *     (except to keep stdout from writing all over the screen).  Could use
 *     /dev/null for stdout that probably only works on UNIX.
 *   The filter might garbage the screen - its up to the caller to take care
 *     of this possibility (if it wants to).
 *   If there is no input bag, I'd like to create an empty file as std
 *     input.  This would keep a filter from waiting for user input if it
 *     really wants input.  However, this won't work for pipes:  "foo | bar"
 *     because the filter would be "foo | bar < x > y" which would cause bar
 *     to ignore the output of foo.  So, I have to use "foo | bar > y" and
 *     to keep things from locking up (can't send bar a EOF), reset the
 *     terminal.  This also means that the user can type to the filter (but
 *     won't see the filters output).  To avoid this, send in an empty bag
 *     to used as stdin.
 */
#define CREATE_STDIN	FALSE
os_filter(filter_name,in_bag,out_bag, insert_output_at_dot)
  char *filter_name;
  Bag *in_bag, *out_bag;
  int insert_output_at_dot;
{
  extern char *strcpy(), *strcat(), *unique_file_name();

  char filter[NLINE+300], fin[150], fout[150];
  FILE *fptr;
  int s;

  if (in_bag)
  {
    unique_file_name(fin);
    if (!bag_to_file(in_bag,fin)) return FALSE;
  }
  else		/* no stdin */
  {
#if CREATE_STDIN
    unique_file_name(fin);
		/* create an empty file for input */
    if (!(fptr = fopen(fin,"w")))		/* open filters' stdin */
      { mlwrite("Can't open %s as stdin",fin); return FALSE; }
    fclose(fptr);
#else
    close_display(FALSE);
#endif
  }

  unique_file_name(fout);

	/* create the command line for the OS.
	 * "filter >stdout" or "filter >stdout <stdin"
	 */
#if CREATE_STDIN
  strcat(strcat(
    strcat(strcat( strcpy(filter,filter_name), " <"),fin),
    " >"),fout);
#else
  strcat(strcat( strcpy(filter,filter_name), " >"),fout);
  if (in_bag) strcat(strcat(filter, " <"),fin);
#endif
  if (system(filter))	/* !!!??? return return code? */
  {
    mlwrite("Filter failed.");
    s = FALSE;
    goto done;
  }

	/* mess with output of the filter */
  if (insert_output_at_dot)	/* insert the filters output at dot */
  {
    int n, error_code;

    if (!(s = insert_file(fout, &n, &error_code)))
      mlwrite("Insert failed!");
  }

done:

  if (out_bag)		/* copy the filters output to a bag */
    { clear_bag(out_bag); s = file_to_bag(fout,out_bag); }

  /* if they want to ignore the output, ignore it */

  unlink(fout);
#if CREATE_STDIN
  unlink(fin);
#else
  if (in_bag) unlink(fin);
  else	      open_display();
#endif

  return s;
}
