/*
 *	RANDOM.C MODULE
 * This file contains the command processing functions for a number of random
 * commands. There is no functional grouping here, for sure.
 */

/* Copyright 1990, 1991, 1992 Craig Durland
 *   Distributed under the terms of the GNU General Public License.
 *   Distributed "as is", without warranties of any kind, but comments,
 *     suggestions and bug reports are welcome.
 */

#include <char.h>
#include "me2.h"

/*
 * Calculate stats for a buffer.
 * Calculate the current position of the cursor, in origin 1 X-Y coordinates,
 *   from the start of the current buffer.
 * Note: dot is orgin 0.
 */
void buffer_stats(bp,bsize,dotat,nlines,catdot,r,wasted)
  Buffer *bp; int *catdot; long int *wasted, *dotat, *bsize, *nlines, *r;
{
  register Line *lp;
  int cac;
  long int unused = 0, dot_count = -1, num_chars = 0, num_lines = 0, row;

	/* loop through buffer and collect info */
  for (lp = BUFFER_FIRST_LINE(bp); lp != BUFFER_LAST_LINE(bp); lp = lforw(lp))
  {
    num_lines++;
    if (lp == the_dot->line)		/* collect info on dot if at dot */
    {
      dot_count = num_chars + the_dot->offset;
      if (the_dot->offset == llength(lp)) cac = '\n';
      else cac = lgetc(lp,the_dot->offset);
      row = num_lines;
    }
    num_chars += lp->l_used +1;		/* remember fake \n */
    unused += lp ->l_size -lp->l_used;
  }
  num_lines++;		/* remember fake line at end of buffer */
  if (dot_count == -1)	/* then dot is at end of buffer */
	{ dot_count = num_chars; cac = '\n'; row = num_lines; }
  *r = row; *nlines = num_lines;
  *dotat = dot_count; *bsize = num_chars; *catdot = cac;
  *wasted = unused;
}

getcol(line,offset) Line *line;
{
  register unsigned char c;
  register int i, col = 0;

  for (i = 0; i < offset; ++i)
  {
    c = lgetc(line,i);
    if (c == '\t') col = NEXT_TAB_COLUMN_MINUS_1(col);
    else if (iscntrl(c)) ++col;
    ++col;
  }
  return col;
}

 	/* Return current column */
getccol() { return getcol(the_dot->line,the_dot->offset); }

to_col(n)	/* insert tabs and spaces to column n (0==left margin) */
{
  register int col, t1,t2;

  col = getccol();
  t1 = NEXT_TAB_STOP(col); t2 = PREVIOUS_TAB_STOP(n);
  if (curbp->tabsize == 0 && t1 <= t2)
  {
    if (!linsert(t2-t1+1, '\t', FALSE)) return FALSE;
    col = TSTOC(t2);
  }
  n -= col; if (n <= 0) return TRUE;	/* already past n */
  return linsert(n,' ',FALSE);
}

   /* Delete n characters at the dot in the current buffer.  If n is
    *   negative, delete n characters before the dot.  If you want
    *   Emacs-like kill buffer stuff, set a_cut to TRUE.
    * Input:
    *   n : number of characters to delete.
    * Returns:
    *   TRUE:  If everything went as expected.
    *   FALSE:  Tried to -ve delete off the end of the buffer or ldelete()
    *     failed (malloc problem).
    */
delete_characters(n) int n;
{
  int s;

  if (0 <= n) return ldelete((int32)n);
  if (s = next_character(n)) s = ldelete((int32)-n);
  return s;
}

    /* Insert string at dot in current buffer.
     * Input:
     *   text : Pointer to text.  Does NOT have to be '\0' terminated.
     *   n    : Number of characters to insert.
     * Returns:
     *   TRUE:  string inserted.
     *   FALSE: memory problems.
     * Notes:
     *   If there is a newline in text, it is not inserted, it is performed.
     */
insert_text(text,n) char *text; int n;
{
  register char c;
  int s = TRUE;

  while (n-- && s)
  {
    c = *text++;
    s = (c == '\n') ? lnewline() : linsert(1,c,FALSE);
  }
  return s;
}
