/*
 * mmfcn2.c : Functions that don't fit in mmfcn.c
 */

/* Copyright 1990, 1991, 1992 Craig Durland
 *   Distributed under the terms of the GNU General Public License.
 *   Distributed "as is", without warranties of any kind, but comments,
 *     suggestions and bug reports are welcome.
 */

#include <stdio.h>	/* for FILE */
#include "me2.h"
#include "mm.h"
#include "driver.h"

extern Bag *id_to_bag();
extern Buffer *alloc_buffer(), *Mid_to_buffer(), *nthbuffer();
extern char
  result[],				/* in mm.c */
  *strcpy();
extern int buffer_is_read_only;		/* in buffer.c */
extern MMDatum RV, TV;			/* in mm.c */

/* ******************************************************************** */
/* ***************************** Buffers ****************************** */
/* ******************************************************************** */

			    /* (buffer-stats buffer-id (array INT stats 6)) */
void Mbuffer_stats()
{
  int x;
  int32 tl1, tl2, tl3, tl4, tl5;

  get2args(NUMBER,BLOB,"buffer-stats");
  buffer_stats(Mid_to_buffer((int)RV.val.num),&tl1,&tl2,&tl3,&x,&tl4,&tl5);
  put_int32(TV.val.blob,    (int32)tl1);	/* buffer size */
  put_int32(TV.val.blob + 4,(int32)tl2);	/* dot postition */
  put_int32(TV.val.blob + 8,(int32)tl3);	/* lines */
  put_int32(TV.val.blob +12,(int32)tl4);	/* buffer row */
  put_int32(TV.val.blob +16,(int32)tl5);	/* wasted */
  put_int32(TV.val.blob +20,(int32)x);		/* char at dot */
  RV.type = VOID;
}

void Mcreate_buffer()			    /* (create-buffer name [flags]) */
{
  Buffer *bp;
  int32 flags;

  get1arg(STRING,"create-buffer");
  flags = 0;
  if (maybearg(1,NUMBER,"create-buffer")) flags = TV.val.num;
  if (!(bp = alloc_buffer(RV.val.str, flags)))
	MMbitch("create-buffer:  No memory");
/*  set_buffer_flags(bp,flags);*/

  RV.type = NUMBER;
  RV.val.num = bp->id;
}

    /* (nth-buffer [n [id [flags]]])
     * Return the id of the nth buffer starting at <you pick>.
     * If no args, return the count of the current buffer.
     * Input:
     *   n : count.  Default is 0 ie return the id of the current buffer.
     *   id : buffer to start the count at.  Default is current buffer.
     *   flags : skip buffers with any of these flags set.
     * Returns:
     *   Buffer id
     */
void Mnth_buffer()		       /* (nth-buffer n [id [flags]]) => id */
{
#if 0
  Buffer *bp;
  int32 flags;      ?????????????
  int n, id;

  if (!maybearg(0,NUMBER,"nth-buffer"))		/* no args */
  {
    RV.val.num = cntbufs(curbp);
    RV.type = NUMBER;
    return;
  }
  bp = first_buffer;
  n = TV.val.num;
  flags = 0;
  if (maybearg(1,NUMBER,"nth-buffer")) bp = Mid_to_buffer((int)TV.val.num);
  if (maybearg(2,NUMBER,"nth-buffer")) flags = TV.val.num;
  RV.val.num = nthbuffer(bp,n,flags)->id;

#else
  if (!maybearg(0,NUMBER,"nth-buffer"))			/* no args */
	RV.val.num = cntbufs(curbp);
  else RV.val.num = nthbuffer(first_buffer,(int)TV.val.num,0)->id;

  RV.type = NUMBER;
#endif
}

    /* (buffer-name buffer-id)
     *   Return the name of a buffer.
     * (buffer-name file-name)
     *   Create a buffer name from a file name.
     */
void Mbuffer_name()
{
  if (MMpull_nth_arg(&RV,0) && RV.type == STRING) /* (buffer-name file-name) */
  {
    create_buffer_name(RV.val.str, result, RSIZ);
    RV.val.str = result;
  }
  else			/* (buffer-name buffer-id) */
  {
    get1arg(NUMBER,"buffer-name");
    RV.val.str = strcpy(result,
      get_dString(Mid_to_buffer((int)RV.val.num)->b_bname));
    RV.type = STRING;
  }
}

/* ******************************************************************** */
/* ****************************** Marks ******************************* */
/* ******************************************************************** */

	/* munges: TV */
void get_marks(name, n, mark1,mark2)
  char *name;
  int n;
  Mark **mark1, **mark2;
{
  int mark1_id, mark2_id;

  mark1_id = THE_DOT; mark2_id = THE_MARK;
  if (maybearg(n,  NUMBER,name)) mark1_id = TV.val.num;
  if (maybearg(n+1,NUMBER,name)) mark2_id = TV.val.num;
  if (!(*mark1 = id_to_mark(mark1_id)) || !(*mark2 = id_to_mark(mark2_id)))
	arg_bitch(name);
}

    /* (swap-marks [mark-id mark-id])
     * munges: TV
     */
void Mswap_marks()
{
  int mark1_id, mark2_id;

  mark1_id = THE_DOT; mark2_id = THE_MARK;
  if (maybearg(0,NUMBER,"swap-marks")) mark1_id = TV.val.num;
  if (maybearg(1,NUMBER,"swap-marks")) mark2_id = TV.val.num;

  if (!swap_marks(mark1_id, mark2_id)) MMbitch("swap-marks:  Bad mark(s)!");
}

void Mcompare_marks()		       /* (compare-marks [mark-id mark-id]) */
{
  Mark *mark1, *mark2;
  Region region;

  get_marks("compare-marks",0, &mark1,&mark2);

  if ((RV.val.num = get_region(mark1,mark2,&region)) == 0) MMabort_pgm(0);
  RV.type = NUMBER;
}

    /* (region-stats blob [mark1 [mark2 [goto-top-mark]]])
     * Calculate the stats for a region.  If marks not passed in, use dot
     *   and mark.
     * Input:
     *   blob:  pointer to structure of
     *		(byte type)(int left-edge width height)(INT size)
     *		that hold the region data.
     *	 mark1: one end of the region.  Defaults to dot.
     *	 mark2: the other end of the region.  Defaults to mark.
     *	 goto-top-mark:  If TRUE, move the dot to the upper left
     *     corner of the region.
     *	   Note that I can't swap the marks because one of them might
     *	   not be the dot.
     * Output:
     *   Region data stuffed into blob.
     */
void Mregion_stats()
{
  int x, goto_top;
  Mark *mark1, *mark2;
  Region region;

  get1arg(BLOB,"region-stats");
  get_marks("region-stats",1, &mark1,&mark2);

  goto_top = FALSE;
  if (maybearg(3, BOOLEAN, "region-stats")) goto_top = TV.val.num;

  if ((x = get_rectangle(mark1,mark2,&region)) == 0) MMabort_pgm(0);
  PUT_UINT8(RV.val.blob,  (uint8)x);
  put_int16(RV.val.blob+1, region.ulcol+1);
  put_int16(RV.val.blob+3, region.width);
  put_int16(RV.val.blob+5, region.height);
  put_int32(RV.val.blob+7, region.r_size);

  if (goto_top) jmp_mark(&region.mark);

  RV.type = VOID;
}

    /* (delete-region [mark1 [mark2]])
     * Output:
     *   
     */
void Mdelete_region()
{
  Mark *mark1, *mark2;
  Region region;

  if (buffer_is_read_only)
  {
    RV.val.num = FALSE;
/* !!!???
    if (maybearg(2, BOOLEAN, "delete-region") && !TV.val.num)
	MMbitch("Buffer is read only");
*/
  }
  else
  {
    get_marks("delete-region", 0, &mark1,&mark2);

    if (0 == get_region(mark1,mark2, &region)) MMabort_pgm(0);

    *the_dot = region.mark;
    if (!ldelete(region.r_size)) MMbitch("delete-region:  memory problems");

    RV.val.num = TRUE;
  }
  RV.type = BOOLEAN;
}

/* ******************************************************************** */
/* ******************************* Bags ******************************* */
/* ******************************************************************** */

    /*
     * Append stuff to a bag.
     *   (append-to-bag bag-id TEXT	  <text>)
     *   (append-to-bag bag-id REGION	  [mark1 mark2])
     *   (append-to-bag bag-id CHARACTERS <number>)
     *   (append-to-bag bag-id RECTANGLE  [mark1 mark2])
     */
void Mappend_to_bag()
{
  Bag *bag;
  int s;
  Mark *mark1, *mark2;
  Region region;

  get2args(NUMBER,NUMBER,"append-to-bag");	/* bag-id op */
  if (!(bag = id_to_bag((int)RV.val.num)))
	MMbitch("append-to-bag: bad bag-id");

  switch(TV.val.num)
  {
    case 0:			      /* (append-to-bag bag-id TEXT <text>) */
      get_nth_arg(2,STRING,"append-to-bag");
      s = bag_append(bag, RV.val.str, strlen(RV.val.str));
      break;
    case 1:		      /* (append-to-bag bag-id CHARACTERS <number>) */
      get_nth_arg(2,NUMBER,"append-to-bag");
      s = copy_region_to_bag(the_dot, RV.val.num, bag);
      break;
    case 2:		     /* (append-to-bag bag-id REGION [mark1 mark2]) */
      get_marks("append-to-bag REGION", 2, &mark1,&mark2);
      if (get_region(mark1,mark2, &region) == 0) MMabort_pgm(0);
      s = copy_region_to_bag(&region.mark, region.r_size, bag);
      break;
    case 3:		  /* (append-to-bag bag-id RECTANGLE [mark1 mark2]) */
      get_marks("append-to-bag RECTANGLE", 2, &mark1,&mark2);
      if (!copy_rect(bag, mark1,mark2)) MMabort_pgm(0);
      s = TRUE;
      break;
  }

  if (!s) MMbitch("append-to-bag: Out of memory!");

  RV.type = VOID;
}

    /* Convert a bag to a string.
     * Gonna look a little funny if you convert a rectangle to a string.
     */
void Mbag_to_string()
{
  extern char *bag_to_string();		/* in bag.c */

  Bag *bag;

  get1arg(NUMBER,"bag-to-string");	/* bag-id */
  if (!(bag = id_to_bag((int)RV.val.num)))
	MMbitch("bag-to-string: bad bag-id");

  RV.type = STRING;
  if (!(RV.val.str = bag_to_string(bag)))
	MMbitch("bag-to-string: Out of memory!");
}

/* ******************************************************************** */
/* ******************************* Misc ******************************* */
/* ******************************************************************** */

    /* (filter
     *   filter-name
     *   [in-bag-id  (-1 if no bag)]
     *   [out_bag-id (-1 if no bag)]
     *   [insert-output-at-dot]
     * )
     * Result:
     *   RV : boolean
     *     TRUE if everything worked OK
     */
void Mfilter()
{
  Bag *bag_in = NULL, *bag_out = NULL;
  char *filter_name;
  int insert_output_at_dot = FALSE;

	/* get the filter name */
  get1arg(STRING,"OS-filter"); filter_name = RV.val.str;

		/* get in-bag-id if not -1 */
  if (maybearg(1,NUMBER,"OS-filter"))
    if (TV.val.num != -1 && !(bag_in = id_to_bag((int)TV.val.num)))
	arg_bitch("OS-filter");

		/* get out-bag-id if not -1 */
  if (maybearg(2,NUMBER,"OS-filter"))
    if (TV.val.num != -1 && !(bag_out = id_to_bag((int)TV.val.num)))
	arg_bitch("OS-filter");

	/* get [insert-output-at-dot] */
  if (maybearg(3,BOOLEAN,"OS-filter")) insert_output_at_dot = (int)TV.val.num;

  RV.type = BOOLEAN;
  RV.val.num = os_filter(filter_name, bag_in,bag_out, insert_output_at_dot);
}

	/* (command-flag op flag)
	 */
void Mcommand_flag()
{
  extern int32
    thisflag,		/* Flags, this command: main.c */
    lastflag;		/* Flags, last command: main.c */

  static int seed = 100;

  int32 flag;

  get2args(NUMBER,NUMBER,"command-flag");
  flag = TV.val.num;
  switch (RV.val.num)	/* op */
  {
    case 0: 		/* CMDFLG-SET */
      thisflag = flag;
      RV.type = VOID;
      break;
    case 1:		/* CMDFLG-TEST */
      RV.val.num = (lastflag == flag);
      RV.type = BOOLEAN;
      break;
    case 2:		/* CMDFLG-NTEST !!!??? remove*/
      RV.val.num = (lastflag != flag);
      RV.type = BOOLEAN;
      break;
    case 3:		/* CMDFLG-NTEST-AND-SET */
      RV.val.num = (lastflag != flag);
      RV.type = BOOLEAN;
      thisflag = flag;
      break;
    case 4:		/* CMDFLG-GEN-FLAG */
      RV.val.num = seed++;
      RV.type = NUMBER;
      break;
  }
}

    /* (move-cursor row column [text [clear]])
     */
void Mmove_cursor()
{
  int row, column;

  get2args(NUMBER,NUMBER,"move-cursor");
  row = RV.val.num; column = TV.val.num;

  if (!maybearg(2,STRING,"move-cursor")) t_move(row,column);
  else
  {
    char *text;
    int clear = FALSE;

    text = TV.val.str;
    if (maybearg(4,BOOLEAN,"move-cursor")) clear = TV.val.num;
    vpputs(row,column, text, clear);
  }
  cursor_is_garbage();

  RV.type = VOID;
}

    /* (complete selector prompt [list])
     */
void Mcomplete()
{
  extern void *r2_list;		/* in help.c */

  char *prompt;
  int32 selector;

  get2args(NUMBER,STRING,"complete");
  selector = RV.val.num;
  prompt = TV.val.str;
  if (selector & CC_LIST)
  {
    get_nth_arg(2,LIST,"complete");
    ranger2_list(2, RV.val.object);
  }

  if (selector & CC_NO_ASK)
    complete(result,selector);
  else
  {
    MMset_ask_frame();
    mlreply(prompt,result,RSIZ,(int)selector);
    MMreset_ask_frame();
  }
  RV.type = STRING; RV.val.str = result;
}

#if 0
    /* (beep [volume])
     */
void void Mbeep()
{
  extern int beeper;			/* in main.c */

  if (!maybearg(0,NUMBER,"beep") t_beep();		/* (beep) */
  else if (-1 != RV.val.num) beeper = RV.val.num;	/* (beep volume) */
  RV.type = NUMBER;
  RV.val.num = beeper;
}
#endif

    /* (small-int month day year hh mm ss)	;; TimeInfo
     * (read-clock (floc month))
     * Read the clock and return the current time and date
     */
void Mread_clock()
{
  int month,day,year, hh,mm,ss;

  os_time(&month,&day,&year, &hh,&mm,&ss);

  get1arg(BLOB,"read-clock");

  put_int16(RV.val.blob,    month);	/* month */
  put_int16(RV.val.blob+ 2, day);	/* day */
  put_int16(RV.val.blob+ 4, year);	/* year */
  put_int16(RV.val.blob+ 6, hh);	/* hh */
  put_int16(RV.val.blob+ 8, mm);	/* mm */
  put_int16(RV.val.blob+10, ss);	/* ss */

  RV.type = VOID;
}


    /* (file-name buffer-id)
     *   Return the name of the file attached to buffer buffer-id.
     *   Output:
     *     RV : STRING : File name
     * (file-name buffer-id [new-file-name])
     *   Change the file name of the file attached to buffer buffer-id and
     *     return it.  New name is cannonized.
     *   Output:
     *     RV : BOOLEAN : TRUE if name OK.
     * (file-name file-name [search-path])
     *   Check to see if a file is "real" - can be opened.  If search-path,
     *     check for file along the path.
     *   Output:
     *     Name of file that can be used (for example) in (file-to-buffer).
     *       Might not be canonized.
     *     ???RV : BOOLEAN : TRUE if name OK.
     */
static int file_name_findit(file_name) char *file_name;
{
  FILE *fptr;

  if (!(fptr = fopen(file_name, "r"))) return FALSE;
  fclose(fptr);
  strcpy(result, file_name);	/* !!!Note:  file_name may point to result */
  return TRUE;
}
void Mfile_name()
{
  if (MMpull_nth_arg(&RV,0) && RV.type == NUMBER)	 /* (file-name bid) */
  {
    Buffer *bp;

    bp = Mid_to_buffer((int)RV.val.num);
    if (maybearg(1,STRING,"file-name"))	       /* rename the file */
      { RV.type = BOOLEAN; RV.val.num = new_file_name(bp,TV.val.str); }
    else	/* return the name of the file attached to the buffer */
    {
      RV.type = STRING;
      RV.val.str = strcpy(result,get_dString(bp->b_fname));
    }
  }
  else			/* assume (file-name file-name [path]) */
  {
    char *ptr = NULL;
    int s;

    get1arg(STRING,"file-name");
    if (maybearg(1,STRING,"file-name")) ptr = TV.val.str;
    strcpy(result,RV.val.str);	/* !!!??? pretty sure RV is not result */
    s = find_file(result, ptr, file_name_findit);	/*    ?wild cards  */
    if (!s) result[0] = '\0';
    RV.type = STRING; RV.val.str = result;
  }
}

    /*  (small-int button r c state motion modifiers key)	;; MouseInfo
     *  (get-mouse-info (loc button))
     */
void Mmouse_info()
{
  extern MouseInfo *get_mouse_info();	/* in the I/O driver */

  int key, button;
  MouseInfo *mouse_info;

  get1arg(BLOB,"mouse-info");

  mouse_info = get_mouse_info();

  put_int16(RV.val.blob,   mouse_info->button);
  put_int16(RV.val.blob+2, mouse_info->row);
  put_int16(RV.val.blob+4, mouse_info->column);
  put_int32(RV.val.blob+6, mouse_info->state);
  put_int32(RV.val.blob+8, mouse_info->modifiers);

#if 0
  button = mouse_info->button;
  if (BUTTON_DOWN == mouse_info->state) button += 5;
  if (SHIFT & mouse_info->modifiers)    button += 10;
  key = (int)"1234567890!@#$%^&*()"[button];
#endif

  RV.type = VOID;
}

/* ******************************************************************** */
/* ******************** System Variables ****************************** */
/* ******************************************************************** */

int gimmehelp = 1;	/* !!!??? */

static int sysvar(), colorvar();

void Msys_var(n)
{
  if (!colorvar(n))
  {
    int set_var;

    set_var = maybearg(0,NUMBER,"sysvar");
    RV.type = NUMBER; RV.val.num = sysvar(n,TV.val.num,set_var);
  }
}

void wmunge(flag)			/* update flags for all windows */
{
  register Window *wp;

  for (wp = first_window; wp; wp = wp->nextw) wp->w_flag |= flag;
}

static int colorvar(n)
{
  int set_var, redraw = TRUE;

  switch(n)
  {
    case   8: n = TEXT_COLOR; break;		    /* (text-color [color]) */
    case   9: n = MODELINE_COLOR; break;	/* (modeline-color [color]) */
    case  14:					  /* (cursor-color [color]) */
	      n = CURSOR_COLOR; redraw = FALSE; break;
    case  10:					  /* (cursor-shape [shape]) */
	      n = CURSOR_SHAPE; redraw = FALSE; break;
    default: return FALSE;
  }

  set_var = maybearg(0,STRING,"sysvar");

  if (set_var && do_color(n, TV.val.str, TRUE) && redraw)
	screen_is_garbage = TRUE;
  do_color(n, result, FALSE);
  RV.type = STRING; RV.val.str = result;

  return TRUE;
}

static int sysvar(n,value,set) int n, set; int32 value;
{
  extern int
    beeper,			/* in main.c */
    case_fold,			/* in search.c */
    cc_trigger,			/* in mline.c */
    overstrike, ost_hook,	/* in main.c */
    hstep,			/* in display.c */
    t_nrow, t_ncol;
  int z = -1, *x = &z;	/* z in case of booboo */

  switch (n)
  {
    case  5:						/* case-fold-search */
      x = &case_fold;
      if (set) fix_cmap((int)value);
      break;
    case  1: x = &gimmehelp; break;				    /* HELP */
    case  2:						      /* overstrike */
      x = &overstrike;
      if (set && value != overstrike)	/* tell somebody about the change */
      {
	overstrike = value;  /* needed so the hook gets the current value */
	if (ost_hook != -1) MMrun_pgm(ost_hook);
      }
      break;
    case  4:					/* (screen-length [length]) */
      if (set) display_resized((int)value, t_ncol);
      return t_nrow +1;
    case 12:					  /* (screen-width [width]) */
      if (set) display_resized(t_nrow +1, (int)value);
      return t_ncol;
    case 13:					       /* horizontal-scroll */
      x = &hstep;
      if (set && value == 0)	/* !!!??? huh? onlywind()? */
	  { onlywind(); curwp->lmargin = 0; wmunge(WFHARD); }
      break;
    case  6: x = &curbp->tabsize;  break;	  /* (tab-stops [tab-size]) */
    case  7: x = &curbp->wrap_col; break;	    /* (word-wrap [column]) */
    case 11:						 /* (beep [volume]) */
      x = &beeper;
      if (!set) t_beep();			/* (beep) */
      else if (-1 == value) set = FALSE;	/* (beep -1) */
      break;
    case  3: x = &cc_trigger; break;			    /* complete-key */
  }
  if (set) *x = value;
  return *x;
}

