	TITLE	tifv.asm - deal with TI PC display
;;      C Durland	Public Domain
	INCLUDE	DOSd.MAC

	DSEG
tcolor	DW 7		; text color default
mcolor	DW 96		; modeline color default
vseg	DW 0DE00H	; segment where the video ram starts
p_ncol	DB 80		; screen hardware columns per row
DS40	DW 40H


EXTRN t_ncol:WORD, t_nrow:WORD
PUBLIC tcolor, mcolor
	ENDDS

	PSEG				; begin program segment

ATTR	equ 01800H			; offset of video attribute

;
; putline(row,buf,attr) int row,attr; char *buf;
;
	BEGIN putline
	PUSH  BP
	MOV   BP,SP

	push DS
	push ES
	push DI
	push SI
	push BX
	push CX

		; calc screen address
	mov AX,[BP+04H]		; row
	mul p_ncol

	mov ES,vseg	; screen segment
	mov DI,AX	; offset of row

	MOV  AL,[BP+0AH]	; attr
	mov  CX,t_ncol

	mov  SI,[BP+06H]	; buf address
	mov  DS,[BP+08H]

	xchg ES:[ATTR],AL	; swap attributes

	CLD
	repz movsb		; *screen++ = buf++

	mov ES:[ATTR],AL	; restore attribute

	pop CX
	pop BX
	pop SI
	pop DI
	pop ES
	pop DS
	POP BP
	RET
putline	ENDP


;
; fv_init()	; initialize fast video stuff
;   Find the video segment.
;   Set the column count
;   Set the row count if on EGA/VGA.
;   For TI PC, home the video page

	BEGIN fv_init

	mov  AH,13H
	int  49H

	mov t_ncol,80		; for ME

	RET
fv_init	ENDP

;
; void t_move(row,col) int row, col;	/* move cursor to (row,col) */
;
	BEGIN t_move 
	PUSH  BP
	MOV   BP,SP

	push BX
	push DX

	mov DH,[BP+04H]		; row
	mov DL,[BP+06H]		; col
	mov BH,0		; page 0
	mov AH,2
	int 10h

	pop DX
	pop BX
	pop BP
	ret
t_move	ENDP

;
; void t_eeol()		/* erase from cursor to end of line */
; Use the existing attribute

	BEGIN t_eeol

	push ES
	push DI
	push BX
	push CX
	push DX

	mov BH,0		; page 0
	mov AH,3
	int 10h			; DH has cursor row, DL has column

	mov AL,p_ncol
	mul DH			; row * columns per line

	xor DH,DH
	add AX,DX		; add in offset from start of line
	add AX,DX

	mov CX,t_ncol
	sub CX,DX		; columns to clear
	jLE eeol10		; bail out if already past t_ncol

	mov ES,vseg		; screen segment
	mov DI,AX		; offset of row

	mov AL,20H		; a blank

	CLD
	rep stosb

eeol10:
	pop DX
	pop CX
	pop BX
	pop DI
	pop ES
	ret
t_eeol	ENDP

	ENDPS				; end the program segment
	END				; end the source file
