/*
 * stkmap.c MODULE: atariST TOS key mapping
 * cribbed from pckmap.c
 *  ++jrb  bammi@cadence.com	Public Domain
 */

#include "me2.h"
#include "term.h"

static char what[] = "@(#)ST Keymap";

static struct { unsigned int scancode; EKeyCode keycode; }
  key_map[] =
  {
    0x0047, SOFKEY|'A',		/* home */
    0x004F, SOFKEY|'B',		/* end */
    0x0048, SOFKEY|'C',		/* up arrow */
    0x0050, SOFKEY|'D',		/* down arrow */
    0x004D, SOFKEY|'E',		/* right arrow */
    0x004B, SOFKEY|'F',		/* left arrow */
    0x0053, SOFKEY|'H',		/* delete char */
    0x0052, SOFKEY|'G',		/* insert key */
    0x0051, SOFKEY|'J',		/* next or page down */
    0x0049, SOFKEY|'I',		/* prev or page up */
    0x0077, CTRL|SOFKEY|'A',	/* control home */
    0x0075, CTRL|SOFKEY|'B',	/* control end */
    0x0076, CTRL|SOFKEY|'J',	/* control Next or page down */
    0x0084, CTRL|SOFKEY|'I',	/* control Prev or page up */
    0x0003,  '\0',		/* control @ */

	  /* and now a few ALT mappings */
    0x0081, META|'0', /* '0' not in ascii order. 1..9 mapped in map_key() */
    0x0078, META|'!',
    0x001E, META|'A',
    0x0030, META|'B',
    0x002E, META|'C',
    0x0020, META|'D',
    0x0012, META|'E',
    0x0021, META|'F',
    0x0022, META|'G',
    0x0023, META|'H',
    0x0017, META|'I',
    0x000F, META|'I',		/* shift tab */
    0x0024, META|'J',
    0x0025, META|'K',
    0x0026, META|'L',
    0x0032, META|'M',
    0x0031, META|'N',
    0x0018, META|'O',
    0x0019, META|'P',
    0x0010, META|'Q',
    0x0013, META|'R',
    0x001F, META|'S',
    0x0014, META|'T',
    0x0016, META|'U',
    0x002F, META|'V',
    0x0011, META|'W',
    0x002D, META|'X',
    0x0015, META|'Y',
    0x002C, META|'Z',

    0x0044, SOFKEY|'0',		/* F10 */
    0x005D, SHIFT|SOFKEY|'0',	/* shift F10 */
    0x0067, CTRL |SOFKEY|'0',	/* control F10 */
    0x0071, META |SOFKEY|'0',	/* alt F10 */

	  /* extended keyboard */
    0x0001, META|CTRL|'[',	/* ALT ESC */
    0x000E, META|CTRL|'H',	/* ALT backspace */
    0x00A5, META|CTRL|'I',	/* ALT tab */
    0x001C, META|CTRL|'M',	/* ALT enter */
    0x0027, META|';',		/* ALT ; */
    0x0028, META|'\'',		/* ALT ' */
    0x0029, META|'`',		/* ALT ` */
    0x002B, META|'\\',		/* ALT \ */
    0x0033, META|',',		/* ALT , */
    0x0034, META|'.',		/* ALT . */
    0x0035, META|'/',		/* ALT / */
    0x008D, CTRL|SOFKEY|'C',	/* control up arrow */
    0x0091, CTRL|SOFKEY|'D',	/* control down arrow */
    0x0074, CTRL|SOFKEY|'E',	/* control right arrow */
    0x0073, CTRL|SOFKEY|'F',	/* control left arrow */
    0x0092, CTRL|SOFKEY|'G',	/* control insert key */
    0x0093, CTRL|SOFKEY|'H',	/* control delete char */
    0x0085, SOFKEY|'a',		/* F11 */
    0x0087, SHIFT|SOFKEY|'a',	/* shift F11 */
    0x0089, CTRL|SOFKEY|'a',	/* control F11 */
    0x008B, META|SOFKEY|'a',	/* ALT F11 */
    0x0086, SOFKEY|'b',		/* F12 */
    0x0088, SHIFT|SOFKEY|'b',	/* shift F12 */
    0x008A, CTRL|SOFKEY|'b',	/* control F12 */
    0x008C, META|SOFKEY|'b',	/* ALT F12 */
/*  0x004C, SOFKEY|???,		/* middle of cursor pad (5) */
/*  0x008F, META|SOFKEY|???,	/* ALT middle of cursor pad (5) */

#if 0 /* we dont have no stinking gray pad :-) */
  /*
   * Distinguish between the cursor controls on the number pad and those on
   *  the grey keypad.
   */
    0xE047, SHIFT|SOFKEY|'A',		/* grey home */
    0xE048, SHIFT|SOFKEY|'C',		/* grey cursor up */
    0xE049, SHIFT|SOFKEY|'I',		/* grey page up */
    0xE04B, SHIFT|SOFKEY|'F',		/* grey cursor left */
    0xE04D, SHIFT|SOFKEY|'E',		/* grey cursor right */
    0xE04F, SHIFT|SOFKEY|'B',		/* grey end */
    0xE050, SHIFT|SOFKEY|'D',		/* grey cursor down */
    0xE051, SHIFT|SOFKEY|'J',		/* grey page down */
    0xE052, SHIFT|SOFKEY|'G',		/* grey insert */
    0xE053, SHIFT|SOFKEY|'H',		/* grey delete */
    0xE077, CTRL |SHIFT|SOFKEY|'A',	/* control grey home */
    0xE075, CTRL |SHIFT|SOFKEY|'B',	/* control grey end */
    0xE076, CTRL |SHIFT|SOFKEY|'J',	/* control grey page down */
    0xE084, CTRL |SHIFT|SOFKEY|'I',	/* control grey page up */
    0xE08D, CTRL |SHIFT|SOFKEY|'C',	/* control grey up arrow */
    0xE091, CTRL |SHIFT|SOFKEY|'D',	/* control grey down arrow */
    0xE074, CTRL |SHIFT|SOFKEY|'E',	/* control grey right arrow */
    0xE073, CTRL |SHIFT|SOFKEY|'F',	/* control grey left arrow */
    0xE092, CTRL |SHIFT|SOFKEY|'G',	/* control grey insert key */
    0xE093, CTRL |SHIFT|SOFKEY|'H',	/* control grey delete char */
#endif

    0	/* end of table */
  };

    /* Convert terminal codes to ME codes.
     * Input:
     *   scancode:  The scan code returned in high word from Bconin.
     *   keycode:  pointer to a EKeyCode that hold the converted key.
     * Changes: *keycode
     * Returns:
     *   TRUE:  Everything went as expected.
     *   FALSE: Unreconized scancode.
     */
map_key(scancode,keycode) unsigned int scancode; EKeyCode *keycode;
{
  register int j;

   /* ************* Function keys ************************************ */
	/* convert function key 1..9 to SOFKEY 1...9 */
  if (0x3B <= scancode && scancode <= 0x43)
    { *keycode = SOFKEY | (scancode-0xA); return TRUE; }

	/* convert shift function key 1..9 to SHIFT SOFKEY 1...9 */
  if (0x54 <= scancode && scancode <= 0x5C)
    { *keycode = SHIFT |  SOFKEY | (scancode-0x23); return TRUE; }

	/* convert control function key 1..9 to CTRL SOFKEY 1...9 */
  if (0x5E <= scancode && scancode <= 0x66)
    { *keycode = CTRL | SOFKEY | (scancode-0x2D); return TRUE; }

	/* convert alt function key 1..9 to META SOFKEY 1...9 */
  if (0x68 <= scancode && scancode <= 0x70)
    { *keycode = META | SOFKEY | (scancode-0x37); return TRUE; }

   /* ************* ALT keys ************************************ */
		/* convert ALT 1...9 to META "1"..."9" */
  if (0x78 <= scancode && scancode <= 0x80)
	{ *keycode = META | (scancode-0x47); return TRUE; }

   /* ************* everybody else ********************************* */
  for (j = 0; key_map[j].scancode; j++)		/* look up code */
    if (key_map[j].scancode == scancode)	/* found it */
	{ *keycode = key_map[j].keycode; return TRUE; }

  return FALSE;					/* not found */
}
