/*
 *	FILEIO.C MODULE for MS-DOS.
 */

/*
 * The routines in this file read and write ASCII files from the disk.  All
 * of the knowledge about files are here.  A better message writing scheme
 * should be used.
 */

/* Notes:
 *   I've implemented a caching read/write for MS-DOS.  It speeds up reads
 *     and writes about 3x on my 286 system (with Lattice C, its about 1.5X
 *     to 2X for Borland C++ 2.0) depending on the cache size.
 *   This was written with Borland C++ 2.0 using inline asmembly.
 *   The data segment is pretty full so there is not much room for the cache.
 */

/* Copyright 1990, 1991, 1993 Craig Durland
 *   Distributed under the terms of the GNU General Public License.
 *   Distributed "as is", without warranties of any kind, but comments,
 *     suggestions and bug reports are welcome.
 */

#define CACHE_SIZE	600

#include <io.h>
/*#include <stdio.h>*/
#include <dos.h>
#include <fcntl.h>
#include "me2.h"

void pc_blkmov();

#define WRITING		1
#define READING		2

static char cache[CACHE_SIZE], *ptr;
static int beol, used, space, oper, fh;

	/* Open a file for reading */
ffropen(fn) char *fn;
{
  if ((fh = _open(fn,O_RDONLY)) == -1) return FIOFNF;
  oper = READING; used = 0; beol = 0;
  return FIOSUC;
}

	/* Open a file for writing */
ffwopen(fn) char *fn;
{
  if ((fh = _creat(fn,FA_NORMAL)) == -1)
	{ mlwrite("Cannot open file for writing"); return FIOERR; }
  oper = WRITING; space = CACHE_SIZE; ptr = cache;
  return FIOSUC;
}

	/* Close a file */
ffclose()
{
  if (oper == WRITING &&	/* flush the cache if not empty */
      (used = CACHE_SIZE - space) != 0 && _write(fh,cache,used) != used)
    { _close(fh); mlwrite("Write I/O error");  return FIOERR; }
  if (_close(fh)) { mlwrite("Error closing file"); return FIOERR; }
  return FIOSUC;
}

/*
 * Write a line to the already opened file.  n is the line length,
 *   less the free newline. Return the status.
 * Check for errors.
 */
ffputline(buf,n) char *buf; int n;
{
  int s = FALSE;

  do
  {
    if (n <= space)	/* buf will fit in cache */
    {
      pc_blkmov(ptr,buf,n); ptr += n; space -= n;
      if (s) break;
      buf = "\r\n"; n = 2; s = TRUE;	/* add a CR LF to end of line */
    }
    else		/* buf won't fit in cache */
    {
      pc_blkmov(ptr,buf,space); 
      buf += space; n -= space;
      ptr = cache; space = CACHE_SIZE;
      if (_write(fh,cache,CACHE_SIZE) != CACHE_SIZE)
	  { mlwrite("Write I/O error"); return FIOERR; }
    }
  } while (n > 0);

  return FIOSUC;
}

/*
 * Read a line from a file and store the bytes in the supplied buffer.
 * n is the length of the buffer, counting the '\0'.
 * Check for I/O errors.
 */
ffgetline(buf,n) char *buf; int n;
{
  int z,s;

  s = FALSE;
  n--;		/* leave room for '\0' */
  while (TRUE)
  {
    if (used <= 0)	/* the cache is empty */
    {
      ptr = cache;
      used = _read(fh,cache,CACHE_SIZE);
      if (used <= 0 || used > CACHE_SIZE)  /* end of file or error reading */
	return s ? FIOSUC : FIOEOF;
      if (beol == 2)	/* \r was the last character in the cache */
	if (*ptr == '\n') { ptr++; used--; return FIOSUC; }
	else { *buf++ = '\r'; n--; }
    }
    s = TRUE;
    z = blkccpy(buf,ptr,n,used);
    ptr += z; used -= z;
    if (beol == 0) return FIOSUC;		/* EoL or filled buf */
    used = 0; n -= z; buf += z;
  }
}

#define CR	13	/* '\r' */
#define LF	10	/* '\n' */

/* blkccpy(to,from,tn,fn)
 * Always appends a '\0' to to.
 * Returns: bytes copied
 * Sets beol: 0 (EoL or copied tn bytes), 1 (copied fn bytes),
 *    2(CR is last byte of from)
 */
static int blkccpy(to,from,tn,fn) char *to, *from;
{
  asm push DS;

  asm MOV  CX,tn
  asm MOV  DX,fn

  asm lES  DI,to
  asm lDS  SI,from

  asm xor  BX,BX	/* bytes read (beol==0) else bytes copied */
  asm CLD;
bk10:		/* copy bytes until CRLF or LF or copied n bytes */
  asm cmp  DX,0		/* done if nothing left to copy */
  asm jE   bk70
  asm cmp  CX,0		/* done if filled to */
  asm jE   bk80
  asm lodsb		/* AL = *from++ */
  asm inc  BX		/* read a byte */
  asm dec  DX		/* out of from */
  asm cmp  AL,LF	/* a LF? */
  asm jE  bk80		/* yes - done with this line */
  asm cmp AL,CR		/* a CR? */
  asm jE bk30		/* yes */
bk20:
  asm stosb		/* *buf++ = AL */
  asm dec  CX		/* copied a byte */
  asm jmp  bk10
bk30:
  asm cmp  DX,0		/* at end of from? */
  asm jNE  bk40		/* nope */
        beol = 2;	/* a CR is the last byte of from */
  asm   dec BX		/* ignore that last byte */
  asm   jmp bk90
bk40:
  asm cmp  byte ptr [SI],LF	/* is next character a LF? */
  asm jNE  bk20			/* no */
  asm   inc BX			/* skip the LF */
  asm   jmp bk80


bk70:
  beol = 1;		/* copied all of from */
  asm jmp bk90
bk80:
  beol = 0;		/* filled to or found EoL */
bk90:
  asm mov  AL,0		/* terminate string */
  asm stosb

  asm pop DS

  return _BX;
}


    /* pc_blkmov(to,from,n)
     */
void pc_blkmov(to,from,n) char *to, *from;
{
  asm {
    push DS

    mov  CX,n

    lES  DI,to
    lDS  SI,from

    cld
    rep movsb

    pop DS
  }
}
