/*
 *	HPTERM.C  MODULE
 * C Durland	Public Domain
 */

/*
 * The routines in this file provide support for HP style terminals
 * over a serial line. The serial I/O services are provided by routines in
 * "termio.c".
 */

#include <stdio.h>
#include "ed.h"
#include "term.h"

#define NROW    24	/* Screen size: 24 (HP150), 25 (VGER,2648) */
#define NCOL    80

int t_nrow = NROW -1, t_ncol = NCOL, tcolor = 0, mcolor = 1;
void term_parm();

void t_move(row,col)
int row,col;
{
  t_putchar(ESC); t_putchar('&'); t_putchar('a');
  term_parm(row); t_putchar('r'); term_parm(col);
  t_putchar('C');
}

void t_eeol()	/* erase to end of line */
{ t_putchar(ESC); t_putchar('K'); }

void t_eeop()	/* clear to end of display */
{ t_putchar(ESC); t_putchar('J'); }

void t_beep()
{
  extern int beeper;

  if (beeper) { t_putchar(BEL); t_flush(); }
}

void t_open()
{
  t_puts("\033&s1A");	/* transmit fcns ON */
  ttopen();
}

void t_close()
{
  t_puts("\033&s0A");	/* transmit fcns OFF */
  ttclose();
}

	/* 1: curcolor may not be correct - force color
	 * 2: switch color (if not already curcolor)
	 * 3: same as 2 but at beginning of line
	 */
void setcolor(color,x)
{
  if (x==3)	/* only color text and modelines */
    switch (color)
    {
      case 0: t_puts("\033&d@"); break;	/* normal */
      case 1: t_puts("\033&dJ"); break;	/* half bright inverse video */
    }
}

/************** Below: support routines not needed elsewhere **************/

static void term_parm(n)	/* convert n to ascii and ship it out */
register int n;
{
  register int q;

  q = n/10;
  if (q!=0) term_parm(q);
  t_putchar( (n%10) +'0' );
}

