/*
 * HPkmap.c:	map hp terminal keys
 * C Durland	Public Domain
 */

#include "me2.h"
#include "term.h"

static char what[] = "@(#)HP Keymap";

/* Note: do *NOT* return a keycode with CTRL set.
 * Use the ASCII value key codes from terminal
 */
static struct { char *term_code; EKeyCode keycode; }
key_map[] =
{
  "A", SOFKEY|'C',	/* Up arrow */
  "B", SOFKEY|'D',	/* Down arrow */
  "C", SOFKEY|'E',	/* Right arrow */
  "D", SOFKEY|'F',	/* Left arrow */
  "G", CTRL+'A',	/* goto left margin */
#if 0	/* can't handle this yet */
  "G\033K",CTRL+'A',CTRL+'K',0,	/* shift clear line ^A^K */
#endif
  "J", SOFKEY|'G',	/* clear to end of display */
  "K", SOFKEY|'K',	/* clear to end of line */
  "L", SOFKEY|'M',	/* Insert_line */
  "M", SOFKEY|'L',	/* delete line */
  "P", SOFKEY|'H',	/* delete char */
  "Q", SOFKEY|'G',	/* Insert_Key ??? */
  "S", SOFKEY|'O', 	/* roll (shift) up */
  "T", SOFKEY|'P',	/* roll (shift) down */
  "U", SOFKEY|'J',	/* Next_Key */
  "V", SOFKEY|'I',	/* Prev_Key */
  "h", SOFKEY|'A',	/* home */
  "F", SOFKEY|'B',	/* end */
#if 0	/* can't handle this yet */
  "h\033J",CTRL+'L',0,0,	/* shift clear display */
#endif
  "&P", SOFKEY|'N',	/* Select_Key */
	/* and now the softkeys */
  "",0		/* end of table */
};

      /* buffer for keys that map to more than one ME key */
EKeyCode que[5];
int que_siz=0, que_ptr;

/* convert terminal codes to ME codes.
  only call this is TRIGGER is recieved.
  Returns TRUE ME code from table else FALSE.
  If another key is not waiting, assume user hit TRIGGER
  else grab next key and map
 NOTE: type ahead can really hose us here - we may not know the
	diff between the user hitting 2 keys and a fcn key sending
	2 keys.
*/
	/* convert terminal codes to ME codes. */
map_key(keycode) EKeyCode *keycode;
{
  EKeyCode c;
  register int j;

	/* is a key waiting? */
  if (!keywaiting()) return FALSE;	/* no */
	/* get code(s) */
  c = t_getchar();	/* I know this is a byte */
  
  que_siz = que_ptr = 0;	/* init que */
  if ('p'<=c && c<='w')		/* convert f1 to SOFKEY 1, etc */
	{ *keycode = SOFKEY | (c-0x3f); return TRUE; }
  for (j=0; *key_map[j].term_code; j++)	/* look up code */
    if (*key_map[j].term_code==c)	/* found at least part of it */
    {
      if (strlen(key_map[j].term_code)>1) t_getchar(); /*!!!KLUDGE*/
      *keycode = key_map[j].keycode;
      return TRUE;
    }
	/* not found in table so just stuff in que for ME to handle */
  que[que_siz++] = c;
  *keycode = TRIGGER;
  return TRUE;
}
