/*
 *	ANSI.C  MODULE
 * The routines in this file provide support for ANSI style terminals.
 * C Durland	Public Domain
 */

#include <stdio.h>
#include "ed.h"
#include "term.h"
#include "config.h"

#define NROW 25		/* Number of rows on screen (25 or 43) */
#define NCOL 80		/* Number of columns on screen */

extern void ttopen ();
void term_parm();

int t_nrow = NROW -1, t_ncol = NCOL;

void t_move(row,col)
{
  t_putchar(ESC); t_putchar('['); term_parm(row+1);
  t_putchar(';'); term_parm(col+1); t_putchar('H');
}

void t_eeol()	/* erase to end of line */
  { t_putchar(ESC); t_putchar('['); t_putchar('K'); }

void t_eeop()	/* erase to end of page or screen */
  { t_putchar(ESC); t_putchar('['); t_putchar('J'); }

void t_beep()
{
  extern int beeper;

  if (beeper) { t_putchar(BEL); t_flush(); }
}

void t_open()
{
#if V7
  register char *cp;
  char *getenv();

  if ((cp = getenv("TERM")) == NULL)
  {
    puts("Shell variable TERM not defined!");
    exit(1);
  }
  if (strcmp(cp, "vt100") != 0)
  {
    puts("Terminal type not 'vt100'!");
    exit(1);
  }
#endif
  ttopen();
}

#if !FASTVIDEO
int tcolor = 0, mcolor = 7;

	/* 1: curcolor may not be correct - force color
	 * 2: switch color (if not already curcolor)
	 * 3: same as 2 but at beginning of line
	 */
void setcolor(color,x) unsigned int color;
{
  static int curcolor = -1;	/* current color */

  if (curcolor==color && x!=1) return;
  curcolor = color;
  t_putchar(ESC); t_putchar('['); term_parm(color/100);
  t_putchar(';'); term_parm(color%100); t_putchar('m');
}
#endif

/************** Below: support routines not needed elsewhere **************/

static void term_parm(n) register int n;
{
  register int q;

  q = n/10;
  if (q != 0) term_parm(q);
  t_putchar((n%10) + '0');
}
