/*
 * MISC.C	miscellaneous support routines
 */

/* Copyright 1990, 1991, 1992 Craig Durland
 *   Distributed under the terms of the GNU General Public License.
 *   Distributed "as is", without warranties of any kind, but comments,
 *     suggestions and bug reports are welcome.
 */

#include <const.h>

    /* An incrementing block copier for C libraries that don't have
     *   memmove() (or memcpy()).  It increments to avoid problems with
     *   overlapping moves (for the type of block moves I'm doing).
     */
void blkmov(to,from,n) register char *to, *from; register unsigned int n;
	{ while (n--) *to++ = *from++; }

#if 0
void ltoa(buf, width, num)
  register char buf[]; register int width; register long int num;
{
  buf[width] = '\0';		/* End of string. */
  while (num >= 10)		/* Conditional digits. */
	{ buf[--width] = (num%10) +'0'; num /= 10; }
  buf[--width] = num +'0';		/* Always 1 digit. */
  while (width!=0) buf[--width] = ' ';	/* Pad with blanks. */
}
#endif


#include <char.h>
unsigned char _cmap[256];	/* character map */

void fix_cmap(case_fold)
{
  register int c;

  for (c = 256; c--; ) _cmap[c] = case_fold ? toupper(c) : c;
}
