/*
 *  HELP.C: The "User Friendly" part of ME
 */

/* Copyright 1990, 1991, 1992 Craig Durland
 *   Distributed under the terms of the GNU General Public License.
 *   Distributed "as is", without warranties of any kind, but comments,
 *     suggestions and bug reports are welcome.
 */

#include "me2.h"
#include "mm.h"
#include "bind.h"
#include "config.h"

extern Buffer *Mid_to_buffer();		/* in mmaux.c */
extern char *nanex(), *strcpy(), *strcat(), *strchr();
extern int msize, pbsize, svsize;
extern MMDatum RV, TV;			/* in mm.c */
extern MuttCmd mutcmds[], sysvars[];
extern PgmName pnames[];			/* mmaux.c */

static int ranger2_file();

/* ******************************************************************** */
/* ************************** *Help* Buffer *************************** */
/* ******************************************************************** */

typedef struct { UKey *keys; int num_keys; } Keymap;

/* Convert binding table entry to readable text form.
 * Lists all keys that are bound to program i.
 * Returns TRUE if program has at least one key bound to it.
 * Format of returned string:
 *   name-of-function
 *   name-of-function ..........C-3
 */
static int verbose(buf,i, keymaps_to_search, num_maps)
  char *buf; Keymap *keymaps_to_search; int i, num_maps;
{
  int j, s, num_keys;
  UKey *key;

  strcpy(buf,pnames[i].name);
  i = pnames[i].index;

  s = TRUE;
  for (; num_maps--; keymaps_to_search++)
    for (num_keys = keymaps_to_search->num_keys,
	 key = keymaps_to_search->keys;
         num_keys--; key++)
      if (PGM == key->type && key->index == i)
      {
	strcat(buf," ");
	if (s)
	{
	  for (j = strlen(buf); j < 27; j++) buf[j] = '.'; buf[j] = '\0';
	  s = FALSE;
	}
	xpandkey(buf,key->keycode);
      }

  return !s;
}

static int dpunt;		/* a global helper variable */

static void add_help_string(bp,pattern,text)
  Buffer *bp; char *text, *pattern;
{
  extern char *str_in_str();

  if (dpunt) return;
  if (str_in_str(text, pattern)) dpunt = !buffer_append(bp,text);
}

/* (list-keys buffer-id word flags keymap ...)
 * Put a list of command names and the keys bound to them in a buffer.
 * Input:
 *   bp : Buffer to put the list in.
 *   word : If "" then all commands are listed, otherwise, just those
 *   	command with word in them are listed.
 *   flags:
 *     1 : Programs
 *     2 : Functions
 *     4 : System vars
 *     8 : Only list programs with a key attached.
 *   keymaps:
 *     Ids of keymaps to look in.
 */
void Mlist_keys()
{
  Buffer *bp;
  char *word, text[256];
  int i, xxx, flags;

  get2args(NUMBER,STRING,"list-keys");
  bp = Mid_to_buffer((int)RV.val.num);
  word = TV.val.str;
  get_nth_arg(2,NUMBER,"list-keys");
  flags = RV.val.num;

  dpunt = xxx = FALSE;
  
  if (flags & 1)
  {
    int n, num_maps;
    Keymap keymaps_to_search[20];

    if (!buffer_append(bp,"PROGRAMS:"))
    {
    opps:
      RV.val.num = FALSE;
      RV.type = BOOLEAN;
      return;
    }

    n = 3; num_maps = 0;
    while (maybearg(n++,NUMBER,"list-keys") && num_maps < 20)
    {
      int num_keys;
      UKey *keys;

      get_keymap_data((int)TV.val.num, &keys, &num_keys);
      keymaps_to_search[num_maps].keys = keys;
      keymaps_to_search[num_maps].num_keys = num_keys;
      num_maps++;
    }

    for (i = 0; i < pbsize; i++)
    {
      int always_list = !(flags & 8);
      
      if (verbose(text,i, keymaps_to_search, num_maps) || always_list)
	add_help_string(bp,word,text);
    }
    xxx = TRUE;
  }

  if (flags & 2)
  {
    if ((xxx && !buffer_append(bp,"")) || 
	!buffer_append(bp,"FUNCTIONS:")) goto opps;
    for (i = 0; i < msize; i++) add_help_string(bp,word,mutcmds[i].name);
    xxx = TRUE;
  }

  if (flags & 4)
  {
    if ((xxx && !buffer_append(bp,"")) || 
	!buffer_append(bp,"SYSTEM VARS:")) goto opps;
    for (i = 0; i < svsize; i++) add_help_string(bp,word,sysvars[i].name);
  }

  fixwin(bp);	/* !!!??? or fixWB() */

  RV.val.num = TRUE;
  RV.type = BOOLEAN;
}

void dscrib_key(keyname,boundto) char *keyname, *boundto;
{
  extern EKeyCode to_keycode();
  extern UKey *lookupkey();

  EKeyCode keycode;
  UKey *key;

  keycode = to_keycode(keyname,TRUE);
  *boundto = '\0';
  if ((key = lookupkey(keycode)))
  {
    register int n, i;
    register PgmName *pn;

    i = key->index;
    if (PGM == key->type)
    {
      for (pn = pnames, n = pbsize; n--; pn++)
	if (pn->index == i) { strcpy(boundto,pn->name); break; }
    }
  }
}


/* ******************************************************************** */
/* ************************ Command Completion ************************ */
/* ******************************************************************** */

	/* Constants for ranger2() */
#define REWIND	0
#define NEXT	1
#define OTHER	2
#define OTHER1	3

static int ranger2_buf(z, pptr) int z; char **pptr;
{
  static Buffer *bp;

  switch (z)
  {
    case REWIND: bp = first_buffer; return TRUE;
    case NEXT:
      for (;; bp = bp->nextb)
      {
	if (!bp) return FALSE;
	if (!(bp->b_flags & BFHIDDEN)) break;
      }
      *pptr = get_dString(bp->b_bname);
      bp = bp->nextb;
      return TRUE;
  }
  /* NOTREACHED */
}

#include <oman.h>

int ranger2_list(z, pptr) int z; char **pptr;
{
  static ListObject *list;
  static Object *obj;

  switch (z)
  {
    case REWIND: obj = list->elements; return TRUE;
    case NEXT:
      for (;; obj = obj->next_object)
      {
	if (!obj) return FALSE;
	if (OSTRING == obj->type) break;
      }
      *pptr = OBJSTRING(obj);
      obj = obj->next_object;
      return TRUE;
    case OTHER: list = (ListObject *)pptr; return TRUE;
  }
  /* NOTREACHED */
}

    /* 
     * Input:
     *   selector: OR the lists you want.
     * Notes:
     *   Assumes selector has valid bits (ie only valid bits set, at least
     *     one valid bit set) - mlreply() does this.
     *   File name completion is different:  If there are no entries in the
     *     completion list, need to bail out because otherwise whatever has
     *     been typed so far will be erased (in mlreply()).  Yet anther
     *     reason it doesn't make sense to mix file and other completion
     *     lists.
     */
complete(word,selector) char *word; unsigned int selector;
{
  char *ptr, commonchars[128], completed_word[128];
  int matched, max_matched = -1;
  unsigned int bit;

  selector &= CC_MASK;		/* turn off lists I can't complete */
  *completed_word = '\0';
  for (bit = 1; bit <= selector; bit <<= 1)
  {
    switch (selector & bit)
    {
      default: continue;	/* (selector & bit)==0 means do nothing */
      case CC_PGM:						/* Programs */
	if (ranger1(&pnames[0].name, pbsize,sizeof(PgmName),
	    word,&matched,commonchars)) return TRUE;
	break;
      case CC_MUTT:					   /* Mutt commands */
	if (ranger1(&mutcmds[0].name,msize,sizeof(mutcmds[0]),
	   word,&matched,commonchars)) return TRUE;
	break;
      case CC_BUF:					    /* Buffer names */
	if (ranger2(ranger2_buf,word,&matched,commonchars)) return TRUE;
	break;
      case CC_SYSVAR:					/* System Variables */
	if (ranger1(&sysvars[0].name,svsize,sizeof(sysvars[0]),
	   word,&matched,commonchars)) return TRUE;
	break;
      case CC_FNAME:					      /* File names */
        ptr = word;		/* just change the name & extension */
	if (!ranger2_file(OTHER, &ptr)) return FALSE;
	if (ranger2(ranger2_file,ptr,&matched,commonchars)) return TRUE;
	break;
      case CC_LIST:					 /* List of strings */
	if (ranger2(ranger2_list,word,&matched,commonchars)) return TRUE;
	break;
    }
    if (0 == matched) continue;
    if (matched > max_matched)
    {
      max_matched = matched; strcpy(completed_word,commonchars);
      continue;
    }
    if (matched == max_matched)
    {
      while (completed_word[matched]!='\0' &&
	     completed_word[matched] == commonchars[matched]) matched++;
      completed_word[matched] = '\0';
    }
  }
	/* if filename completion, don't change the path */
  strcpy((selector & CC_FNAME) ? ptr : word, completed_word);

  return TRUE;
}


/* ******************************************************************** */
/* ************************ Questionable Help ************************* */
/* ******************************************************************** */

#define MAX_HELP_LEN 40

static int drow, dcol, dink, dlen;	/* global helper variables */
static void dumper();

	/* spew match word list all over screen */
void hbomb(word,selector) char *word; unsigned int selector;
{
  char *ptr;
  int j, len = strlen(word);

  drow = dcol = dink = dpunt = 0; dlen = MAX_HELP_LEN;

  if (selector & CC_PGM)				       /*  Programs */
    for (j = 0; j < pbsize; j++) dumper(pnames[j].name,word,len);

  if (selector & CC_MUTT)				  /*  Mutt commands */
    for (j = 0; j < msize; j++) dumper(mutcmds[j].name,word,len);

  if (selector & CC_BUF)				   /*  Buffer names */
  {
    ranger2_buf(REWIND, (char **)NULL);
    while (ranger2_buf(NEXT, &ptr)) dumper(ptr,word,len);
  }

  if (selector & CC_SYSVAR)			       /*  System Variables */
    for (j = 0; j < svsize; j++) dumper(sysvars[j].name,word,len);

  if (selector & CC_FNAME)				     /*  File names */
  {
    ranger2_file(OTHER1, word);
    while (ranger2_file(NEXT, &ptr)) dumper(ptr,"",0);
  }

  if (selector & CC_LIST)				 /* List of strings */
  {
    ranger2_list(REWIND, (char **)NULL);
    while (ranger2_list(NEXT, &ptr)) dumper(ptr,word,len);
  }

  if (dcol == 0) dumper("------------------------","",0);
}

static void dumper(name,word,len) char *name, *word;
{
  extern int t_nrow, t_ncol;

  char text[MAX_HELP_LEN+2];

  if (dpunt) return;
  if (t_nrow-1 <= drow)		/* this column hit the bottom of the screen */
  {				/* use next column */
    dcol += dink +3; dlen = imin(t_ncol - dcol, MAX_HELP_LEN);
    if (dlen < 15)		/* screen full, ask if they want more */
    {
      if (dpunt = (mlyesno("More") != TRUE)) return;	/* no, they don't */
      dcol = 0; dlen = MAX_HELP_LEN;
    }
    drow = dink = 0;
  }
  if (strncmp(name,word,len) == 0)
  {
    strncpy(text,name,dlen); text[dlen] = '\0';	
    dink = imax(dink,strlen(text));
    vpputs(drow++,dcol, text, TRUE);
  }
}


#if FILENAME_COMPLETION

/* ******************************************************************** */
/* ****************** File Name Completion and Help ******************* */
/* ******************************************************************** */

/* Note:  The memory used for the file names is kept around once its
 *   allocated on the assumation that if its used once its going to be used
 *   lots.  Growth is limited by FHEAP_SIZE.  This can greatly limit memory
 *   trashing.
 */

extern char *ext();

#define FHEAP_SIZE 3072
static struct { int fnames, j; char heap[FHEAP_SIZE]; } fheap;

static char *extensions_to_ignore[] = 
#if UX_OS
  { ".o", ".mco", NULL };
#endif
#if MSDOZ
  { ".OBJ", ".MCO", NULL };
#endif
#if ATARI
  { ".o", ".mco", ".O", ".MCO", NULL };
#endif

static int build_fheap(fname) char *fname;
{
  char **ptr = extensions_to_ignore;
  int n = strlen(fname) +1;

  if (fheap.j + n > FHEAP_SIZE) return 2;
  while (*ptr) if (strcmp(*(ptr++),ext(fname)) == 0) return 0;
  strcpy(fheap.heap + fheap.j,fname); fheap.j += n;
  fheap.fnames++;
  return 0;
}

static declare_and_init_dTable(ftable,char *);

static void build_ftable()
{
  register char *ptr, **qtr;
  register int n = fheap.fnames;

  reset_dTable(&ftable);
  if (!xpand_dTable(&ftable, n, 100,20)) return;
  ptr = fheap.heap; qtr = ftable.table;
  while (n--)
  {
#if MSDOZ
    lowercase(ptr);
#endif
    *qtr++ = ptr;
    while (*ptr++) ;
  }
}

compare2strings(a,b) char **a, **b; { return strcmp(*a,*b); }

static void zik(fname) char *fname;
{
  char zim[256];

  fheap.fnames = fheap.j = 0;
  strcpy(zim,fname);
  if (!strchr(nanex(fname),'*')) strcat(zim,"*");
  fxpand(zim,FALSE,TRUE,TRUE,(char *)NULL,build_fheap);
  build_ftable();
  ssort(ftable.table,sizeof_dTable(&ftable),dTable_BLOBSIZE(&ftable),
	compare2strings);
}

static int ranger2_file(z, pptr) int z; char **pptr;
{
  static int n;

  switch (z)
  {
    case REWIND: n = 0; return TRUE;
    case NEXT:
      if (n == sizeof_dTable(&ftable)) return FALSE;
      *pptr = ftable.table[n++];
      return TRUE;
    case OTHER:			/* set up for complete */
    {
      char *fname;

      fname = *pptr;
      if ('\0' == *(*pptr = nanex(fname)))	/* Can't complete "foo/" */
	return FALSE;
      zik(fname);
      return (0 != sizeof_dTable(&ftable));
    }
    case OTHER1:		/* set up for hbomb */
      n = 0;
      zik((char *)pptr);
      return TRUE;
  }
  /* NOTREACHED */
}

#else

static int ranger2_file(z, pptr) int z; char **pptr; { return FALSE; }

#endif /* FILENAME_COMPLETION */
