/*
 * config.h:  Configure ME
 */

/* Craig Durland	Public Domain
 *   Distributed "as is", without warranties of any kind, but comments,
 *     suggestions and bug reports are welcome.
 */


#include <os.h>		/* For the OS types */

/* Note:
 * Compile line options (set in Makefile) used here:
 *   PCIO : IBM PC I/O
 *   XIO  : X11 I/O
 */

    /* Fast Video.
     * IBM PC (MS-DOS), X11	Usual case: 1
     * Everybody else		Usual case: 0
     */
#if PCIO || XIO
#define FASTVIDEO	1	/* PC's, X11 */
#else
#define FASTVIDEO	0	/* Everybody else */
#endif /* PCIO || XIO */

   /* What FAST routine to call to see if a key is in the input que.  Used
    *   by the display routines to check to see if redisplay should be
    *   interrupted.
    * Usual case: wait_for_key(0)
    * Other cases:
    *   key_waiting():  Use with X11
    *   FALSE:  If there is no FAST key waiting routine
    *   pending():  If a routine named pending exists and should be used.
    */
#if XIO
#define PENDING		key_waiting()	/* X11 */
#else
#define	 PENDING	wait_for_key(0)	/* Usual case */
#endif /* XIO */


   /* Where to look for Mutt programs if no ME3 environment variable.  You
    *   only need this if you are setting up ME for lots of people or want
    *   things to "just work".
    * If USE_DEFAULT is 1, set the search path to where you are going to put
    *   the .mco files that everybody will use.
    *   Worst case:  "/usr/local/me3:/usr/contrib/me3"
    *   I prepend "$HOME" so you can put a few personal .mco files (like
    *     myme.mco) in a users home directory if needed.  Prepending also
    *     allows you to replace autoloaded files (for example, your own
    *     cmode.mco).
    * MS-DOS:  Set to 1.  $HOME is not prepended.
    * Notes:
    *   The path is OS specific.  For Unix and MS-DOS, its the same format
    *     as the $PATH variable:  paths separated by ":" (Unix) or ";"
    *     (MS-DOS).  See (load-code) in me3mutt.doc for more info.
    */
#if UX_OS	 /* Unix */
#define USE_DEFAULT_MUTT_SEARCH_PATH	1
#define DEFAULT_MUTT_SEARCH_PATH	"/usr/local/me3:/usr/contrib/me3"
#endif /* UX_OS */

#if MSDOZ	/* MS-DOS */
#define USE_DEFAULT_MUTT_SEARCH_PATH	1
#define DEFAULT_MUTT_SEARCH_PATH  	"C:/me3"			
#endif /* MSDOZ */

#ifndef USE_DEFAULT_MUTT_SEARCH_PATH
#define USE_DEFAULT_MUTT_SEARCH_PATH	0
#endif

   /* 1 if support compute server:  Simple case (when in doubt): 0
    *   Unixes that support sockets (BSD, HP-UX):     1
    *   Other Unixes (True SysV (like Apollo SysV)):  0
    *   MS-DOS: 0
    *   atarST TOS/MiNT: 0
    * Note:  If 0, you don't need to build the comserver directory.
    */
#if UX_OS	 /* Unix */
#define COMPUTE_SERVER	1
#endif /* UX_OS */

#ifndef COMPUTE_SERVER
#define COMPUTE_SERVER	0
#endif


    /* Block move routines:
     * blkmov(void *to, const void *from, size_t n);
     * Two types:
     *   Overlapping block move:	memmove, bcopy or blkmov.
     *   Non-overlapping block move:	memcpy or blkmov.	
     */
#define BLKMOV	blkmov			/* Usual case: blkmov */
#define BLKCPY	blkmov			/* Usual case: blkmov */


   /* Code for fopen() to open a file for binary reads.
    * ANSI C, MS-DOS, most Unixes use: "rb"
    * DEC Unix: "r".  (This is the only system that I've found that has
    *   problems with rb.  I really hate details like this!)
    */
#define FOPEN_BINARY	"rb"		/* Usual case: "rb" */


   /* Command completation lists that can't be supported.
    *   CC_FNAME  : File name completion.
    *     If your system can't compile fxpand.c (utility program) or you
    *       want a smaller ME
    * Usual case: 0
    */
#define NO_COMPLETE	0


	/* 1 if using Line EDitor package.  Usual case: 1 */
#define LED		1


	/* Window flag debug (window.c mline.c).  Usual case: 0 */
#define WFDEBUG 	0


/* ******************************************************************** */
/* ************** Don't modify the stuff below! *********************** */
/* ******************************************************************** */

#define CC_MASK (CC_ALL & ~NO_COMPLETE)	    /* command completation flags */

#define FILENAME_COMPLETION (CC_MASK & CC_FNAME)

	/* Keyboards used with UNIX.  Usual case:  both 0 */
	/* !!! Not fully supported.  See Unixio.c !!! */
#define HPKB		0	/* HP escape sequences */
#define PCKB		0	/* IBM PC "high bit set" keyboard */
