/* 
 * case.c : do case operations on text.
 */

/* Copyright 1990, 1991, 1992 Craig Durland
 *   Distributed under the terms of the GNU General Public License.
 *   Distributed "as is", without warranties of any kind, but comments,
 *     suggestions and bug reports are welcome.
 */

#define LOWER_CASE	0
#define UPPER_CASE	1
#define CAPITALIZE	2

#define CASE_MATCH	6

#define CASE_NOOP	20

#include <char.h>
#include "me2.h"

int case_text(text, n, op)
  char *text;
  int n, op;
{
  register unsigned char c;
  register int start_word, last_char_is_ws;

  if (n < 0) return FALSE;

  if (op == CASE_NOOP) return TRUE;

  last_char_is_ws = TRUE;
  while (n--)
  {
    c = *text;
	/* ws  wd => 1
	 * ws  ws => 0
	 * wd  wd => 0
	 * wd  ws => 0
	 */
    start_word = (last_char_is_ws && isword(c));
    last_char_is_ws = !isword(c);

    switch (op)
    {
      case LOWER_CASE: c = tolower(c); break;
      case UPPER_CASE: c = toupper(c); break;
      case CAPITALIZE: c = (start_word ? toupper(c) : tolower(c)); break;
    }
    *text = c;
    text++;
  }
  return TRUE;
}
