/*
 *  BIND.H :  Some of the glue that ties keys, Mutt and help together.
 */

/* Craig Durland	Public Domain
 *   Distributed "as is", without warranties of any kind, but comments,
 *     suggestions and bug reports are welcome.
 */

#ifndef __BIND_H_INCLUDED
#define __BIND_H_INCLUDED

	/* user key binding stuff */
#define PGM 0
#define SYS 1

typedef struct		/* keys bound to programs */
{
  EKeyCode keycode;	/* Key code used to invoke it */
  uint8 type;		/* PGM or SYS */
  uint16 index;		/* index into array */
} UKey;

typedef declare_dTable_of(UKey) KeyTable;

typedef struct		/* All the ME Mutt extensions */
{
  char *name;		/* Name of Mutt extension */
  short int token;	/* If the name was a number, this be it */
} MuttCmd;

typedef struct		/* program name table */
{
  char *name;		/* name of the program */
  short int index;	/* names code is at pgm_table[index] */
} PgmName;

#endif	/* __BIND_H_INCLUDED */
