/* !!! TO DO !!!
 *   turn off spawning a shell
 *   cut buffer
 *   Worry about all 4 columns in the keymap, probably need a switch
 *   real menus
 */

/*
 * X.c : X11 Window System driver for ME
 * C Durland	Public Domain
 * ??/??, 1/94
 */

static char what[] = "@(#)ME X11 driver";

#ifdef __STDC__

#ifdef __hpux			/* for ANSI C on HP-UX */
#define _HPUX_SOURCE
#endif  /* __hpux */

#ifdef __apollo			/* for ANSI C on Apollo BSD */
#define _BSD_SOURCE
#endif	/* __apollo */

#ifdef _AIX			/* for ANSI C on IBM AIX */
#define _ALL_SOURCE
#endif  /* _AIX */

#endif	/*  __STDC__ */

#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysymdef.h>

#include <os.h>
#if BSD_OS || POSIX_OS || AIX_OS
#include <sys/time.h>

#else	/* SYSV_OS */

#include <time.h>
#endif

#include "driver.h"

#define PROPORTIONAL_FONTS	0  /* Attempt to support proportional fonts */
#define PRINT

extern char 
  **zargv,			/* in main.c */
  *strchr(), *strcpy(), *getenv();

extern int
  doing_nothing, zargc,		/* main.c */
  dont_spawn;			/* spawn.c */

/* ******************************************************************** */
/* ************************* Stuff from me2.h ************************* */
/* ******************************************************************** */

	/* Stuff from me2.h since I can't include me2.h because it conflicts
	 * with X.h
	 */

#define RESIZE_HOOK	0
#define PROCESS_HOOK	1

/* ******************************************************************** */
/* *********************************  ********************************* */
/* ******************************************************************** */

#include <ed.h>
#include <const.h>

#include <char.h>	/* !!! temp */

int mcolor = 0, tcolor = 1;	/* DON'T change! */

int t_nrow, t_ncol;

static void init_cursor(), cursor_on(), cursor_off(), I_have_focus();
void t_putchar(), t_flush();

typedef unsigned long int Pixel;

static Display *display;
static short int crow, ccol;
static GC text_gc, modeline_gc, cursor_gc;
static Window window;

/* ******************************************************************** */
/* ****************************** Fonts ******************************* */
/* ******************************************************************** */

extern XFontStruct *XLoadQueryFont();

static int fixed_width_font;
static int
    /* Width of biggest character in font, including intercharacter space */
  cwidth,
  cheight,	/* Pixels needed for a character, including space */
  cascent;
static XFontStruct *font;

#if PROPORTIONAL_FONTS
static short int font_widths[256];
#endif

#define RtoY(row)  ((row)*cheight)		/* row to top left of char */
#define RtoYc(row) (RtoY(row) + cascent)	/* row to baseline */
#define CtoX(col)  ((col)*cwidth)

#define CHAR_XY(row,col) CtoX(col),RtoYc(row)

#define YtoR(y)	   ((y) / cheight + 1)
#define XtoC(x)	   ((x) / cwidth  + 1)

    
static int load_font(fontname) char *fontname;
{
  XFontStruct *f;

  if (NULL == (f = XLoadQueryFont(display,fontname))) return FALSE;
  font = f;

  fixed_width_font = (font->min_bounds.width == font->max_bounds.width);

#if PROPORTIONAL_FONTS
  if (!fixed_width_font)
  {
    int n,z;
    XCharStruct *font_chars = font->per_char, *fchar;

    for (n = 0; n < 256; n++)
    {
      if (n < font->min_char_or_byte2 || font->max_char_or_byte2 < n)
	   z = font->default_char;
      else z = n - font->min_char_or_byte2;
      fchar = &font_chars[z];
      font_widths[n] = fchar->width;
    }
  }
#endif	/* PROPORTIONAL_FONTS */

  cwidth  = font->max_bounds.width;		/* MCWIDTH(font); */
/*  ((font)->max_bounds.rbearing - (font)->min_bounds.lbearing)	/*  */
  cheight = font->max_bounds.ascent + font->max_bounds.descent;
  cascent = font->max_bounds.ascent;

  init_cursor();

  return TRUE;
}

    /* Return a character width that can be used to calculate the window
     *   width.
     */
static int window_char_width()
{
#if PROPORTIONAL_FONTS
  return (fixed_width_font ? cwidth : font_widths['n']);
#else
  return cwidth;
#endif	/* PROPORTIONAL_FONTS */
}

/* ******************************************************************** */
/* ****************************** Color ******************************* */
/* ******************************************************************** */

static Colormap color_map;

static char
  text_color_fg[30], text_color_bg[30],
  modeline_color_fg[30], modeline_color_bg[30],
  cursor_color[30];

#define TEXT_FG		0
#define MODELINE_FG	1
#define CURSOR_FG	2
#define TEXT_BG		3	/* this needs to be the FIRST background */
#define MODELINE_BG	4

static char pixel_is_real[10];	/* initialized to all FALSE */
static Pixel pixels[10];

static int get_color(n,pixel) Pixel *pixel;
{
  if (pixel_is_real[n]) { *pixel = pixels[n]; return TRUE; }
  return FALSE;
}

static int xcolor(color, save_color, gc, n)
  char *color, *save_color;
  GC gc;
  int n;
{
  XColor rgb, z;

  if (color && *color && XAllocNamedColor(display, color_map, color, &rgb, &z))
  {
    if (pixel_is_real[n])
      XFreeColors(display,color_map, &pixels[n], 1, (unsigned long)0);
    strcpy(save_color, color);
    if (n < TEXT_BG) XSetForeground(display,gc,rgb.pixel);
    else	     XSetBackground(display,gc,rgb.pixel);
    pixels[n] = rgb.pixel;
    pixel_is_real[n] = TRUE;

    return TRUE;
  }
  return FALSE;
}

static void me_color(color, fg, bg) char *color, *fg, *bg;
{
  strcpy(color, fg);
  strcat(color, ":");
  strcat(color, bg);
}


    /* "forground:background"
     *   ":"      => no change
     *   "color"  => only change foreground
     *   "color:" => only change foreground
     *   ":color" => only change background
     * Returns:
     *   If set, returns if everything worked (eg set both colors), etc.
     */
int do_color(which, color, set) char *color;
{
  if (set)
  {
    char buf[300], *ptr;
    int s;

    strcpy(buf, color); /* lowercase(buf); */
    if (ptr = strchr(buf, ':')) *ptr++ = '\0';

    switch(which)
    {
      case TEXT_COLOR:
      {
	s = xcolor(ptr, text_color_bg, text_gc, TEXT_BG);
	if (s)
	{
	  Pixel pixel,p;

	  get_color(TEXT_BG, &pixel);
	  XSetWindowBackground(display, window, pixel);
	  if (get_color(CURSOR_FG, &p))
	    XSetForeground(display,cursor_gc, pixel ^ p);
	}
 	s |= xcolor(buf, text_color_fg, text_gc, TEXT_FG);
        break;
      }
      case MODELINE_COLOR:
	s = xcolor(buf, modeline_color_fg, modeline_gc, MODELINE_FG) |
	    xcolor(ptr, modeline_color_bg, modeline_gc, MODELINE_BG);
        break;
      case CURSOR_COLOR:
      {
	Pixel pixel, p;

	cursor_off();
	s = xcolor(buf, cursor_color, cursor_gc, CURSOR_FG);
	if (s && get_color(TEXT_BG, &pixel) && get_color(CURSOR_FG, &p))
	  XSetForeground(display,cursor_gc, pixel ^ p);
        break;
      }
      case CURSOR_SHAPE:	/* ??? */
change_cursor(color); return TRUE;
	return FALSE;
      default: return FALSE;			/* boo boo */
    } /* end switch */

    return s;
  }
  else	/* not set, just return the current value */
  {
    switch(which)
    {
      case TEXT_COLOR:
	me_color(color, text_color_fg, text_color_bg);
        break;
      case MODELINE_COLOR:
	me_color(color, modeline_color_fg, modeline_color_bg);
        break;
      case CURSOR_COLOR:
	strcpy(color,cursor_color);
        break;
      case CURSOR_SHAPE:
	strcpy(color,"can't be changed");
        break;
      default: return FALSE;			/* boo boo */
    }
  }

  return TRUE;
}

/* ******************************************************************** */
/* ******************************************************************** */
/* ******************************************************************** */

void t_move(row,col) { cursor_off(); crow = row; ccol = col; cursor_on(); }

static void clear_nchars(row,col,n)	/* clear n characters from (row,col) */
{
  XClearArea(display,window, CtoX(col),RtoY(row), cwidth*(n),cheight, FALSE);
}

void t_eeol()	/* erase to end of line */
{
  cursor_off();
  clear_nchars(crow,ccol, t_ncol - ccol);
  cursor_on();
}

void t_eeop()	/* erase to end of page or screen */
{ cursor_off(); XClearWindow(display,window); }

	/* Write a character to the display */
void t_putchar(c) char c;
{
  if (c == '\r' || c == '\n') return; /* ignore carriage return */
  cursor_off();
  if (c == '\b')	/* backspace */
  { 
    ccol--;
/*    clear_nchars(crow,--ccol,1);	/*  */
  }
  else
  {
    XDrawImageString(display,window,text_gc, CHAR_XY(crow,ccol), &c, 1);
    ccol++;
  }
  cursor_on();
}

    /* Fast video support for display.c for X
     * This needs to be as fast as possible.
     * Turn off the cursor to avoid leaving cursor droppings on the screen.
     *   Leave it off (but mark it as garbage so it will get redrawn) to
     *   avoid turning it on then off then on ... while repainting the
     *   screen.
     */
void putline(row, buf, attr)	/* note: row is 0 relative */
  int row,attr; char *buf;
{
  cursor_off();		/*  */

#if PROPORTIONAL_FONTS
  if (!fixed_width_font)	/* clear the line */
    XClearArea(display,window, 0,RtoY(row), t_ncol*cwidth,cheight, FALSE);
#endif	/* PROPORTIONAL_FONTS */

  XDrawImageString(display,window,
    attr ? text_gc : modeline_gc,
    CHAR_XY(row,0), buf, t_ncol);
  cursor_is_garbage();
}

void t_beep()
{
  extern int beeper;

  if (beeper) XBell(display,beeper);
  XFlush(display);
}

/* ******************************************************************** */
/* *************************** Command Line *************************** */
/* ******************************************************************** */

#include <X11/Xresource.h>

/* 
from lib/Xt/Initialize.c
	_XtPreparseCommandLine(
	XrmParseCommand(&db, options, num_options, ".", &targc, targv);
pruned
Page 462
XtGetApplicationResources()
*/

/*
 This is a set of default records describing the command line arguments that
 Xlib will parse and set into the resource data base.
 
 This list is applied before the users list to enforce these defaults.  This is
 policy, which the toolkit avoids but I hate differing programs at this level.
*/

static XrmOptionDescRec opTable[] = 
{
  {"-background", "*background", XrmoptionSepArg, (XPointer)NULL},
  {"-bd",	  "*borderColor",XrmoptionSepArg, (XPointer)NULL},
  {"-bg",	  "*background", XrmoptionSepArg, (XPointer)NULL},
  {"-bordercolor","*borderColor",XrmoptionSepArg, (XPointer)NULL},
  {"-borderwidth",".borderWidth",XrmoptionSepArg, (XPointer)NULL},
  {"-bw",	  ".borderWidth",XrmoptionSepArg, (XPointer)NULL},
  {"-cr",	  "*cursorColor",XrmoptionSepArg, (XPointer)NULL},
  {"-display",	  ".display",    XrmoptionSepArg, (XPointer)NULL},
  {"-fg",	  "*foreground", XrmoptionSepArg, (XPointer)NULL},
  {"-fn",	  "*font",	 XrmoptionSepArg, (XPointer)NULL},
  {"-font",	  "*font",	 XrmoptionSepArg, (XPointer)NULL},
  {"-foreground", "*foreground", XrmoptionSepArg, (XPointer)NULL},
  {"-geometry",	  ".geometry",	 XrmoptionSepArg, (XPointer)NULL},
  {"-iconic",	  ".iconic",	 XrmoptionNoArg,  (XPointer)"on"},
  {"-mlbg",	  "*modelineBackground", XrmoptionSepArg, (XPointer)NULL},
  {"-mlfg",	  "*modelineForeground", XrmoptionSepArg, (XPointer)NULL},
  {"-name",	  ".name",	 XrmoptionSepArg, (XPointer)NULL},
  {"-selectionTimeout",
		  ".selectionTimeout", XrmoptionSepArg,	(XPointer)NULL},
  {"-title",	  ".title",	 XrmoptionSepArg, (XPointer)NULL},
  {"-xrm",	  NULL,		 XrmoptionResArg, (XPointer)NULL},
};

static XrmDatabase db;

static void parse_command_line()
{
  XrmInitialize();
  db = 0;
  XrmParseCommand(&db, opTable, NITEMS(opTable), ".", &zargc, zargv);
}

static char *cmd_line_str(name, default_str) char *name, *default_str;
{
#if 0
  char *type[100];
  XrmValue val;

  if (XrmGetResource(db, name, name, type, &val))
    return val.addr;
#else
  XrmName name_list[3];
  XrmName class_list[3];
  XrmRepresentation type;
  XrmQuark _XtQString;
  XrmValue val;

  _XtQString = XrmPermStringToQuark("String");

  name_list[0] = XrmPermStringToQuark(".");
  name_list[2] = NULLQUARK;

  name_list[1] = XrmPermStringToQuark(name);
  if (XrmQGetResource(db, name_list, name_list, &type, &val) &&
      type == _XtQString)
    return val.addr;
#endif

  return default_str;
}

static int cmd_line_color(which, fg, resource, default_color)
  char *resource, *default_color;
{
  if (fg)
    return do_color(which, cmd_line_str(resource, default_color), TRUE);
  else
  {
    char buf[300];

    strcpy(buf,":");
    strcat(buf, cmd_line_str(resource, default_color));
    return do_color(which, buf, TRUE);
  }
  /* NOTREACHED */
}

/* ******************************************************************** */
/* ****************************** Open X ****************************** */
/* ******************************************************************** */

/*
 * This function is called once to set up the terminal device streams.
 */
void t_open()
{
  char *dname, **targv;
  int win_x,win_y, win_width,win_height, border_width;
  int targc;
  XGCValues gcv;		/* struct for creating GC */
  XSizeHints size_hints;	/* Size hints for window manager */
  XWMHints wm_hints;

  static int doodaa = FALSE;

  if (doodaa) return;
  doodaa = TRUE;

  dont_spawn = TRUE;	/* Real pain to recover if you spawn a shell */

  que_version_info("display-driver", "X", (char *)NULL);

	/* save a copy of the command line for the window manager */
  targc = zargc;
  targv = (char **)malloc(zargc * sizeof(char *));	/* !!!check */
  memcpy(targv,zargv,zargc * sizeof(char *));

  parse_command_line();

	/* open display */
  dname = cmd_line_str("display", getenv("DISPLAY"));
  if (dname == NULL || (display = XOpenDisplay(dname)) == NULL)
  {
    puts("Can't open display.");
    exit(1);
  }

	/* load a font */
  if (
    !load_font(cmd_line_str("font", "hp8.10x20b"))			&&
    !load_font("-bitstream-prestige-medium-r-normal--19-160-72-72-m-110-iso8859-1") &&
    !load_font("-bitstream-terminal-medium-r-normal--18-140-100-100-c-110-iso8859-1") &&
    !load_font("-dt-interface user-medium-r-normal-l serif-19-160-72-72-m-110-iso8859-1") &&
    !load_font("courr18")		&&
    !load_font("user11x19")		&&
    !load_font("-adobe-medium-bold-o-normal--18-180-75-75-m-110-iso8859-1") &&
    !load_font("fixed"))
  {
    puts("Could not load a font.");
    exit(1);
  }

		/* Select colors */
  color_map = XDefaultColormap(display, DefaultScreen(display));

  border_width = 5;

  {
    int x,y, bits;
    unsigned int w,h;
    bits = XParseGeometry(cmd_line_str("geometry",""), &x,&y, &w,&h);

    t_ncol = 80; if (bits & WidthValue)  t_ncol = w;
    t_nrow = 32; if (bits & HeightValue) t_nrow = h - 1;

		/* width and height of the window */
    win_height = (t_nrow + 1)*cheight;
    win_width  = t_ncol*window_char_width();
    win_x = (DisplayWidth( display, DefaultScreen(display)) - win_width)  /4;
    win_y = (DisplayHeight(display, DefaultScreen(display)) - win_height) /4;
    if (bits & XValue)
    {
      if (bits & XNegative)
	win_x = DisplayWidth(display, DefaultScreen(display)) - 
		win_width - 2*border_width + x;
      else win_x = x;
    }
    if (bits & YValue)
    {
      if (bits & YNegative)
	win_y = DisplayHeight(display,DefaultScreen(display)) -
		win_height - 2*border_width + y;
      else win_y = y;
    }
  }

	/* Create Window. See  section 3.3 */
  window = XCreateSimpleWindow(display, DefaultRootWindow(display),
	win_x,win_y, win_width,win_height,
	border_width,
	WhitePixel(display, DefaultScreen(display)),
	BlackPixel(display, DefaultScreen(display)));
      
  wm_hints.flags = InputHint;
  wm_hints.input = True;

  size_hints.flags = (PPosition | PSize | PWinGravity);
  size_hints.win_gravity = CenterGravity;
/* !!! resize increment hints, also change if font changes. */

  XmbSetWMProperties(display,window,
	"ME", "ME", targv,targc,
	&size_hints, &wm_hints, (XClassHint *)NULL);

#if 0
      /* Ensure that the window's colormap field points to the default 
         colormap, so that the window manager knows the correct colormap to
	 use for the window. See Section 3.2.9 also, set the window's Bit
         Gravity to reduce expose events
       */
XSetWindowAttributes xwa;
  xwa.colormap = DefaultColormap(display, DefaultScreen(display));
  xwa.bit_gravity = CenterGravity;
  XChangeWindowAttributes(display,window, CWColormap, &xwa);
#endif

  gcv.font = font->fid;
  gcv.function = GXcopy;
  text_gc = XCreateGC(display,window, GCFunction | GCFont, &gcv);

  modeline_gc = XCreateGC(display,window, GCFont, &gcv);

  gcv.function = GXxor;
  cursor_gc = XCreateGC(display,window, GCFunction, &gcv);

    /* color:  If possible, use the colors specified on the command line.
     *   If none specified, use my favorites.  If those don't work, use
     *   black and white (always available on all visuals).
     */
  if (!cmd_line_color(TEXT_COLOR, TRUE,  "foreground", "wheat")		||
      !cmd_line_color(TEXT_COLOR, FALSE, "background", "DarkSlateGrey"))
    do_color(TEXT_COLOR,"white:black", TRUE);
  if (!cmd_line_color(MODELINE_COLOR, TRUE,  "modelineForeground", "black")  ||
      !cmd_line_color(MODELINE_COLOR, FALSE, "modelineBackground", "wheat"))
    do_color(MODELINE_COLOR,"black:white", TRUE);
  if (!cmd_line_color(CURSOR_COLOR, TRUE, "cursorColor", "green"))
    do_color(CURSOR_COLOR, "white", TRUE);


	/* Specify event types of interest. See sections 8.5 & 8.4.5.1 */
  XSelectInput(display,window,
	ExposureMask | StructureNotifyMask | FocusChangeMask |
	KeyPressMask | ButtonPressMask
	);

	/* Map the window to make it visible. see section 3.5. */
  XMapWindow(display,window);
XFlush(display);

	/* do some clean up */
  if (db) XrmDestroyDatabase(db);
  if (targv) free((char *)targv);
}

/*
 * This function gets called just before we go back home to the command
 * interpreter.
 */
void t_close()
{
}

/*
 * Flush terminal buffer.
 */
void t_flush() { XFlush(display); }	/* !!!needed? */

/* ******************************************************************** */
/* ****************************** Mouse ******************************* */
/* ******************************************************************** */

static MouseInfo mouse_info;

MouseInfo *get_mouse_info()
{
  return &mouse_info;
}

/* !!! PROPORTIONAL_FONTS support (ala cursor) for column */

static int process_button_event(event) XButtonEvent *event;
{
	/* Conveniently, Button1 == 1 ... Button5 == 5 */
  mouse_info.button	= event->button;
  mouse_info.row	= YtoR(event->y);
  mouse_info.column	= XtoC(event->x);
  mouse_info.state	= BUTTON_CLICK;
  mouse_info.modifiers	= Xmask_to_MEmask(event->state);

  return TRUE;
}

/* ******************************************************************** */
/* *************************** Misc X stuff *************************** */
/* ******************************************************************** */

static int resize_rows, resize_columns;

static void do_resize()
{
  display_resized(resize_rows, resize_columns);
}

static void configure_notify(configure_event) XConfigureEvent *configure_event;
{
  int w,h;

  w = configure_event->width; h = configure_event->height;

  resize_rows =    h / cheight;
  resize_columns = w / window_char_width();

  call_me_sometime(RESIZE_HOOK,do_resize);
}

/* ******************************************************************** */
/* ***************************** Waiting ****************************** */
/* ******************************************************************** */

extern int client_socket;		/* in process.c */
extern void process_talks();		/* in process.c */

#define MASK(fd)	(1 << (fd))

static int event_waiting(sec)
{
  int select_mask;
  int biggest_fd, fd, n, process_mask;
  struct timeval timeout;

  if (XPending(display)) return TRUE;

  fd = ConnectionNumber(display);
  select_mask = MASK(fd);

  process_mask = 0;
  if (client_socket != -1) process_mask = MASK(client_socket);
  select_mask |= process_mask;

  biggest_fd = imax(fd,client_socket) + 1;

  timeout.tv_sec = sec; timeout.tv_usec = 0;
  n = select(biggest_fd,&select_mask,0,0,&timeout);

  if (select_mask & process_mask)
    call_me_sometime(PROCESS_HOOK,process_talks);

  return n;
}

static int exposed = FALSE;

    /* Quickly check to see is a key is waiting.
     * Need to be quick so just check the head of the queue for a key event.
     */
int key_waiting()
{
  XEvent event;

  if (!exposed) return TRUE;
  if (!XPending(display)) return FALSE;
  XPeekEvent(display, &event);
  return (event.type == KeyPress);
}

   /* Wait for a key to be pressed for no more than sec seconds.
    * Use 0 seconds to check to see if a key is in the input que.
    */
wait_for_key(sec)	/* !!!! */
{
  if (sec == 0) return key_waiting();
  return event_waiting(sec);
}

/* ******************************************************************** */
/* **************************** Event Loop **************************** */
/* ******************************************************************** */

#define TICK 1

/*
 * Read a character from the terminal, performing no editing and doing no echo
 *   at all.  Map terminal softkeys, etc to ME keys.
 * For X, this also processes events.
 */
EKeyCode t_getchar()
{
  XEvent event;
  long int tick;

  tick = 0;
  while (TRUE)		/* stay here until a key is pressed */
  {
    while (doing_nothing && !event_waiting(TICK))
      do_idle_hook(tick += TICK);

    process_hooks();	/* ??? good place for this? */

    if (!XPending(display)) continue;

    XNextEvent(display,&event);
    
    switch(event.type)
    {
      case KeyPress:
      {
	unsigned int state;
	EKeyCode key;
	KeySym keysym;
	XKeyEvent *xkey;

/* !!!??? may have to return a no op key to keep wait_for_key() from keeping
 * main() from calling update() when, say, just the shift key is pressed
 */
	state = event.xkey.state;
	keysym = XLookupKeysym(&event.xkey, state & ShiftMask);
PRINT(">> %x %x => %x\n",state,(int)event.xkey.keycode,(int)keysym);
	if (!map_keysym(state,keysym,&key)) break;
PRINT("keypress event: %x %x => %x\n",state,(int)keysym,(int)key);
	return key;
      }

	/* On the last of each group of Expose events, repaint the entire
	 *   window. See Section 8.4.5.1.
	 */
      case Expose:
      {
	XWindowAttributes xwa;

	exposed = TRUE;	/*  */

	  /* Remove any other pending Expose events from the queue to avoid
	   *   multiple repaints.if (0 != event.xexpose.count) continue;
	   */
	while (XCheckTypedEvent(display,Expose,&event)) ;	/*  */
	if (doing_nothing) { redraw_screen(); update(); }	/* ick!!!??? */
	else return 0xC;		/* C-L, major sleeze!!! */
	break;
      }

      case ButtonPress:
	if (process_button_event((XButtonPressedEvent *)&event))
	  return MOUSE_KEY;
	break;

      case ConfigureNotify:
	configure_notify((XConfigureEvent *)&event);
	break;

      case FocusIn:
	I_have_focus(TRUE);
	break;
      case FocusOut:
	I_have_focus(FALSE);
	break;

    }	/* end switch */
  }	/* end while */
}

/* ******************************************************************** */
/* ****************************** Cursor ****************************** */
/* ******************************************************************** */

#define CURSOR_OFF	0
#define CURSOR_ON	1

static int
  cursor_state = CURSOR_OFF, solid_cursor = FALSE,
  cursor_x, cursor_width, cursor_height;

static void init_cursor()
{
  cursor_width  = cwidth - 1;
  cursor_height = cheight;
}

static void blink_cursor()	/* toggle the cursor */
{
  cursor_state = !cursor_state;
	/* put cursor between characters ie the real dot position */
  if (solid_cursor)
  {
    XFillRectangle(display, window, cursor_gc,
      cursor_x, RtoY(crow),    cursor_width, cursor_height);
  }
  else		/* hollow cursor */
  {
    XDrawRectangle(display, window, cursor_gc,
      cursor_x, RtoY(crow),    cursor_width, cursor_height);
  }
}

static void cursor_on()
{
  extern char *vttext;		/* in display.c */

  if (CURSOR_ON == cursor_state) return;

#if PROPORTIONAL_FONTS
  if (!fixed_width_font && crow != t_nrow)
  {
    char *ptr;
    int n,z;
    XCharStruct *font_chars = font->per_char, *fchar;

    vtmove(crow,0); ptr = vttext;
    cursor_x = 0;
    for (n = ccol; n--; ) cursor_x += font_widths[*ptr++];
    cursor_width = font_widths[*ptr] - 1;
  }
  else
  {
    cursor_width = cwidth - 1;
    cursor_x = CtoX(ccol) + 1;
  }
#else

  cursor_x = CtoX(ccol) + 1;

#endif	/* PROPORTIONAL_FONTS */

  blink_cursor();
}

static void cursor_off()
{
  if (CURSOR_ON == cursor_state) blink_cursor();
}

static void I_have_focus(yes)
{
  int state = cursor_state;

  if (yes == solid_cursor) return;
  cursor_off();
  solid_cursor = yes;
  if (state == CURSOR_ON) cursor_on();
  XFlush(display);
}

#include <X11/cursorfont.h>

change_cursor(shape) char *shape;
{
  Cursor cursor;
  unsigned int x;
  int s;
  XSetWindowAttributes xwa;

  x = atoi(shape);
  cursor = XCreateFontCursor(display,x);
  xwa.cursor = cursor;
  XChangeWindowAttributes(display,window, CWCursor, &xwa);

  return TRUE;
}

/* ******************************************************************** */
/* **************************** Selections **************************** */
/* ******************************************************************** */

#if 0


    if (tw->core.window == XGetSelectionOwner(XtDisplay(tw),
						  XA_PRIMARY))
       XtDisownSelection(w, XA_PRIMARY, 
			 XtLastTimestampProcessed(XtDisplay(w)));



#endif

/* ******************************************************************** */
/* ******************************* misc ******************************* */
/* ******************************************************************** */

void sig_pause(dummy)
{
  mlwrite("sig_pause not implemented");
}
