/*
 * supp.c : support routines for the Mutt compiler
 * 	label routines
 */
 
/* Copyright 1990, 1991, 1992 Craig Durland
 *   Distributed under the terms of the GNU General Public License.
 *   Distributed "as is", without warranties of any kind, but comments,
 *     suggestions and bug reports are welcome.
 */

#include <stdio.h>
#include <os.h>
#include <dtable.h>
#include "mm.h"
#include "mc.h"

extern address pcaddr();
extern char
  ebuf[],
  *save_string(), *spoof();
extern FILE *lstfile;	/* in mc.c */

/* ******************************************************************** */
/* ************************** Error Routines ************************** */
/* ******************************************************************** */

extern char *muttfile;			/* in mc.c */
extern int srcline, errors, warnings;	/* in mc.c */

void errmsg(errtype,msg) char *errtype, *msg;
{
  char buf[300];

  spoof(buf,"%s %d %s: %s\n",muttfile,srcline,errtype,msg);
  if (lstfile) fputs(buf,lstfile);
  fputs(buf,stdout);
}

int no_warn = FALSE, no_gripe = FALSE;

void gripe(msg) char *msg; { if (!no_gripe) errmsg("Note",msg); }
void groan(msg) char *msg;
{
  warnings++; if (!no_warn) errmsg("Warning",msg);
}
void moan(msg)  char *msg; { errors++;   errmsg("Error",msg); }
void bitch(msg) char *msg; { moan(msg);  exit(1); }

	/* Internal error : print message and bail out */
bail(msg) char *msg;
{
  fprintf(stderr,"Internal error!  %s\n",msg);
  exit(1);
}

/* ******************************************************************** */
/* ******************************* Misc ******************************* */
/* ******************************************************************** */

is_object_type(type)
{
  return (type == LIST || type == STRING);
}

/* ******************************************************************** */
/* ************************** Label Routines ************************** */
/* ******************************************************************** */

static declare_and_init_dTable(label_table, address);

genlabel()
{
  static int labels = 0;

  if (!xpand_dTable(&label_table, 1, 100,100))
    bail("Out of memory! Can't expand label table.");
  
  label_table.table[labels] = NIL;
  return labels++;
}

address getlabel(label) { return label_table.table[label]; }

void stufflabel(label)
{
  if (lstfile) fprintf(lstfile,"%4u: L%d:\n",pcaddr(),label);
  label_table.table[label] = pcaddr();
}

/* ******************************************************************** */
/* **************************** Type info ***************************** */
/* ******************************************************************** */

typesize(type) unsigned int type;
{
  if ((type & POINTER) || type == BLOB) return sizeof(int32);
  switch(type)
  {
    case INT8: case BOOLEAN: case STRING: return sizeof(uint8);
    case INT16: return sizeof(int16);
    case INT32: return sizeof(int32);
    case FCNPTR: moan("typesize(FCNPTR)"); return 4;
  }
  /* NOTREACHED */
}

unsigned int mmtype(type) unsigned int type;
{
/*if (type & MCTYPE) bitch(spoof(ebuf,"mmtype(%d): not a MMable type.",type));*/
  if (type & POINTER) return BLOB;
  switch (type)
  {
    case INT8: case INT16: case INT32: return NUMBER;
  }
  return type;
}

char *keyword_type_name(type)
{
  switch (type)
  {
    case KWMutt:	return "Mutt keyword";
    case KWoMutt:	return "oMutt keyword";
    case KWXToken:	return "external token";
    case KWGlobalVar:	return "global variable";
    case KWLocalVar:	return "local variable";
    case KWConst:	return "constant";
    case KWProgram:	return "program";
    case KWProto:	return "arg prototype";
  }
  return "Unknown";
}

/* ******************************************************************** */
/* ************************ Consts ************************************ */
/* ******************************************************************** */

extern KeyWord *global_look_up(), *global_look_for(), *global_check();

/* Here is where I save (const foo <value>) */

typedef struct { char *name; MMDatum rv; } Const;

static int nconsts = 0;

static declare_and_init_dTable(consts, Const);

#define CID_TO_CONST(n) (&consts.table[n].rv)
MMDatum *cid_to_const(n) { return CID_TO_CONST(n); }

MMDatum *getconst(name) char *name;
{
  KeyWord *kw;

  if (kw = global_look_for(name, KWConst)) return CID_TO_CONST(kw->token);
  return NULL;
}

void add_const(name,rv) char *name; MMDatum *rv;
{
  char *ptr;

  if (global_check(name)) return;

  if (!xpand_dTable(&consts, 1, 10,10))
    bail("Out of memory! Can't expand constant table.");

  ptr = save_string(name);
  consts.table[nconsts].name = ptr;
  consts.table[nconsts].rv = *rv;

  add_keyword(ptr, KWConst, nconsts, 3);

  nconsts++;
}

number_of_consts() { return nconsts; }

/* ******************************************************************** */
/* ***************************** Programs ***************************** */
/* ******************************************************************** */

typedef struct { char *name; address addr; uint8 flags; } PgmTable;

#define pid_to_Pgm(n) (&pgm_table.table[n])

static int num_pgms = 0;
static declare_and_init_dTable(pgm_table, PgmTable);

void pgm_init()
{
}

address get_pgm(name) char *name;
{
  KeyWord *kw;
  PgmTable *pgm;

  if ((kw = global_look_up(name)) && kw->type == KWProgram)
  {
    pgm = pid_to_Pgm(kw->token);
    if (pgm->flags & LEAR)	/* !!!??? */
      moan(spoof(ebuf,"%s is special and can't be used.",pgm->name));
    return pgm->addr;
  }

  return NIL;
}

int add_pgm(name) char *name;
{
  char *ptr;
  int i, flags, hash_it;
  KeyWord *kw;
  PgmTable *the_pgm;

  flags = 0;
  hash_it = TRUE;

  if (0 == strcmp(name,"MAIN"))
  {
    static int nth_main = 000;
    char main_name[20];

    sprintf(main_name,"MAIN-%04d",++nth_main);		/* MAIN-0001 */
    name = main_name;
    flags = (MAIN | HIDDEN | LEAR);
    hash_it = FALSE;	/* Don't put MAINs in the look up table */
  }

  if (find_local_var(name) != -1)
    moan(spoof(ebuf,"\"%s\" is a local variable or arg.",name));
  else
    if (kw = global_check(name))
    {
      if (kw->type == KWProgram) return kw->token;
      /* else go ahead and add it */
    }

  if (!xpand_dTable(&pgm_table, 1, 400,100))
    bail("Out of memory! Can't expand pgm table.");

  i = num_pgms++;
  the_pgm = pid_to_Pgm(i);

  ptr = save_string(name, TRUE);
  the_pgm->name = ptr;

  the_pgm->addr = pcaddr(); the_pgm->flags = flags;

  if (hash_it) add_keyword(ptr, KWProgram, i, 3);

  return i;
}

pgms() { return num_pgms; }
void modpgm(n,f)   { pid_to_Pgm(n)->flags |= f; }

address pgmaddr(n) { return      pid_to_Pgm(n)->addr;  }
char *pgmname(n)   { return      pid_to_Pgm(n)->name;  }
pgmflags(n)	   { return (int)pid_to_Pgm(n)->flags; }

	/* Return the id of the next pgm with id >= n, -1 if none */
get_main(n)
{
  for (; n < num_pgms; n++) if (pid_to_Pgm(n)->flags & MAIN) return n;
  return -1;
}

static int compare2pgms(a,b) PgmTable *a, *b;
{ return strcmp(a->name,b->name); }

void sort_pgms()
{
  ssort(pgm_table.table, num_pgms, sizeof(PgmTable), compare2pgms);
}

void print_entry_points(lstfile) FILE *lstfile;
{
  extern address entrypt;	/* in code.c */
  int j;

  fputs("\n   Program Table\nAddress    Name\n",lstfile);
  fprintf(lstfile," %5d     entry point\n",entrypt);
  for (j = 0; j < num_pgms; j++)
    fprintf(lstfile," %5d     %s\n",pgmaddr(j),pgmname(j));
}
