/* opcode.h : opcodes and opcode names for the Mutt Machine
 */

/* Craig Durland	Public Domain
 *   Distributed "as is", without warranties of any kind, but comments,
 *     suggestions and bug reports are welcome.
 */

	/* extern opcodes */
#define CONCAT		 1
#define MSG		 2
#define ASK		 3
#define INSERT_OBJ	 4
#define EXTRACT_EL	 5
#define EXTRACT_ELS	 6
#define REMOVE_ELS	 7

	/* op codes */
#define HALT		 0
#define DONE		 1

#define ASKUSER		 2

#define RVBOOL		 3
#define RVNUM8		 4
#define RVNUM16		 5
#define RVNUM32		 6
#define RVSTR		 7
#define RVVOID		 8

#define ADD		 9
#define SUB		10
#define MUL		11
#define DIV		12

#define CMP		13
#define NOT		14
#define LT		15
#define LTE		16

#define JMP		17
#define JMPTRUE		18
#define JMPFALSE	19

#define ARG		20
#define NARGS		21
#define PUSHARGS	22

#define PUSHRV		23
#define SHOVERV		24
#define DUP		25
#define POP		26

#define PUSHTOKEN	27
#define PUSHXT		28
#define PUSHNAME	29
#define PUSHADDR	30
#define FADDR		31

#define DOOP		32

#define TYPECHECK	33

#define LALLOC		34
#define GETLVAR		35
#define GETGVAR		36
#define SETLVAR		37
#define SETGVAR		38

#define RVLBASE		39
#define RVGBASE		40
#define GETRVAR		41
#define SETRVAR		42

#define CREATE_OBJ	43
#define LEN_OF		44

#define CONVERT_TO	45

#define STOP		46


#if OPNAMES

char *opname[] =	/* op code names */
{
  "halt",		/* HALT */
  "done",		/* DONE */

  "ask-user",		/* ASKUSER */

  "set-RV-to",		/* RVBOOL */
  "set-RV-to",		/* RVNUM8 */
  "set-RV-to",		/* RVNUM16 */
  "set-RV-to",		/* RVNUM32 */
  "set-RV-to",		/* RVSTR */
  "set-RV-to-VOID",	/* RVVOID */

  "add",		/* ADD */
  "subtract",		/* SUB */
  "multiply",		/* MUL */
  "divide",		/* DIV */

  "compare",		/* CMP */
  "not",		/* NOT */
  "<",			/* LT */
  "<=",			/* LTE */

  "jmp",
  "jmp-TRUE",		/* JMPTRUE */
  "jmp-FALSE",		/* JMPFALSE */

  "arg",		/* ARG */
  "num-args",		/* NARGS */
  "push-args",		/* PUSHARGS */

  "push-RV",		/* PUSHRV */
  "shove-RV",		/* SHOVERV */
  "dup",		/* DUP */
  "pop",		/* POP */

  "push-token",		/* PUSHTOKEN */
  "push-X-token",	/* PUSHXT */
  "push-name",		/* PUSHNAME */
  "push-address",	/* PUSHADDR */
  "fcn-addr",		/* FADDR */

  "do-OP",		/* DOOP */

  "typecheck",		/* TYPECHECK */

  "lalloc",		/* LALLOC */
  "get-local-var",	/* GETLVAR */
  "get-global-var",	/* GETGVAR */
  "set-local-var",	/* SETLVAR */
  "set-global-var",	/* SETGVAR */

  "local-vars",		/* RVLBASE */
  "global-vars",	/* RVGBASE */
  "get-var-rel",	/* GETRVAR */
  "set-var-rel",	/* SETRVAR */

  "create-object",	/* CREATE_OBJ */
  "length-of",		/* LEN_OF */

  "convert-to",		/* CONVERT_TO */

  "stop",		/* STOP */
};
#endif
