/* 
 * oman.h
 */

/* Craig Durland	Public Domain
 *   Distributed "as is", without warranties of any kind, but comments,
 *     suggestions and bug reports are welcome.
 */

#ifndef __OMAN_H_INCLUDED
#define __OMAN_H_INCLUDED

#include <dstring.h>

/* ******************************************************************** */
/* *********************** Atomic Object Types ************************ */
/* ******************************************************************** */

typedef struct Object
{
  struct Object *next_object;
  int type;
} Object;

typedef struct ObjectPool
{
  struct ObjectPool *next_pool;
  Object *first_object;		/* pointer to first object in pool */
  pfi gc_marker;
/*?????stash an int here that is passed in at create time and passed to sweeper??*/
/* need a free_object call back for unknown types */
} ObjectPool;

typedef struct
{
  Object object;
  long int number;	/* or 32 bits anyway */
} NumberObject;

typedef struct
{
  Object object;
  dString string;
} StringObject;

typedef struct
{
  Object object;
  Object *elements;
} ListObject;

/* To create your own type:
    typedef struct
    {
      Object object;
      Stuff thing;
    } YourType;
*/

/* ******************************************************************** */
/* ****************************** Macros ****************************** */
/* ******************************************************************** */

	/* return a pointer to the string in a string object */
#define OBJSTRING(object) ((StringObject *)object)->string.string
	/* return the value in a number object */
#define OBJNUMBER(object) ((NumberObject *)object)->number

#endif	/* __OMAN_H_INCLUDED */
