/*
 * mmsa.c : A MM front end to make a stand alone Mutt Machine
 *  Craig Durland 6/87	Public Domain
 */

#include <stdio.h>
#include <os.h>

extern int MMask_pgm;	/* in mm.c */
extern char result[];	/* in mm.c */

#include "mm.h"
extern uint8 *MMglobal_vars;		/* in mm.c */
extern void  *MMglobal_object_table;	/* in mm.c   Really a *Object[] */
extern MMDatum RV, TV;	/* in mm.c */
void MMbitch();

main(argc,argv) char *argv[];
{
  extern int MMask_pgm;

  MMask_pgm = TRUE;

  MMinitialize();
  MMload(argv[1],TRUE);	/* load and go */
  exit(0);
}

void MMset_hooks() {}			/* No hooks used by this stuff */
void MMgc_external_objects() {}		/* No external objects */

MMaux_fcn(name) char *name; { return FALSE; }
void MMxtoken(token) { MMbitch("Invalid Xtoken"); }

MMask(prompt,buf) char *prompt, *buf;
{
  printf("%s",prompt); gets(buf); return TRUE;
}

void MMmsg(str) char *str; { puts(str); }

void MMbitch(msg) char *msg;
{ printf("PGM ABORT(%u): %s\n",decodepc(),msg); MMabort_pgm(2); }

void MMmoan(msg) char *msg; { puts(msg); }

/* ******************************************************************** */
/* ************************ Program Management ************************ */
/* ******************************************************************** */

typedef struct		/* programs */
{
  char *name;		/* ascii name of command */
  maddr addr;		/* address of routine */
} PGM;

#define PGMMAX 100

PGM pgms[PGMMAX];
int pbsize = 0;
static maddr codeblock;

maddr MMpgm_addr(n) { return pgms[n].addr; }

maddr pcat();
decodepc() { return (int)(pcat() - codeblock); }

	/*  MMopen_code_file(name): open the code file.
	 *  name munged to contain name of opened file.
	 *  returns: ptr to opened file
	 */
FILE *MMopen_code_file(name) char *name;
{
  return fopen(name,"rb");
}

MMadd_pgm(name,tag,addr) char *name; maddr addr;
{
  if (pbsize >= PGMMAX) { MMmoan("pgm table OD"); return FALSE; }
  pgms[pbsize].name = name; pgms[pbsize].addr = addr; pbsize++;
  return TRUE;
}

void MMblock_name(buf,fname) char *buf,*fname;	/* create the block name */
{}

static char block_name[200];
static uint8 *lglobal_vars;
static void *lglobal_object_table;

MMadd_block(name,code,global_vars, global_object_table,num_global_objects)
  char *name; maddr code; uint8 *global_vars;
  void *global_object_table; int num_global_objects;
{
  strcpy(block_name,name);
  codeblock = code;
  lglobal_object_table = global_object_table;
  lglobal_vars = global_vars;

  return 0;
}

	/* Use binary search to find pgm
	 * returns index of token if found
	 * -1 if not found
	 */
MMpgm_lookup(name) char *name;
{
  register int  j, lower=0, upper=pbsize-1, x;

  while (lower<=upper)
  {
    j = (lower+upper)/2;
    if ((x = strcmp(name,pgms[j].name))>0) lower = j +1;
    else if (x<0) upper = j -1; else return j;
  }
  return -1;
}

void MMset_block(block_id)
{
  MMglobal_vars		= lglobal_vars;
  MMglobal_object_table = lglobal_object_table;
}

maddr MMblock_code()
{
  return codeblock;
}

/* ******************************************************************** */
/* ****************************** Debug ******************************* */
/* ******************************************************************** */

MMtrace_back(op, level, block, addr) maddr addr;
{
  char *name;
  int i, offset;
  PGM *ptr;

#if 0
  printf("abase = %d, vbase = %d, numargs = %d, varstack size = %d\n",
	abase,vbase,numargs,vsptr);
#endif
  if (0 == level) puts("~~~~~~ Trace Back ~~~~~~~~");

#if 0	/* not sorted by addr */
  if (addr < pgms[0].addr)
  {
    offset = addr - codeblock;
    name = "Start";
  }
  else
  {
    ptr = NULL;
    for (i = 0; i < pbsize - 1; i++)
      if (pgms[i].addr <= addr && addr < pgms[i+1].addr)
      {
	ptr = &pgms[i];
	name = ptr->name;
	offset = addr - ptr->addr;
	break;
      }
    if (!ptr)
    {
      ptr = &pgms[pbsize - 1];

      name = ptr->name;
      offset = addr - ptr->addr;
    }
  }
#else
  offset = addr - codeblock;
  name = "Start";
#endif

  printf("%d: %d in %s (%s + %d)\n",
    level, addr - codeblock, block_name, name, offset);
}
