/* mm.h : stuff for the Mutt machine
 */

/* Craig Durland	Public Domain
 *   Distributed "as is", without warranties of any kind, but comments,
 *     suggestions and bug reports are welcome.
 */

#ifndef __MM_H_INCLUDED
#define __MM_H_INCLUDED

/* ******************************************************************** */
/* ******** Stuff you can modify (but probably don't need to) ********* */
/* ******************************************************************** */

#define INTELCPU 0	/* such as 8086, 80286, etc.  0 if anything else */

#define RSIZ 300	/* max size of result string */

#define OSTACKSIZ 30	/* max operators on op stack */
#define ASTACKSIZ 200	/* max args on arg stack */
#define VSTACKSIZ 1500	/* number of bytes for stack frames, local vars ... */

	/* A Mutt code identifier and version controller */
#define MM_MAGIC_NUMBER 0xB1

/* ******************************************************************** */
/* ******** You should NOT modify anything below this line ************ */
/* ******************************************************************** */

	/* types inbedded in MUTT code */
typedef uint16 address;			/* used to create pc offsets */
typedef uint8  *maddr;			/* MUTT machine address */

   /* MMDatum types:  one byte.
    * Used in Mutt programing so be careful if you change the order!
    */
#define VOID	  0x01
#define STRING	  0x02		/* string constant */
#define NUMBER	  0x03
#define REAL	  0x04
#define BOOLEAN   0x05
#define BLOB	  0x06
#define FCNPTR	  0x07
#define OSTRING	  0x08		/* string object */
#define LIST	  0x09		/* list of objects */
#define CHARACTER 0x0A		/* Don't use! This is a place holder */

/* ??? get rid of blob and have: */
#if 0
/* arrays and (asc) might cause problems */
/* would have to implement (cast) */
#define PSTRING	  0x10
#define PNUMBER	  0x11
#define PREAL	  0x12
#define PBOOLEAN  0x13
#endif

	/* subtypes (not MMDatums) */
#define INT8	  0x81
#define INT16	  0x82
#define INT32	  0x83
	/* op code types */
#define OPMASK	  0xC0	/* to select one of the op cmds */
#define OPADDRESS 0xC0
#define OPNAME 	  0xC1
#define OPTOKEN	  0xC2
#define OPXTOKEN  0xC3
#define OPONAME   0xC4		/* same as OPNAME except name is a OSTRING */

typedef struct			/* MM's basic datum structure */
{
  uint8 type;
  union
  {
    char *str;
    int32 num;
    uint8 *blob;
    maddr addr;
    void *object;
  } val;
} MMDatum;

typedef struct MMStkFrame		/* a Mutt Machine stack frame */
{
  maddr pc;
  int startframe,
      abase,		/* where the args start */
      vbase,		/* where the local vars start */
      vsptr,
      numargs;		/* number of args in this frame */
  uint8 *gvars;		/* where the global variables are */
  struct MMStkFrame *prev_stkframe;

  int block_id;

  int lobj_max, lobj_start;
  void *global_object_table;
} MMStkFrame;

/* ******************************************************************** */
/* ********************* Code File Header Format ********************** */
/* ******************************************************************** */

#define H_ENTRY_POINT		 0	/* 2 bytes */
#define H_BYTES_OF_CODE		 2	/* 2 bytes */
#define H_NAME_TABLE_OFFSET	 4	/* 2 bytes */
#define H_NUMBER_OF_PGMS	 6	/* 2 bytes */
#define H_BYTES_OF_GVARS	 8	/* 2 bytes */
#define H_MAGIC_NUMBER		10	/* 1 bytes */
#define H_NUM_GLOBAL_OBJECTS	11	/* 2 bytes */

#define BYTES_IN_HEADER		13

/* ******************************************************************** */
/* ******************************************************************** */
/* ******************************************************************** */

	/* pc is a (uint8 *) */
#define GET_UINT8(pc)	*(pc)
#define PUT_UINT8(pc,n)	*(pc) = (n)

#if INTELCPU

#define GET_INT16(pc)	*(int16 *) (pc)
#define GET_UINT16(pc)	*(uint16 *)(pc)
#define GET_INT32(pc)	*(int32 *) (pc)

#define PUT_INT16(pc,n)	 *(int16 *) (pc) = (n)
#define PUT_UINT16(pc,n) *(uint16 *)(pc) = (n)
#define PUT_INT32(pc,n)  *(int32 *) (pc) = (n)

#else	/* everybody else */

#define GET_INT16(pc)	(int16) (*(pc) | (*((pc)+1)<<8))
#define GET_UINT16(pc)	(uint16)(*(pc) | (*((pc)+1)<<8))
#define GET_INT32(pc)	\
	(int32)(*(pc) | ((int32)*((pc)+1)<<8) |\
	((int32)*((pc)+2)<<16) | ((int32)*((pc)+3)<<24))

#define PUT_INT16(pc,n)   (*(pc) = (n) & 0xFF, *((pc)+1) = ((n)>>8) & 0xFF)
#define PUT_UINT16(pc,n)  (*(pc) = (n) & 0xFF, *((pc)+1) = ((n)>>8) & 0xFF)
#define PUT_INT32(pc,n)	  \
	(*(pc) = (n) & 0xFF, *((pc)+1) = ((n)>>8) & 0xFF, \
	*((pc)+2) = ((n)>>16) & 0xFF, *((pc)+3) = ((n)>>24) & 0xFF)

#endif

#define GET_ADDRESS(pc)	  GET_UINT16(pc)
#define PUT_ADDRESS(pc,n) PUT_UINT16(pc,n)

#ifndef TRUE
#define FALSE   0
#define TRUE    1
#endif

#endif	/* __MM_H_INCLUDED */
