/* mc.h : stuff for Mutt compiler
 */

/* Craig Durland	Public Domain
 *   Distributed "as is", without warranties of any kind, but comments,
 *     suggestions and bug reports are welcome.
 */

#define MAXSTRLEN 255	/* max length of a string (MUST be < RSIZ!) */
#define MAXDIM 2	/* max dimensions for an array */

typedef struct
{
  char *name;
  short int type, token;
} KeyWord;

	/* KeyWord types */
#define KWMutt		0	/* Mutt keyword (like if, while, etc) */
#define KWoMutt		1	/* Other Mutt keywords (like ask, concat) */
#define KWXToken	2	/* External token */
#define KWGlobalVar	3	/* Global Vars */
#define KWLocalVar	4	/* Local Vars */
#define KWConst		5	/* Constants */
#define KWProgram	6	/* Programs */
#define KWProto		7	/* Prototypes */

typedef struct
{
  char *name;
  short int token;
} MuttCmd;

typedef struct
{
  char *name;
  short int token;
  unsigned short int class;
} oMuttCmd;

typedef struct
{
  char *name;
  unsigned int type, sub_type;
	/* offset:
	 *   from var base (first var of same scope)
	 *   nth object object 
	 */
  int offset;
  uint8 scope;	/* LOCAL, GLOBAL or PROTYPE */
  int blobs;	/* if this is a protoype or structure */
  int dims, dim[MAXDIM];	/* if its an array */
} Var;

	/*  Var types */
#define LOCAL		1
#define GLOBAL		2
#define PROTOTYPE	3

#define NIL 0

	/* pgm modifiers */
#define HIDDEN	0x01
#define MAIN	0x02
#define LEAR	0x04

	/* additional token classes returned by get_token()
	 * these MUST NOT overlap val types (in mm.h)
	 */
	/* OR'able values */
#define POINTER	   0x0100
	/* Can't OR the following.  Use low byte for value. */
#define MCTYPE	   0x4000
#define TOKEN	   0x4001
#define DELIMITER  0x4002
#define SEOF	   0x4003
#define VAROK	   0x4004
#define PUSHEDARGS 0x4005
#define UNKNOWN    0x4006
#define ARRAY	   0x4007
#define EMPTY	   0x4008


	/* DELIMITER types */
#define START_EXP	'('
#define END_EXP		')'

#define START_PGM	'{'
#define END_PGM		'}'

#define START_IPGM	'<'
#define END_IPGM	'>'



#if 0		/* Some interesting macros I don't use anymore */

/* ******************************************************************** */
/* ********************* TABLES *************************************** */
/* ******************************************************************** */

extern char *malloc(), *realloc();

#define DYNO(type,table,n,initial_size,step)			\
{								\
  static int table_max = 0;					\
  if (n==table_max)	/* table not big enough */		\
  {								\
    if (table_max==0)	/* table not allocated yet */		\
    {								\
      table_max = initial_size;					\
      if ((table = (type *)malloc(table_max*sizeof(type)))==NULL)	\
	bitch("Can't malloc table");				\
    }								\
    else	/* table full, make bigger */			\
    {								\
      table_max += step;					\
      if ((table = (type *)realloc(				\
	(char *)table,table_max*sizeof(type)))==NULL)		\
		bitch("Can't realloc table");			\
    }								\
  }								\
}

#define DYNAMO(type,table,n,bump,initial_size,step)		\
{								\
  static int table_max = 0;					\
  if (n+bump>=table_max)	/* table not big enough */	\
  {								\
    if (table_max==0)	/* table not allocated yet */		\
    {								\
      table_max = initial_size;					\
      if ((table = (type *)malloc(table_max*sizeof(type)))==NULL)	\
	bitch("Can't malloc table");				\
    }								\
    else	/* table full, make bigger */			\
    {								\
      table_max += imax(n+bump-table_max,step);			\
      if ((table = (type *)realloc(				\
	(char *)table,table_max*sizeof(type)))==NULL)		\
		bitch("Can't realloc table");			\
    }								\
  }								\
}

#endif
