/* dhash.h : Header file for dhash.c
 * Very close to <search.h> - hsearch(3C) support minus the stuff for
 *   lsearch(3C) and tsearch(3C).
 */

#ifndef __DHASH_H_INCLUDED
#define __DHASH_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

#ifdef __STDC__
  typedef struct entry { char *key; void *data; } ENTRY;
#else
  typedef struct entry { char *key, *data; } ENTRY;
#endif

typedef enum { FIND, ENTER } ACTION;

#ifdef __STDC__
  extern int hcreate(unsigned);
  extern void hdestroy(void);
  extern ENTRY *hsearch(ENTRY, ACTION);
  extern void *htable(void *);
#else
  extern int hcreate();
  extern void hdestroy();
  extern ENTRY *hsearch();
  extern void *htable();
#endif

#ifdef __cplusplus
}
#endif

#endif /* __DHASH_H_INCLUDED */
