/* xpandkey.c : 
 * C Durland
 */

/* Craig Durland	Public Domain
 *   Distributed "as is", without warranties of any kind, but comments,
 *     suggestions and bug reports are welcome.
 */

#include "ed.h"

extern EKeyCode Eprefixes[];	/* in getkey.c */

static void ktoa(buf,keycode) char *buf; EKeyCode keycode;
{
  char foo[2];

  foo[1] = '\0';
  if (keycode & META)   strcat(buf,"M-");
  if (keycode & SHIFT)  strcat(buf,"S-");
  if (keycode & CTRL)   strcat(buf,"C-");
  if (keycode & SOFKEY) strcat(buf,"F-");
  
  *foo = keycode & 0xFF;	/* get rid of modifier bits */
  strcat(buf,foo);
}  


   /* Convert a EKeyCode to a something that is printable.
    * Example output:  a, A, C-A, M-A, S-F-A, C-XC-C, etc.
    * Warning:  Make sure buf is NULL terminated BEFORE you call this!
    *   (because strcat() is used).
    */
void Expand_key(pkeys,keycode,buf) PKey *pkeys; EKeyCode keycode; char *buf;
{
  register int j;

	/* check for PFIX1, 2 or 3.  META handled automatically. */
  for (j = 1; j < PKEYS; j++) if (Eprefixes[j] & keycode) ktoa(buf,pkeys[j]);
  ktoa(buf,keycode);
}
