/* tokc.c :  Convert a key string to EKeyCode
 * For example:
 *   "A" => A
 *   "^A" => C-A
 *   "C-A" => C-A
 * Input:
 *   key_text : pointer to text to convert.
 *   prefixable : 
 * C Durland
 */

/* Copyright 1990, 1991 Craig Durland
 *   Distributed under the terms of the GNU General Public License.
 *   Distributed "as is", without warranties of any kind, but comments,
 *     suggestions and bug reports are welcome.
 */

#include <char.h>
#include <const.h>
#include "ed.h"

extern EKeyCode Eprefixes[];		/* in getkey.c */

EKeyCode Eto_keycode(pkeys,key_text,prefixable)
  PKey *pkeys; unsigned char *key_text;
{
  register EKeyCode keycode = 0;
  register unsigned char c;
  register int j;

  for (; c = *key_text; key_text++)
  {
    if (key_text[1] == '-')	/* maybe its something like "C-A" */
    {
      switch (c)
      {
	default: goto next;		/* must be just a dash */
	case 'C' : keycode |= CTRL;   break;
	case 'F' : keycode |= SOFKEY; break;
	case 'M' : keycode |= META;   break;
	case 'S' : keycode |= SHIFT;  break;
      }
      key_text++;
      continue;
    }
  next:
    if (iscntrl(c)) keycode |= CTRL | (c ^ 0x40);
    else
      if ((keycode & (CTRL | META | PFIX1 | PFIX2 | PFIX3)) &&
	  (keycode & SOFKEY) == 0) keycode |= TOUPPER(c);
      else keycode |= c;
    if (prefixable)
    {
      for (j = PKEYS; j--; )			/* check for prefix keys */
	if (keycode == pkeys[j]) { keycode = Eprefixes[j]; break; }
      prefixable = FALSE;
    }
  }
  return keycode;
}
