/* LED.h : 
 */

/* Craig Durland	Public Domain
 *   Distributed "as is", without warranties of any kind, but comments,
 *     suggestions and bug reports are welcome.
 */

#ifndef __LED_H_INCLUDED
#define __LED_H_INCLUDED

/* ******************************************************************** */
/* ************* LED functions **************************************** */
/* ******************************************************************** */

#define LF_CALLBACK	0
#define LF_EXTEND	1
		/* cursor movement */
#define LF_LEFT		2
#define LF_RIGHT	3
#define LF_BoL		4
#define LF_EoL		5
		/* delete characters */
#define LF_BS		6
#define LF_DEL_CHAR	7
#define LF_EEoL		8
#define LF_CLEAR_LINE	9
		/* misc user functions */
#define LF_QUOTE	10
#define LF_UQUOTE	11	/* UNIX like quote */
#define LF_TAB		12
		/* process control */
#define LF_UNDEF	13	/* not defined [yet] or undefine it */
#define LF_STOP		14	/* the last function has been done */
#define LF_ERROR	15	/* some kind of a error */
#define LF_DONE		16	/* I'm done, process my input */
#define LF_ABORT	17	/* I want to QUIT! */
#define LF_NOOP		18	/* do nothing */
#define LF_OK		LF_NOOP	/* everything is just peachy */
		/* ?? */
#define LF_UPDATE	19	/* sync the virtual and physical lines */
#define LF_REDRAW	20	/* the physical line is garbage */
#define LF_CTYNC	21	/* sync cursor */
#define LF_PROMPT 	22	/* Add prompt to the buffer */
		/* noninteractive functions */
#define LF_INSERT_STRING	23	/* insert a bunch of characters */
#define LF_INSERT_KEYCODE	24
#define LF_CLEAR_KEYMAP		25
#define LF_BINDKEY		26	/* bind a list of keys to fcns */
#define LF_PKEY			27	/* bind a prefix key list */

/* ******************************************************************** */
/* ************* LED Flags ******************************************** */
/* ******************************************************************** */

#define LFnohist	0x01		/* Don't save history */
#define LFrecdraw	0x02		/* Don't redraw on recurse */

/* ******************************************************************** */
/* ************* LED Errors ******************************************* */
/* ******************************************************************** */

#define LEmem		0		/* No memory */
#define LEunknown_fcn	1		/* unknown function */
#define LEbound		2		/* arg out of bounds */

#endif	/* __LED_H_INCLUDED */
