/* getkey.c : get a keycode from the <key device>
 * C Durland
 */

/* Copyright 1990, 1991 Craig Durland
 *   Distributed under the terms of the GNU General Public License.
 *   Distributed "as is", without warranties of any kind, but comments,
 *     suggestions and bug reports are welcome.
 */

#include <const.h>
#include <char.h>
#include "ed.h"

EKeyCode Eprefixes[] = { META, PFIX1, PFIX2, PFIX3 };

    /* Ectok(kc,part2) : character to keycode
     *   kc : keycode to convert
     *   part2: TRUE if kc might be part2 of prefixed ME key
     *     (eg in "ESC a" => ctok(a,TRUE) because second part of prefixed
     *     keys are always uppercase.  "SOFKEY a" => ktoc(a,FALSE) because
     *     softkeys get the whole keymap.  Prefix keys are listed in table
     *     above.)
     */
EKeyCode Ectok(kc,part2) register EKeyCode kc; register int part2;
{
  if ((kc & 0xFF00) == 0)    /* Only munge it if its not already a EKeyCode */
  {
    if (part2) kc = toupper(kc);		/* Force to uppercase */
    if (iscntrl(kc)) kc = CTRL | (kc ^ 0x40);	/* control a -> C-A */
  }
  return kc;
}

/* Read in a key.
 * Do the standard keyboard preprocessing.
 * Convert the keys to the internal character set.
 */
EKeyCode Eget_key(pkeys) PKey *pkeys;
{
  register EKeyCode kc;
  register int j;

  kc = Ectok(t_getchar(),FALSE);
  for (j = PKEYS; j--; )	/* check for prefix keys */
    if (kc == pkeys[j]) return Eprefixes[j] | Ectok(t_getchar(),TRUE);
  return kc;
}
