/* ed.h : stuff for Editors 
 */

/* Craig Durland	Public Domain
 *   Distributed "as is", without warranties of any kind, but comments,
 *     suggestions and bug reports are welcome.
 */

#ifndef _ED_H_INCLUDED		/* so this won't be included twice */
#define _ED_H_INCLUDED

/* ******************************************************************** */
/* ***************** KEYS ********************************************* */
/* ******************************************************************** */

#define CTRL    0x0100		/* Control flag, or'ed in */
#define META    0x0200		/* Meta prefix key aka PFIX 0 */
#define SHIFT	0x1000		/* a shifted sofkey */
#define PFIX1   0x0400		/* a prefix key */
#define PFIX2	0x2000		/* a prefix key */
#define PFIX3	0x4000		/* a prefix key */
#define SOFKEY  0x0800		/* soft key flag, or'ed in */
#define BUTTON  0x8000		/* mouse button or some such */

	/* A EKeyCode is 16 bits:  8 for flags, 8 for the character */
typedef unsigned short int EKeyCode;

  /* The pkeys array is: { META prefix, PFIX1, PFIX2, PFIX3 }
   * If there is no META prefix (ie a the keyboard has a real meta key),
   *   set the META prefix to SHIFT.
   * To turn off a a prefix key, set it to SHIFT.
   */

#define PKEYS 4			/* number of prefix keys */
typedef EKeyCode PKey;		/* what a prefix key is */

#define declare_pkeys(name,pfix0,pfix1,pfix2,pfix3)	\
  PKey name[PKEYS] = { pfix0,pfix1,pfix2,pfix3 }

/* ******************************************************************** */
/* ***************** Key Tables *************************************** */
/* ******************************************************************** */

#define clear_keytable(kt) reset_dTable(kt);

/* ******************************************************************** */
/* ***************** TABS ********************************************* */
/* ******************************************************************** */

	/* col is 0 relative */
#define BLANKS_IN_TAB 8
#define NEXT_TAB_STOP(col)		(((col)+BLANKS_IN_TAB)/BLANKS_IN_TAB)
#define PREVIOUS_TAB_STOP(col)		((col)/BLANKS_IN_TAB)
#define TSTOC(tabstop)			((tabstop)*BLANKS_IN_TAB)
#define NEXT_TAB_COLUMN_MINUS_1(col)	((col) | 7)
#define NEXT_TAB_COLUMN(col)		(NEXT_TAB_COLUMN_MINUS_1(col) +1)

/* ******************************************************************** */
/* *********** Routines in the ED lib ********************************* */
/* ******************************************************************** */

extern char *Efind_key(), *Ekalloc();
extern int Eset_pkey();
extern EKeyCode Ectok(), Eget_key(), Eto_keycode();
extern void Expand_key(), Eclear_keytable(), Epack_keytable(), Eunbind_key();

#endif	/* _ED_H_INCLUDED */
