/* comserver.h
 * Craig Durland	Public Domain
 */

/* ********************* Packets ***************************** */

#define CS_MAGIC		26	/* magic number */

	/* To client: */
#define CS_PROCESS_DONE		 0	/* format: op    pid exit_code */
#define CS_OUTPUT		 1	/* format: op    pid text */
#define CS_OUTPUT_ERR		 2	/* format: op    pid text */
#define CS_ERROR		 3	/* format: error pid error_code */
#define CS_PROCESS_ID		 4	/* format: op    pid */

	/* To both: */
#define CS_CLIENT_MSG		 5	/* format: op tag text */

	/* To server: */
#define CS_DISCONNECT		10	/* format: op */
#define CS_DIR			11	/* format: op directory */
#define CS_DO_IT		12	/* format: op */
#define CS_COMMAND		13	/* format: op command */
#define CS_SIGNAL		14	/* format: op pid signal */
#define CS_CREATE_PROCESS	15	/* format: op */
#define CS_NUKE_PROCESS		16	/* format: op pid */


	/* CS_ERROR codes: */
#define CS_ERROR_SERVER_DIED	0
#define CS_ERROR_PROTOCOL	1	/* protocol error */
#define CS_ERROR_READ		2	/* read error */


/* ********************* Structures ***************************** */

typedef struct
{
  int start, size;
  char buf[300];
} CSPacket;

typedef struct
{
  int type;
  union
  {
		/* to server */
    struct { int two_pipe; }	Process;
    struct { char *dir; }	Directory;
    struct { char *command; }	Command;
    struct { int pid, sig; }	Signal;
    struct { int pid; }		Nuke;

		/* to client */
    struct { int pid, exit_code; }	ProcessDone;
    struct { int pid; }			Pid;
    struct { int pid; char *text; }	Output;
    struct { int pid, error_code; }	Error;

		/* to both */
    struct { int dud, tag; char *msg; }	ClientMsg;
  } u;
} xPacket;
