/* client.c :  Routines for the client end of the client/server
 *	communications.
 */

/* Craig Durland	Public Domain
 *   I got the algorithms from MITs X11 source.
 *   Distributed "as is", without warranties of any kind, but comments,
 *     suggestions and bug reports are welcome.
 */

static char what[] = "@(#)Compute Server Client Support 2/2/92 v1.1 8/93";

/* ******************************************************************** */
/* ************************** Client Socket *************************** */
/* ******************************************************************** */

#ifdef __STDC__

#ifdef __hpux			/* for ANSI C on HP-UX */
#define _HPUX_SOURCE
#endif  /* __hpux */

#ifdef __apollo			/* for ANSI C on Apollo BSD */
#define _BSD_SOURCE
#endif	/* __apollo */

#ifdef _AIX			/* for ANSI C on IBM AIX */
#define _ALL_SOURCE
#endif  /* _AIX */

#endif	/*  __STDC__ */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <errno.h>


int CSopen_client_socket(socket_name, retries)
  char *socket_name; int retries;
{
  struct sockaddr_un unaddr;		/* UNIX socket data block */
  struct sockaddr *addr;		/* generic socket pointer */
  int addrlen;				/* length of addr */
  int fd;				/* socket file descriptor */

  unaddr.sun_family = AF_UNIX;
  strcpy (unaddr.sun_path, socket_name);

  addr = (struct sockaddr *)&unaddr;
#ifdef SUN_LEN	/* BSD44SOCKETS, SUN_LEN defined in sys/un.h on AIX */
  addrlen = SUN_LEN(&unaddr);
  unaddr.sun_len = strlen(unaddr.sun_path);
#else
#ifdef SCM_RIGHTS	/* 4.3bsd reno and later (e.g. 386bsd) */
  addrlen = sizeof(unaddr.sun_len) + sizeof(unaddr.sun_family) +
	    strlen(unaddr.sun_path) + 1;
#else
  addrlen = strlen(unaddr.sun_path) + sizeof(unaddr.sun_family);
#endif /* SCM_RIGHTS */
#endif /* SUN_LEN */

  /*
   * Open the network connection.
   */
  do
  {
    if ((fd = socket((int) addr->sa_family, SOCK_STREAM, 0)) < 0)
	return -1;

    if (0 == connect(fd, addr, addrlen)) break;
    else		/* error */
    {
      int olderrno = errno;

      (void) close(fd);
      if (olderrno != ENOENT || retries <= 0)
      {
	errno = olderrno;
	return -1;
      }
      sleep(1);
    }
  } while (retries-- > 0);

  return fd;
}
