/* SoundMax Integrated Digital Audio MMPM/2 driver CID uninstall REXX script */
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

say 'CID Uninstall for the SoundMax Integrated Digital Audio MMPM/2 drivers'
say 'Copyright 1999 Analog Devices Inc.'

os2bootPath = SysSearchPath('PATH', 'os2boot')
if os2bootpath \= ''
then bootDrive = filespec('drive', os2bootPath)
else
do
  say "Can't find boot drive! Aborting..."
  exit 1
end

/* copy installation files to bootdrive:\MMTEMP */
targetdir = bootDrive || '\MMTEMP'
mmpmtargetdir = bootDrive || '\\MMTEMP'
rc = SysMkDir(targetdir)
copy '*.* ' || targetdir

/* create custom cid response file */
targetrsp = 'cidinst.rsp'
rc = lineout(targetrsp, '/* Response file generated by MMPM/2 Install */',1)
rc = lineout(targetrsp, '')
rc = lineout(targetrsp, 'MMINSTSOURCE = "' || mmpmtargetdir || '"')
rc = lineout(targetrsp, 'MMINSTTARGET = "' || bootDrive || '"')
rc = lineout(targetrsp, 'CHANGECONFIG = "Y"')
rc = lineout(targetrsp, '')
rc = lineout(targetrsp, 'MMINSTGROUPS =')
rc = lineout(targetrsp, '   (')
rc = lineout(targetrsp, '   GROUP.17 = "SoundMax Integrated Digital Wave Audio=NUM=0,"')
rc = lineout(targetrsp, '   )')
rc = lineout(targetrsp)

Say 'Starting minstall...'
minstall ' /R:'||targetrsp '/L:cidinst.log'

call SysFileTree  bootDrive'\OS2\MDOS\WINOS2\*.ini', file
if file.0 \= 0
then do
	Say 'Uninstalling WinOS/2 driver'
	start '/win wininst' ' u ' || bootDrive'\OS2\MDOS\WINOS2\SYSTEM.INI'
end

if SysDestroyObject("<ICHAUDIO>") 
Then Do
	Say "SoundMax Audio folder successfully destroyed."
End 
Else Do
	Say "Unable to delete the SoundMax Audio folder."
End    

if SysDestroyObject("<WARPMIXSTRT>") 
Then Do
	Say "Warpmix successfully removed from the Startup folder."
End 
Else Do
	Say "Unable to remove Warpmix from the Startup folder."
End    

/* remove driver files from system */
mmpmdir = bootDrive || '\MMOS2\'
rc = SysFileDelete(mmpmdir'ichsnd.sys')
rc = SysFileDelete(mmpmdir'ichvdd.sys')
rc = SysFileDelete(mmpmdir'warpmix.exe')
rc = SysFileDelete(mmpmdir'warpmix.ico')
rc = SysFileDelete(mmpmdir'warpmix.ini')
rc = SysFileDelete(mmpmdir'DLL\cardinfo.dll')
rc = SysFileDelete(mmpmdir'HELP\audhelp.hlp')
rc = SysFileDelete(mmpmdir'HELP\warpmix.hlp')
rc = SysFileDelete(bootDrive'\OS2\MDOS\WINOS2\SYSTEM\ICHSNDW.DRV')

/* clean up */
rc = SysFileDelete(targetrsp)
rc = SysRmDir(targetdir)

Say 'SoundMax Audio MMPM/2 drivers successfully uninstalled'
Say 'The driver will not be loaded when OS/2 is restarted'

Exit 0