/* Samples script to get the lotto numbers */
/* The used channel (34 = ZDF) and page are for German TV */

/* NOTE:you can run only ONE teletext REXX script or
        the TELETEXT/2 application at the same time */

call RxFuncAdd 'rtvLoadFuncs', 'TVREXX', 'rtvLoadFuncs'
call rtvLoadFuncs

arg filename
channel=34
page=541
subpage=1
slot=3

handle = rtvOpen();
IF handle = "0"
 then DO
    say "Error: driver or moviecard not installed"
    EXIT
 END

/* instead of setChannel: get the frequency of the channel */
/* and set the frequency */
freq=rtvGetFrequencyByChannel(channel)
rc=rtvSetFrequency(handle, freq)

rec = rtvGetCachedPage(page,subpage,30);

day=substr(rec,111,10)
week=substr(rec,144,8)
lottonumber=substr(rec,298,21)
additionnumber=substr(rec,418,2)
supernumber=substr(rec,538,1)
game=substr(rec,658,13)
supersix=substr(rec,778,11)
lottofile = filename
ret = LINEOUT(lottofile, 'Ziehung Lotto:');
ret = LINEOUT(lottofile, day);
ret = LINEOUT(lottofile, week);
ret = LINEOUT(lottofile, 'Gewinnzahlen:');
ret = LINEOUT(lottofile, '6 aus 49:');
ret = LINEOUT(lottofile, lottonumber);
ret = LINEOUT(lottofile, 'Zusatzzahl:');
ret = LINEOUT(lottofile, additionnumber);
ret = LINEOUT(lottofile, 'Super Zahl:');
ret = LINEOUT(lottofile, supernumber);
ret = LINEOUT(lottofile, 'Spiel 77:');
ret = LINEOUT(lottofile, game);
ret = LINEOUT(lottofile, 'Super 6:');
ret = LINEOUT(lottofile, supersix);
ret = LINEOUT(lottofile, 'ohne Garantie !!!');
closeline = LINEOUT(lottofile);

closeret = rtvClose(handle);

EXIT

