/* Sample script to get the last stock news */
/* There are two stockvalues: actual day and yesterday */
/* The used channel (34 = ZDF) and page are for German TV */

/* NOTE:you can run only ONE teletext REXX script or
        the TELETEXT/2 application at the same time */

call RxFuncAdd 'rtvLoadFuncs', 'TVREXX', 'rtvLoadFuncs'
call rtvLoadFuncs

arg filename

channel=34
page=441
subpage=0
slot=3

handle = rtvOpen();
IF handle = "0"
 then DO
    say "Error: driver or moviecard not installed"
    EXIT
END

/* set the channel on German tvchannel ZDF */
rc = rtvSetChannel(handle, channel);

ret = rtvGetCachedPage(page,subpage,30);

/* convert the page to ASCII */
ret=rtvVTTexttoASCII(ret, 1,0);

/* get the information out of the page: the information */
/* starts at line 4 and a line contains 40 characters */
offset=4*40
lauf=0

DO UNTIL lauf >= 18
   aktie=substr(ret,offset+2 ,19);
   position= POS('.',aktie)
   IF position <> 0
   then DO
      aktie=DELSTR(aktie,position,LENGTH(aktie)-position+1)
   END


   aktuel=substr(ret,offset+22 ,8);
   aktuel=SPACE(aktuel)
   vortag=substr(ret,offset+33 ,8);
   vortag=SPACE(vortag)

   offset=offset+40
   lauf=lauf+1
   r=LINEOUT(filename, aktie);
   s=LINEOUT(filename, aktuel);
   t=LINEOUT(filename, vortag);
END
closeline = LINEOUT (filename)
closeret = rtvClose(handle);

EXIT


