/**********************************************************************
 *
 * TVKit/2 installation program.
 *
 * Version 1.0
 *
 * Copyright (C) 1996 by Kirchhoff & Grill Software GmbH
 * All Rights Reserved.
 *
 **********************************************************************/


"@ECHO OFF"

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

call SysCls


say ""
say "Have you installed Warp TV and MPEG CSD before installing TVKit/2 ?"
say "Teletext/2 uses the channelsettings of Warp TV and can't run without"
say "these settings."
say "Do you want to continue? (Y/N)"
Pull question 

if question='N' then do
      EXIT
   end

say ""
say ""


prjtxt = 'TV Kit/2'
prjname = 'tvkit2'

env = 'OS2ENVIRONMENT'
mmbase = value('MMBASE',,env)
mmbase = STRIP(mmbase)
mmbase = STRIP(mmbase,'T',';')

if mmbase = "" then
  do
    say""
    say "Cannot determine path of MMOS/2! Teletext-DLL's are installed"
    say "in the local directory: "destinationPath"."
  end


destinationPath = SysSearchPath('.','.')

if destinationPath = "" then
  do
    say ""
    say "Cannot determine current directory!"
  end
else
  do
    say "Installing "prjtxt" in "destinationPath"."
    rc = SysFileTree( destinationPath, "dirs", "D")
    if (dirs.0 = 0) then
      do
        rc = SysMkDir(destinationpath)
        if (rc \= 0) then
          do
            say "Couldn't create directory "destinationPath"!"
          exit
        end
      end

  /* create a new folder */
  call SysCreateObject "WPFolder", prjtxt, "<WP_DESKTOP>", ,
     "OBJECTID=<HWB_"prjname"FOLDER>;ICONFILE="destinationPath"\ttfold.ico", "fail"

  /* create the program objects */
  rc =SysCreateObject("WPProgram", "Teletext/2", "<HWB_"prjname"FOLDER>", ,
     "PROGTYPE=PM;EXENAME="destinationPath"\teletext.exe;STARTUPDIR="destinationPath,
     ";ASSOCFILTER=*.ttx;PARAMETERS=%*;OBJECTID=<HWB_"prjname"TT2>", "update")

  rc =SysCreateObject("WPProgram", "Ticker/2", "<HWB_"prjname"FOLDER>", ,
     "PROGTYPE=PM;EXENAME="destinationPath"\ticker.exe;"||,
     "OBJECTID=<HWB_"prjname"TICKER2>", "update")

  /* create the INF objects */
  rc =SysCreateObject("WPProgram", "Ticker/2 REXX Extentions Programmers Reference", "<HWB_"prjname"FOLDER>", ,
     "PROGTYPE=PM;EXENAME=view.exe;PARAMETERS="destinationPath"\tickerp.inf;"||,
     "OBJECTID=<HWB_"prjname"TPREF>", "update")

  /* create the INF object */
  rc =SysCreateObject("WPProgram", "TVKit/2 REXX Programmers Reference", "<HWB_"prjname"FOLDER>", ,
     "PROGTYPE=PM;EXENAME=view.exe;PARAMETERS="destinationPath"\tvrexx.inf;"||,
     "OBJECTID=<HWB_"prjname"TVREF>", "update")

  /* create Homepage Object */
  rc = SysCreateObject("WebExplorer_Url", "KGS Homepage", "<HWB_"prjname"FOLDER>", 
    "OBJECTID=<HWB_"prjname"HP>;LOCATOR=http://ourworld.compuserve.com/homepages/hmkirchhKGS", U)

  /* create a shadow of the directories */
  call SysCreateObject "WPShadow", "Ticker/2 Scripts", "<HWB_"prjname"FOLDER>", ,
     "OBJECTID=<HWB_"prjname"SCRIPTS>;SHADOWID="destinationPath"\scripts", "update"

  call SysCreateObject "WPShadow", "Samples", "<HWB_"prjname"FOLDER>", ,
     "OBJECTID=<HWB_"prjname"SAMPLES>;SHADOWID="destinationPath"\samples", "update"

  call SysCreateObject "WPShadow", "Teletext Pages", "<HWB_"prjname"FOLDER>", ,
     "OBJECTID=<HWB_"prjname"TTX>;SHADOWID="destinationPath"\ttx", "update"

  /* create the Registration object */
  rc =SysCreateObject("WPProgram", "Ordering", "<HWB_"prjname"FOLDER>", ,
     "PROGTYPE=PM;EXENAME=e.exe;PARAMETERS="destinationPath"\order.txt;"||,
     "OBJECTID=<HWB_"prjname"REG>", "update")

  /* create the Read.me object */
  rc =SysCreateObject("WPProgram", "Read Me", "<HWB_"prjname"FOLDER>", ,
     "PROGTYPE=PM;EXENAME=e.exe;PARAMETERS="destinationPath"\readme.txt;"||,
     "OBJECTID=<HWB_"prjname"RME>", "update")


    if mmbase \= "" then
      do
        tvkitdll = mmbase"\dll\tvkit2"
        rc = SysFileTree(tvkitdll, "dirs", "D")
        if (dirs.0 = 0) then
        do
          md tvkitdll
        end
        /*xcopy *.dll tvkitdll*/
        tvkit2ch = destinationPath"\vidfmm\tvkit2.ch"

        rc = SysFileTree( tvkit2ch, "dirs", "F")
        if (dirs.0 \= 0) then
        do
           del tvkit2ch
        end

 
        ret = LINEOUT(tvkit2ch, 'merge "LIBPATH"=22');
        ret = LINEOUT(tvkit2ch);

        rc = SysFileTree( destinationPath"\vidfmm\vidfmm.sys", "dirs", "F")
        if (dirs.0 \= 0) then
        do
          olddir = directory("vidfmm")
          minstall.exe
          call directory("..")
        end
      end


        
end

exit
