#define INCL_DOS
#define INCL_WIN
#include <os2.h>
#include <string.h>
#include "filedlg.h"

typedef struct {
   BYTE   res1[12];
   USHORT time;
   USHORT date;
   ULONG  size;
   ULONG  alloc;
   ULONG  attr;
   BYTE   res2;
   CHAR   name[13];
   BYTE   res3[5];
   } FINDBUF;


#ifdef __cplusplus
   extern "C" {
#endif
/* My file open entry point prototype.                                       */
MRESULT EXPENTRY OpenDlgProc   (HWND, USHORT, MPARAM, MPARAM) ;
#ifdef __cplusplus
   }
#endif


/* Define the file extensions to look for.                                   */
#define NUM_EXTENSIONS 1
CHAR apzExt[NUM_EXTENSIONS][7] = { { '*', '.', 'm', 'o', 'v', 0 } };


/* Global variable declarations.                                             */
#define MAXFILENAMES 128
char aFilename[MAXFILENAMES][32];
LONG ulNumberOfEntries;
LONG TheMatchedName= 0L;



/* MatchFilenameToBuffer()                                                   */
/*                                                                           */
/*    Finds the filename the user choose and puts it in the                  */
/*    first entry filename position.                                         */
/*    Returns:                                                               */
/*       0: Successful match                                                 */
/*       1: Failure to match.                                                */
/*                                                                           */

long MatchFilenameToBuffer ( CHAR *Buffer )
   {
   long lIndex=0;

   while ( lIndex < ulNumberOfEntries ) {
      if ( ! strcmp ( aFilename[lIndex], Buffer ) ) {
         TheMatchedName = lIndex;
         return ( 0 );
         }
      lIndex ++;
      }
   return ( 1 );
   }




long SelectDisk ( HWND hwnd, ULONG Disk )
   {
   ULONG ulDriveNum, ulDrives;

   /* Keep a copy of the old drive in case the new one is no good.           */
   DosQCurDisk ( &ulDriveNum, &ulDrives );

   /* Try selecting the drive, return any error.                             */
   if ( DosSelectDisk ( Disk ) ) {
      WinMessageBox ( HWND_DESKTOP, hwnd,
         (PSZ) "Selected drive is not valid.",
         (PSZ) "Error:",0,MB_OK );
      return ( 1 );
      }
   else
      return ( 0 );
   }





void FillPath ( HWND hwnd )
   {
   char achPath[256];
   unsigned long ulDriveNum, ulDrives;

   /* Grab a copy of the current disk drive and add a colon and backslash.   */
   DosQCurDisk ( &ulDriveNum, &ulDrives );
   achPath[0]= (CHAR)ulDriveNum + '@';
   achPath[1]= ':';
   achPath[2]= '\\';

   /* Move the rest of the path in.                                          */
   ulDrives= 253;
   DosQueryCurrentDir ( ulDriveNum, (PSZ) (achPath+3), &ulDrives );

   /* Set the text in the box.                                               */
   WinSetWindowText ( WinWindowFromID ( hwnd, IDD_PATHNAME ), (PSZ) achPath );
   }




void FillFileListBox (HWND hwnd)
   {
   HDIR    hDir;
   ULONG   ulSearchCount;
   ULONG   ulExt;
   FINDBUF findbuf;
   USHORT  usError;

   /* Clear out the SMV file counter.                                        */
   ulNumberOfEntries = 0;

   /* Disable updates to the list box and clear it out.                      */
   WinEnableWindowUpdate ( WinWindowFromID ( hwnd, IDD_FILELIST ), FALSE );
   WinSendDlgItemMsg ( hwnd, IDD_FILELIST, LM_DELETEALL, NULL, NULL );

   /* Run through the supported extensions, adding them to the list.         */
   for ( ulExt=0; ulExt<NUM_EXTENSIONS; ulExt++ ) {

      /* Add all of the files of this extension to the list.                 */
      ulSearchCount = 1;
      hDir = HDIR_SYSTEM;
      usError = DosFindFirst ( (PSZ)apzExt[ulExt], &hDir, 0x0007,
                     &findbuf, sizeof findbuf, &ulSearchCount, 1L );
      while ( !usError && ulNumberOfEntries < MAXFILENAMES ) {
         strcpy ( aFilename[ulNumberOfEntries], findbuf.name );
         WinSendDlgItemMsg ( hwnd, IDD_FILELIST, LM_INSERTITEM,
                             MPFROM2SHORT ( LIT_SORTASCENDING, 0 ),
                             MPFROMP ( findbuf.name ) ) ;
         ulNumberOfEntries++;
         usError = DosFindNext( hDir, &findbuf, sizeof findbuf, &ulSearchCount );
         }
      }

   /* Reenable updates to the list box.                                      */
   WinShowWindow ( WinWindowFromID ( hwnd, IDD_FILELIST ), TRUE );
   }




void FillDirListBox (HWND hwnd)
   {
   HDIR    hDir = HDIR_SYSTEM;
   ULONG   ulSearchCount = 1;
   FINDBUF findbuf;
   USHORT  usError;

   /* Disable window updating and delete all entries from directory list.    */
   WinEnableWindowUpdate ( WinWindowFromID ( hwnd, IDD_DIRLIST ), FALSE );
   WinSendDlgItemMsg ( hwnd, IDD_DIRLIST, LM_DELETEALL, NULL, NULL );

   /* Look for any subdirectories to add to the box.                         */
   usError = DosFindFirst ( (PSZ) "*.*", &hDir, 0x0017, &findbuf,
                         sizeof ( FINDBUF ), &ulSearchCount, 1L);
   while ( !usError ) {
      if ( findbuf.attr & 0x0010 ) {
         if ( findbuf.name[0]=='.' && findbuf.name[1]=='.' && findbuf.name[2]=='\0' ) {
            WinSendDlgItemMsg ( hwnd, IDD_DIRLIST, LM_INSERTITEM,
                                MPFROM2SHORT ( 0, 0 ),
                                MPFROMP ( ".." ) ) ;
            WinSendDlgItemMsg ( hwnd, IDD_DIRLIST, LM_INSERTITEM,
                                MPFROM2SHORT ( 1, 0 ),
                                MPFROMP ( "\\" ) ) ;
            }
         else if ( findbuf.name[0]!='.' )
            WinSendDlgItemMsg ( hwnd, IDD_DIRLIST, LM_INSERTITEM,
                                MPFROM2SHORT ( LIT_SORTASCENDING, 0 ),
                                MPFROMP ( findbuf.name ) );
         }
      usError = DosFindNext ( hDir, &findbuf, sizeof findbuf, &ulSearchCount );
      }

   /* Enable window updating to directory list.                              */
   WinShowWindow ( WinWindowFromID ( hwnd, IDD_DIRLIST ), TRUE );
   }





void FillDriveListBox (HWND hwnd)
   {
   static CHAR szDrive[3]= "A:";
   USHORT usDrive;
   ULONG  ulDriveNum, ulDriveMap;

   /* Disable window updating and delete all entries from drive list.        */
   WinEnableWindowUpdate ( WinWindowFromID ( hwnd, IDD_DRIVELIST ), FALSE );
   WinSendDlgItemMsg ( hwnd, IDD_DRIVELIST, LM_DELETEALL, NULL, NULL );

   /* Add all of the valid drives to the list box.                           */
   DosQCurDisk ( &ulDriveNum, &ulDriveMap );
   for ( usDrive = 0; usDrive < 26; usDrive++ )
      if ( ( ulDriveMap & 1L << usDrive ) ) {
         szDrive [0] = (CHAR) ( usDrive + 'A' );
         WinSendDlgItemMsg ( hwnd, IDD_DRIVELIST, LM_INSERTITEM,
                             MPFROM2SHORT ( LIT_END, 0 ),
                             MPFROMP ( szDrive ) );
         }

   /* Enable window updating of drive list.                                  */
   WinShowWindow ( WinWindowFromID ( hwnd, IDD_DRIVELIST ), TRUE );
   }




MRESULT EXPENTRY OpenDlgProc ( HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2 )
   {
   static CHAR szBuffer [256];
   static BOOL fDirSelect;
   static BOOL fDriveSelect;

   switch (msg) {

      case WM_BUTTON1DOWN:
         if ( fDirSelect ) {
            WinSendDlgItemMsg ( hwnd, IDD_DIRLIST, LM_QUERYITEMTEXT,
                     MPFROM2SHORT ( WinSendDlgItemMsg ( hwnd,
                     IDD_DIRLIST, LM_QUERYSELECTION, 0L, 0L ), 13 ),
                     MPFROMP ( (PSZ)szBuffer) );
            DosSetCurrentDir ( (PSZ)szBuffer );
            FillFileListBox ( hwnd );
            FillDirListBox ( hwnd );
            FillPath ( hwnd );
            return ( 0 );
            }
         else if ( fDriveSelect ) {
            WinSendDlgItemMsg ( hwnd, IDD_DRIVELIST, LM_QUERYITEMTEXT,
                  MPFROM2SHORT ( WinSendDlgItemMsg (hwnd,
                  IDD_DRIVELIST, LM_QUERYSELECTION, 0L, 0L), 3),
                  MPFROMP ( (PSZ)szBuffer) );
            SelectDisk ( hwnd, (ULONG) ( szBuffer[0] - '@' ) );
            FillFileListBox ( hwnd );
            FillDirListBox ( hwnd );
            FillPath ( hwnd );
            return ( 0 );
            }
         return ( 0 );

      case WM_INITDLG:
         fDirSelect = FALSE;
         fDriveSelect = FALSE;
         FillDriveListBox ( hwnd );
         FillFileListBox ( hwnd );
         FillDirListBox ( hwnd );
         FillPath ( hwnd );
         return ( 0 );

      case WM_CONTROL:
         switch ( SHORT1FROMMP ( mp1 ) ) {
            case IDD_DIRLIST:
               if ( ( SHORT2FROMMP ( mp1 ) == LN_SELECT ) )
                  fDirSelect = TRUE;
               else if ( ( SHORT2FROMMP ( mp1 ) == LN_KILLFOCUS ) )
                  fDirSelect = FALSE;
               else if ( SHORT2FROMMP ( mp1 ) == LN_ENTER ) {
                  WinSendDlgItemMsg ( hwnd, IDD_DIRLIST, LM_QUERYITEMTEXT,
                         MPFROM2SHORT ( WinSendDlgItemMsg ( hwnd,
                         IDD_DIRLIST, LM_QUERYSELECTION, 0L, 0L ), 13 ),
                         MPFROMP ( (PSZ)szBuffer ) );
                  DosSetCurrentDir ( (PSZ)szBuffer );
                  FillFileListBox ( hwnd );
                  FillDirListBox ( hwnd );
                  FillPath ( hwnd );
                  fDirSelect = FALSE;
                  return ( 0 );
                  }
               break;

            case IDD_DRIVELIST:
               if ( ( SHORT2FROMMP ( mp1 ) == LN_SELECT ) )
                  fDriveSelect = TRUE;
               else if ( ( SHORT2FROMMP ( mp1 ) == LN_KILLFOCUS ) )
                  fDriveSelect = FALSE;
               else if ( SHORT2FROMMP ( mp1 ) == LN_ENTER ) {
                  WinSendDlgItemMsg ( hwnd, IDD_DRIVELIST, LM_QUERYITEMTEXT,
                         MPFROM2SHORT ( WinSendDlgItemMsg ( hwnd,
                         IDD_DRIVELIST, LM_QUERYSELECTION, 0L, 0L ), 3 ),
                         MPFROMP ( (PSZ)szBuffer) );
                  SelectDisk ( hwnd, (ULONG) ( szBuffer[0] - '@' ) );
                  FillFileListBox ( hwnd );
                  FillDirListBox ( hwnd );
                  FillPath ( hwnd );
                  fDriveSelect = FALSE;
                  return ( 0 );
                  }
               break;

            case IDD_FILELIST:
               if ( SHORT2FROMMP ( mp1 ) == LN_ENTER ) {
                  WinSendDlgItemMsg ( hwnd, IDD_FILELIST, LM_QUERYITEMTEXT,
                           MPFROM2SHORT ( WinSendDlgItemMsg ( hwnd,
                           IDD_FILELIST, LM_QUERYSELECTION, 0L, 0L ), 255 ),
                           MPFROMP ( (PSZ) szBuffer ) );
                  MatchFilenameToBuffer ( (char *) szBuffer );
                  WinDismissDlg ( hwnd, TRUE );
                  return ( 0 );
                  }
               break;
            }
         break;

      case WM_COMMAND: {
         switch ( SHORT1FROMMP ( mp1 ) )
            {
            case IDD_OPENBUTTON:
                 WinSendDlgItemMsg ( hwnd, IDD_FILELIST, LM_QUERYITEMTEXT,
                          MPFROM2SHORT ( WinSendDlgItemMsg ( hwnd,
                          IDD_FILELIST, LM_QUERYSELECTION, 0L, 0L ), 255 ),
                          MPFROMP ( (PSZ)szBuffer ) );
                 if ( !MatchFilenameToBuffer ( (char *)szBuffer ) ) {
                    WinDismissDlg ( hwnd, TRUE );
                    return 0;
                    }
                 else {
                    WinAlarm ( HWND_DESKTOP, WA_ERROR );
                    return 0;
                    }

            case IDD_CANCELBUTTON:
               aFilename[0][0] = 0;
               WinDismissDlg ( hwnd, FALSE );
               return ( 0 );
            }
         break;
         }
      }
   return WinDefDlgProc (hwnd, msg, mp1, mp2) ;
   }




long OpenFileDlg ( HWND hwnd, char *pchOut )
   {
   ULONG ulOrigDrive, ulDriveNum, ulDrives;
   CHAR  szOrigDir[256];
   INT rc;

   /* Keep a copy of the original drive and directory so we can              */
   /* set them back on the way out.                                          */
   DosQCurDisk ( &ulOrigDrive, &ulDrives );
   szOrigDir[0] = '\\';
   ulDrives = 255;
   DosQueryCurrentDir ( ulOrigDrive, (PSZ)szOrigDir+1, &ulDrives );

   /* Open the dialog box.                                                   */
rc =   WinDlgBox ( HWND_DESKTOP, hwnd, (PFNWP) OpenDlgProc, (HMODULE) NULL, IDD_OPEN, NULL );

   /* Check if a file was selected.                                          */
   if ( aFilename [ TheMatchedName ][ 0 ] ) {

      /* Grab a copy of the current disk drive and add a colon and backslash.*/
      DosQCurDisk ( &ulDriveNum, &ulDrives );
      pchOut[0]= (CHAR)ulDriveNum + '@';
      pchOut[1]= ':';
      pchOut[2]= '\\';

      /* Move the rest of the path in.                                       */
      ulDrives = 253;
      DosQueryCurrentDir ( ulDriveNum, (PSZ) (pchOut+3), &ulDrives );

      /* /Only concatenate if a path was added */
      if (pchOut[3])
        strcat ( pchOut, "\\" );

      /* Finally concatenate the filename.                                   */
      strcat ( pchOut, aFilename [ TheMatchedName ] );
      }

   TheMatchedName= 0L;

   /* Return the disk and directory back to the original selection.          */
   DosSelectDisk ( ulOrigDrive );
   DosSetCurrentDir ( (PSZ)szOrigDir );

   /* Return if the selection happened or not.                               */
   return ( (long)*pchOut );
   }



MRESULT EXPENTRY AboutDlgProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
   {
   switch ( msg ) {
      case WM_COMMAND:
         switch ( SHORT1FROMMP ( mp1 ) ) {
            case DID_OK:
            case DID_CANCEL:
               WinDismissDlg ( hwnd, TRUE );
               return ( 0 );
            }
         break;
      }
   return ( WinDefDlgProc ( hwnd, msg, mp1, mp2 ) );
   }




void AboutDlg ( HWND hwnd )
   {
   WinDlgBox ( HWND_DESKTOP, hwnd, (PFNWP) AboutDlgProc,
               (HMODULE) NULL, IDD_ABOUT, NULL );
   }
