#include "../w95k.h"


int w95kStartup(void)
{ int a;

  if(ProfileOpen()!=0)
    { WinPerror("Can't initialize", "Can't open profile");
      return(-1);
    }

  if(ModifierInit()!=0)
    { WinPerror("Can't initialize", "Can't initialize modifiers");
      ProfileClose();
      return(-1);
    }
    
  if(PluginInit()!=0)
    { WinPerror("Can't initialize", "Can't initialize plugins");
      ModifierFree();
      ProfileClose();
      return(-1);
    }

  if(EventInit()!=0)
    { WinPerror("Can't initialize", "Can't initialize events");
      PluginFree();
      ModifierFree();
      ProfileClose();
      return(-1);
    }

  if(HookSet()!=0)
    { WinPerror("Can't initialize", "Can't register hook");
      PluginFree();
      ModifierFree();
      ProfileClose();
      return(-1);
    }
    
  ProfileQueryParams();  
  WinCheckMenuItem(hwndMenu, MENU_PRESS, mainParams.onKeyPress);
  WinCheckMenuItem(hwndMenu, MENU_HIDE, mainParams.Hide);
  if(w95kHide(mainParams.Hide)!=0)
    { WinPerror("Can't initialize", "Can't set application visibility");
      PluginFree();
      ModifierFree();
      ProfileClose();
      return(-1);
    }

  ProfileClose();
  
  WinSetWindowPos(hwndMain, HWND_TOP, mainParams.x, mainParams.y, mainParams.cx, mainParams.cy, SWP_SIZE|SWP_MOVE|SWP_ZORDER|SWP_ACTIVATE);
  if(mainParams.isMinimized)
    { WinSetWindowPos(hwndMain, HWND_BOTTOM, 0, 0, 0, 0, SWP_MINIMIZE|SWP_SHOW|SWP_ZORDER);
    }
   else
    { WinSetWindowPos(hwndMain, HWND_TOP, mainParams.x, mainParams.y, mainParams.cx, mainParams.cy, SWP_SIZE|SWP_MOVE|SWP_ZORDER|SWP_ACTIVATE|SWP_SHOW);
    }

  return(0);
}

int w95kShutdown(void)
{ if(ProfileOpen()==0)
    { ProfileSaveParams();
      ProfileClose();
    }

  HookRemove();

  ModifierFree();
  PluginFree();
  EventFree();
  
  return(0);
}


