#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ndfs.h>

int main( int argc, char *argv[] )
{
 
    int rc = 0;
    printf( "NetDrive Unmount Utility\n" );
    if ( argc != 3 )
    {
        printf( "ndunmount mountpoint index\n" );
        printf( "    where "
                "    index is the index of resource to be unmounted (0 for all resources)\n" );
        rc = -1;
    }
    else
    {
        char *mountpoint = argv[1];
        int index = atoi(argv[2]);
        rc = NdUnmount( mountpoint, index );
        if (rc != 0)
        {
            printf("Unmount failed: return code = %ld.\n", rc);
        }
        else
        {
            printf("Unmount successful.\n");
        }
    }
    return rc;
}
