#include <stdio.h>
#include <string.h>
#include <ndfs.h>

int main( int argc, char *argv[] )
{
    int rc = 0;
    char data[4096];
    ULONG ulDataLen;
    
    printf( "NetDrive Refresh Directory Utility\n" );
    if ( argc != 2 )
    {
        printf( "ndrefresh path\n" );
        printf( "    where path is the directory to be refreshed\n" );
        rc = -1;
    }
    else
    {
        char fullpath[512];
        char *path = argv[1];
        rc = DosQueryPathInfo( path, 
                               FIL_QUERYFULLNAME, 
                               fullpath, sizeof( fullpath ) );
        if ( rc == NO_ERROR )
        {
            rc = NdIoctl( DO_IOCTL_REFRESH,
                          fullpath, 
                          data, 
                          sizeof(data),
                          &ulDataLen );
        }
        if (rc != 0)
        {
            printf("Refresh failed: return code = %ld\n", rc);
        }
        else
        {
            printf("Refresh successful.\n");
        }
    }
    return rc;
}
