#include <stdio.h>
#include <string.h>
#include <ndfs.h>

int main( int argc, char *argv[] )
{
    int rc = 0;
    printf( "NetDrive Create Mount Point Utility\n" );
    if ( argc != 2 )
    {
        printf( "ndcreatemp path\n" );
        printf( "   where path is the mount point to be created\n" );
        rc = -1;
    }
    else
    {
        char *mountpoint = argv[1];
        
        rc = NdCreateMountPoint( mountpoint, MP_FLAG_NORMAL );
        
        if (rc != 0)
        {
            printf("Create failed: return code = %ld\n", rc);
        }
        else
        {
            printf("Mount point created.\n");
        }
    }
    return rc;
}
