#include <stdio.h>
#include <string.h>
#include <ndfs.h>

static int createMountPoint( char *mpoint )
{
    int rc;
    
    rc = NdCreateMountPoint( mpoint, MP_FLAG_NORMAL );
    if ( rc == ERROR_ACCESS_DENIED )
    {
        /* mount point exists */
        rc = NO_ERROR;
    }
    
    return rc;
}

static int mountResource( char *mpoint, char *type, char *resource, char *flag )
{
    int rc;
    ULONG ulFlags = 0ul;
       
    if ( stricmp( flag, "ro" ) == 0 ||
         stricmp( flag, "r" ) == 0 )
    {
        ulFlags |= DO_FLAG_WRITEPROTECT;
    }
    
    rc = NdMount( type, ulFlags, mpoint, resource );
    
    return rc;
}

int main( int argc, char *argv[] )
{
 
    int rc = 0;
    printf( "NetDrive Auto Mount Utility\n" );
    if ( argc != 2 )
    {
        printf( "ndautomnt file\n" );
        printf( "  where file is a text file that contains mount information\n" );
        printf( "        in the following format:\n" );
        printf( "        mountpoint type resource flag\n" );
        rc = -1;
    }
    else
    {
        FILE *fp = fopen( argv[1], "r" );
        if ( fp == NULL )
        {
            printf( "Error: cannot open input file\n" );
        }
        else
        {
            static char string[8192];
            static char mpoint[4096];
            static char type[4096];
            static char resource[4096];
            static char flag[4096];
            int linenum = 0;
            while( fgets( string, sizeof( string ), fp ) )
            {
                int fields;
                linenum++;
                fields = sscanf( string, "%s %s %s %s", mpoint, type, resource, flag );
                if ( fields == 4 || fields == 1 )
                {
                    rc = createMountPoint( mpoint );
                    if ( rc != NO_ERROR )
                    {
                        printf( "Error: cannot create mount point [%s] specified on line %d, error code %d\n", mpoint, linenum, rc );
                    }
                    else
                    {
                        if ( fields == 4 )
                        {
                            rc = mountResource( mpoint, type, resource, flag );
                            if ( rc != NO_ERROR )
                            {
                                printf( "Error: cannot mount resource specified on line %d, error code %d\n", linenum, rc );
                            }
                            else
                            {
                                printf( "%s resource mounted: %s <- %s\n", type, mpoint, resource );
                            }
                        }
                    }
                }
                else
                {
                    printf( "Error: cannot parse line %d of input file\n", linenum );
                }
            }
            fclose( fp );
        }
    }
    return rc;
}
