/* NetDrive's REXX sample */

/* Load the NetDrive REXX interface. */
call RxFuncAdd 'NdRxLoadFuncs', 'NDCALLS', 'NdRxLoadFuncs'
call NdRxLoadFuncs

/* Attach the virtual drive. */
drive = 'S:'
say NdRxAttach( drive )

units = 4096 /* set size of drive to 4096*512 bytes */
unitsavail = 2 /* set free space to 2*512 bytes */
say NdRxSetDriveInfo( drive, units, unitsavail )

/* Create mount point */
mountPoint = drive'\OS2DIR'
say NdRxCreateMountPoint( mountPoint )

/* Mount the resource in Readonly mode */
src = 'C:\OS2'
say NdRxMount( 'local', mountPoint, src, 'R' )

/* query information on the mount point */
say NdRxGetMount( mountPoint, infostem, mountpointstem, resourcestem )
say infostem.0
say infostem.1
say infostem.2
say mountpointstem.0
do i = 1 to mountpointstem.0
    say mountpointstem.i
end
say resourcestem.0
do i = 1 to resourcestem.0
    say resourcestem.i
end


/* Unmount resource from the virtual drive. */
say NdRxUnmount( mountPoint, 0 )

/* Delete mount point */
say NdRxDeleteMountPoint( mountPoint )

/* Delete the virtual drive. */
call NdRxDetach drive

/* query some information from IFS */
say NdRxQueryIFS()
say NdRxQueryCTL()

/* Unload the NetDrive REXX interface. */
call NdRxDropFuncs
      
exit(0)

