/********************************************************************/
/*                                                                  */
/*  Dieses REXX-Programm installiert die                            */
/*  Deutsche PEERF FAQ                                              */
/*                                                                  */
/********************************************************************/
/*  Copyright by Thomas Baumann                                     */
/*  Version 1.0                                    vom 31.07.1998   */
/*                                                                  */
/*  Fido:       2:2476/30                                           */
/*  Internet:   taumann@w-4.de                                      */
/********************************************************************/
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

'@ECHO OFF'

YES = 1
NO  = 0

INSTDIR.1 = 'BACKOS2'
INSTDIR.2 = 'LNCHPAD'
INSTDIR.3 = 'SETVIO'
INSTDIR.0 = 3

BootLW.1  = 'Bitte geben Sie das Bootlaufwerk von OS/2 an.'
BootLW.0  = 1

InfText.1 = 'Um alle Funktionen der FAQ nutzen zu knnen, muss diese sich in einem'
InfText.2 = 'Verzeichnis befinden, das im BOOKSHELF-Pfad eingetragen ist.'
InfText.3 = 'Bitte geben Sie ein entsprechendes Verzeichnis an.'
InfText.0 = 3


ToNUL     = ' 2>NUL 1>&2'

Call Logo
Call Init
Call InstallFAQ
Call Done

EXIT

Init:
InstallDir = Directory()
PEERFAQ = VALUE('PEERFAQ',,'OS2ENVIRONMENT')
IF PEERFAQ = '' THEN
    DO
      BOOTLAUFWERK = SUBSTR(VALUE('USER_INI',,'OS2ENVIRONMENT'), 1, 2)
    END /* IF */
  ELSE
    DO
      BOOTLAUFWERK     = SysIni(PEERFAQ || '\PEERFAQ.INI', 'PEERFAQ', 'Bootlaufwerk')
      InfDir           = SysIni(PEERFAQ || '\PEERFAQ.INI', 'PEERFAQ', 'INF-Verzeichnis')
      FaqDir           = PEERFAQ
      AlreadyInstalled = YES
    END /* ELSE */
If BootLaufwerk == 'ERROR:' THEN BOOTLAUFWERK = SUBSTR(VALUE('RUNWORKPLACE',,'OS2ENVIRONMENT'), 1, 2)
CALL ASKBootLW
If InfDir == 'ERROR:' THEN InfDir = Bootlaufwerk || '\OS2\BOOK'
If InfDir == 'INFDIR' THEN InfDir = Bootlaufwerk || '\OS2\BOOK'
CALL ASKInf


Call Logo
Say 'Bootlaufwerk von OS/2      => ' || Bootlaufwerk
Say 'Kopiere PEER-FAQ INF Daten => ' || InfDir
Call AskOK
RETURN /* Init */


AskOK:
Say
Call CharOut 'STDOUT:','Sind diese Angaben korrekt? [Ja/Nein] '
Pull Eingabe
Eingabe = Translate( EINGABE )
IF Abbrev( 'NEIN', EINGABE, 1)
  THEN
    CALL INIT
  ELSE DO
    IF Abbrev( 'JA', EINGABE, 1)
      THEN
        NOP
      ELSE DO
        SAY 'Ungltige Eingabe!'
        CALL AskOK
      END /* ELSE */
  END /* ELSE */
RETURN /* AskOK */


ASKInf:
Do i = 1 to InfText.0
  SAY InfText.i
END /* DO */
SAY 'Vorgabe: ' || InfDir
PULL Eingabe
IF Eingabe <> '' THEN InfDir = Eingabe
Say
RETURN Eingabe /* ASK */



ASKBootLW:
Do i = 1 to BootLW.0
  SAY BootLW.i
END /* DO */
SAY 'Vorgabe: ' || Bootlaufwerk
PULL Eingabe
IF Eingabe <> '' THEN Bootlaufwerk = Eingabe
Say
RETURN /* ASK */


Done:
Call Logo
Say
Say 'Installation erfolgreich!'
Say
/* Say 'Das Programmobjekt wurde im Ordner Information erstellt.'*/
Say
Say 'Installationsprogramm beenden mit [RET]'
Say
Pull Nothing
RETURN /* Done */


InstallFAQ:
rc = SysFileTree( 'PEERFAQ', Files, 'FO' )
If Files.0 = 1 Then
    DO
      CALL UnpackFAQ
    END /* IF */
  ELSE
    DO
      Say 'Fehler bei der Installation!'
      Say 'PEERFAQ-Archiv nicht gefunden.'
      EXIT
    END /* ELSE */
Call MakeIcon





UnpackFAQ:
'UNPACK' files.1 '>>' || 'INSTALL.LOG' || ToNul
'COPY ' || 'PEERFAQ.ICO '  || InfDir || ToNul
'COPY ' || 'PEERFAQ0.INF ' || InfDir || ToNul
'COPY ' || 'PEERFAQ1.INF ' || InfDir || ToNul
'COPY ' || 'PEERFAQ2.INF ' || InfDir || ToNul
'COPY ' || 'PEERFAQ3.INF ' || InfDir || ToNul
'COPY ' || 'PEERFAQ4.INF ' || InfDir || ToNul
'DEL ' ||  'peerfaq?.INF' || ToNul
RETURN /* UnpackFAQ */


MakeIcon:
classname='WPFolder'
title='Tom`s PEER FAQ v1.1'
/* location='<WP_INFO>'*/
location='<WP_DESKTOP>'
setup='OBJECTID=<PEERFAQ_FOLDER>;ICONFILE='infDir'\peerfaq.ICO;update\'
Call BldObj

classname = 'WPProgram'
title     = 'Buch 0' || d2c('13') || ' Kabel & Stecker'
location  = '<PEERFAQ_FOLDER>'
INFNAME   = InfDir || '\PEERFAQ0.INF' || ' Peer FAQ Buch 0'
WorkDir   = INFDir
setup     = 'OBJECTID=<PEERFAQ0>;EXENAME=VIEW.EXE;PARAMETERS='INFNAME';STARTUPDIR='Workdir
rc=SysCreateObject(classname, title, location ,setup,'U')

classname = 'WPProgram'
title     = 'Buch 1 ' || d2c('13') || ' Netzwerkkarten,Win95-Peer,TCP/IP(1)'
location  = '<PEERFAQ_FOLDER>'
INFNAME   = InfDir || '\PEERFAQ1.INF' || ' Peer FAQ Buch 1'
WorkDir   = INFDir
setup     = 'OBJECTID=<peerfaq1>;EXENAME=VIEW.EXE;PARAMETERS='INFNAME';STARTUPDIR='Workdir
rc=SysCreateObject(classname, title, location ,setup,'U')

classname = 'WPProgram'
title     = ' Buch 2 ' || d2c('13') || ' TCP/IP(2) + Netmask '
location  = '<PEERFAQ_FOLDER>'
INFNAME   = InfDir || '\PEERFAQ2.INF' || ' Peer FAQ Buch 2'
WorkDir   = INFDir
setup     = 'OBJECTID=<peerfaq2>;EXENAME=VIEW.EXE;PARAMETERS='INFNAME';STARTUPDIR='Workdir
rc=SysCreateObject(classname, title, location ,setup,'U')

classname = 'WPProgram'
title     = 'Buch 3 '  || d2c('13') || ' OS/2-Peer-FAQ'
location  = '<PEERFAQ_FOLDER>'
INFNAME   = InfDir || '\PEERFAQ3.INF' || ' Peer FAQ Buch 3'
WorkDir   = INFDir
setup     = 'OBJECTID=<peerfaq3>;EXENAME=VIEW.EXE;PARAMETERS='INFNAME';STARTUPDIR='Workdir
rc=SysCreateObject(classname, title, location ,setup,'U')

classname = 'WPProgram'
title     = 'Buch 4' || d2c('13') || ' WarpServer FAQ'
location  = '<PEERFAQ_FOLDER>'
INFNAME   = InfDir || '\PEERFAQ4.INF' || ' Peer FAQ Buch 4'
WorkDir   = INFDir
setup     = 'OBJECTID=<peerfaq4>;EXENAME=VIEW.EXE;PARAMETERS='INFNAME';STARTUPDIR='Workdir
rc=SysCreateObject(classname, title, location ,setup,'U')




RETURN /* MakeIcon */




/* Objekt anlegen */
BldObj:
call charout ,'Erstellen: 'title

result = SysCreateObject(classname, title, location, setup, 'R')

If result=1 Then call charout ,'...   Objekt angelegt!'
Else             call charout ,'...   Fehler! Return code='result

Say '';
Return






Logo:
Call SysCls
Say
Say '          Deutsche PEER - FAQ v1.1  OS/2 Installationsprogramm.'
Say
RETURN /* LOGO */


