/* Simple test program:   bubble sort of a fixed table. 	*/
/* This demonstrates some of the compiler's common-subexpression*/
/* elimination capabilities.  For example, inspect the code	*/
/* generated for procedure Sort_array.	See the Programmer's    */
/* Guide for how to request an assembly listing on your host.	*/

/*
 * sort.c -- For benchmarking, define -DBENCHMARK -DITERATIONS=x,
 *   where x is the number of iterations desired.
 */


#include <time.h>

double second() {
   return (double)(((double)(clock()))/((double)(CLOCKS_PER_SEC)));
   }


/* set the # of iterations as desired */
#ifndef ITERATIONS
#  define ITERATIONS 1
#endif
typedef unsigned char boolean;


extern int printf(), puts();

void Sort_array(int Tab[],int Last) {
   boolean Swap;
   int Temp,I;
   do {
      Swap = 0;
      for (I = 0; I<Last; I++)
	 if (Tab[I] > Tab[I+1]) {
	    Temp = Tab[I];
	    Tab[I] = Tab[I+1];
	    Tab[I+1] = Temp;
	    Swap = 1;
	    }
      }
   while (Swap);
   }

int Tab[100];

void Print_array() {
   int I,J;
   puts("\nArray Contents:");
   for (I=0; I<=9; I++) {
      printf("%5d:",10*I);
      for (J=0; J<=9; J++) printf("%5d",Tab[10*I+J]);
      puts("\n");
      }
   }


Init_array() {
   int I,J,K;

   /* Initialize the table that will be sorted. 	    */
   K = 0;
   for (I = 9; I >= 0; I--)
      for (J = I*10; J < (I+1)*10; J++)
	 Tab[K++] = J&1 ? J+1 : J-1;
   }


void main() {
   double t1, t2, t;
   int i;
   t = 0;
#ifndef BENCHMARK
   Init_array();
   Print_array();
#endif
   for (i = 0; i < ITERATIONS; i++) {
     Init_array();
     t1 = second(); 
     Sort_array(Tab,99);
     t2 = second();
     t += t2 - t1;
     }
#ifdef BENCHMARK
   printf("Run through bubble sort of 100 integers, # iterations: %d\n",
          ITERATIONS);
   printf("Time taken: %lf seconds\n", t);
#else
   Print_array();
#endif
   }


