BOOL setCascadeDefault(HWND hwndMenu,USHORT usSubmenu,USHORT usDefault)
//-------------------------------------------------------------------------
// This function sets the default menuitem for the specified cascade menu.
//
// Input:  hwndMenu - specifies the menu window handle.
//         usSubmenu - specifies the id of the cascade menu.
//         usDefault - specifies the id of the default menuitem.
// Returns:  TRUE if successful, FALSE otherwise.
//-------------------------------------------------------------------------
{
   MENUITEM miItem;
   ULONG ulStyle;

   WinSendMsg(hwndMenu,
              MM_QUERYITEM,
              MPFROM2SHORT(usSubmenu,TRUE),
              MPFROMP(&miItem));
   ulStyle=WinQueryWindowULong(miItem.hwndSubMenu,QWL_STYLE);
   ulStyle|=MS_CONDITIONALCASCADE;
   WinSetWindowULong(miItem.hwndSubMenu,QWL_STYLE,ulStyle);

   WinSendMsg(miItem.hwndSubMenu,
              MM_SETDEFAULTITEMID,
              MPFROM2SHORT(usDefault,FALSE),
              0L);
   WinSendMsg(miItem.hwndSubMenu,
              MM_SETITEMATTR,
              MPFROM2SHORT(usDefault,TRUE),
              MPFROM2SHORT(MIA_CHECKED,MIA_CHECKED));

   return TRUE;
}
