/* --------------------------------------------------------------------
      This is the main OS/2 shell from which the game will be hung.
   Almost all other modules should be OS inspecific, with the exception
   of the input modules.

     Sample code for the article "Gearing Up For Games" in EDM/2.

                 Article and code by Michael T. Duffy

-------------------------------------------------------------------- */

// ***********************************************************************
//  Header Files
// ***********************************************************************

#define __IBMC__
#define INCL_WIN
#define INCL_GPI
#define INCL_DOS
#define INCL_ERRORS

// OS/2 API functions
#include <os2.h>

// DIVE required header files
#define  _MEERROR_H_
#include <mmioos2.h>
#include <dive.h>
#include <fourcc.h>

// ANSI C functions
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "newtypes.hpp"
#include "canvas.hpp"
#include "game3.hpp"
#include "errdisp.hpp"


#include "os2pal.hpp"
#include "bitmap.hpp"
#include "pcx.hpp"
#include "sprite.hpp"

// Note: You can see what happens when the palette is not suspended or
//       restored upon the WM_ACTIVATE message by commenting out the
//       following #define
#define ADJUST_PALETTE_ON_FOCUS


// ***********************************************************************
//  Variables
// ***********************************************************************

// OS/2 environment variables.
HAB                hab;
HWND               hwndFrame,
                   hwndClient;
CHAR               szTitle [64];
BOOL               bAppIsActive = FALSE;
HDC                hdcClientHDC = NULLHANDLE;
HPS                hpsMainHPS   = NULLHANDLE;

const CHAR         szClientClass []  = "CLIENT";

SHORT              sBorderHeight;
SHORT              sBorderWidth;

LONG               lTotalWidth   = 320;
LONG               lTotalHeight  = 200;

// Dive variables
DIVE_CAPS          DiveCaps           = {0};
FOURCC             fccFormats[100]    = {0};
HDIVE              hDive              = NULLHANDLE;
BOOL               bDiveHaveBuffer    = FALSE;
ULONG              ulDiveBufferNumber = 0;


/******** New Code Start ********/

// thread variables
BOOL               bEndGameThread  = FALSE;
HEV                hevTimerSem;
HMTX               hmtxModeChange;
HMTX               hmtxAccess;
HMTX               hmtxPause;
HTIMER             htimer;
LONG               lAvailableTimers;

const SHORT        sBGCANVAS_WIDTH   = 320;
const SHORT        sBGCANVAS_HEIGHT  = 400;

BOOL               bScrolling = TRUE;
BOOL               bPaused    = FALSE;

// Game variables

SpriteManager      smSprites;

/******** New Code End ********/


// Canvas variables
PCANVAS            pcnvMainCanvas = NULL;

// Palette objects
OS2Palette         pal2Real;
OS2Palette         pal2Image;

// Constants
const ULONG        ulIMAGE_WIDTH  = 320;
const ULONG        ulIMAGE_HEIGHT = 200;



// ***********************************************************************
//  Code
// ***********************************************************************


//........................................................................
int main()
//........................................................................
  {
  HMQ              hmq;
  QMSG             qmsg;
  ULONG            flFrameFlags;

  TID              tidGameThread;



  hab = WinInitialize (0);
  hmq = WinCreateMsgQueue (hab, 0);

  WinRegisterClass (hab, szClientClass, ClientWndProc, CS_SIZEREDRAW, 0);

  if (InitializeDive () == NO_ERROR)
    {
    // Ready variables for main window creation.
    WinLoadString (hab, 0, ID_APPMAIN, sizeof(szTitle), szTitle);
    flFrameFlags = FCF_TITLEBAR      | FCF_DLGBORDER  |  FCF_MINBUTTON |
                   FCF_SHELLPOSITION | FCF_TASKLIST   |  FCF_ICON      |
                   FCF_SYSMENU       | FCF_MENU;

    // Create the main window
    hwndFrame = WinCreateStdWindow (HWND_DESKTOP, WS_VISIBLE,
                                    &flFrameFlags, szClientClass, szTitle,
                                    0, 0, ID_APPMAIN, &hwndClient);


    if (InitializeAppWindow () == ES_ERROR)
      {
      WinPostMsg(hwndClient, WM_QUIT, 0L, 0L);
      };

//    FillCanvasWithPcx ("test1.pcx", pcnvMainCanvas, TRUE);

    // Size the window here.
    Snap1_1 ();
    CenterWindow ();

    WinShowWindow (hwndFrame, TRUE);
    WinSetActiveWindow (HWND_DESKTOP, hwndFrame);


/******** New Code Start ********/

    // Create main game semaphores and timers

    // Setup the event semaphore and timer for regulation of game speed.
    if ((lAvailableTimers = WinQuerySysValue (HWND_DESKTOP, SV_CTIMERS)) <
        1)
      {
      PostError (hab, hwndFrame, IDS_ERR_NOTIMERS);
      WinPostMsg (hwndClient, WM_QUIT, 0L, 0L);
      };
    if (DosCreateEventSem (NULL, &hevTimerSem, DC_SEM_SHARED, FALSE) != NO_ERROR)
      {
      PostError (hab, hwndFrame, IDS_ERR_CREATESEM);
      WinPostMsg (hwndClient, WM_QUIT, 0L, 0L);
      };
    if (DosStartTimer (31L, (HSEM)hevTimerSem, &htimer) != NO_ERROR)
      {
      PostError (hab, hwndFrame, IDS_ERR_STARTTIMER);
      WinPostMsg (hwndClient, WM_QUIT, 0L, 0L);
      };
    if (DosCreateMutexSem (NULL, &hmtxModeChange, 0L, FALSE) != NO_ERROR)
      {
      PostError (hab, hwndFrame, IDS_ERR_CREATESEM);
      WinPostMsg (hwndClient, WM_QUIT, 0L, 0L);
      };

    if (DosCreateMutexSem (NULL, &hmtxAccess, 0L, FALSE) != NO_ERROR)
      {
      PostError (hab, hwndFrame, IDS_ERR_CREATESEM);
      WinPostMsg (hwndClient, WM_QUIT, 0L, 0L);
      };

    if (DosCreateMutexSem (NULL, &hmtxPause, 0L, FALSE) != NO_ERROR)
      {
      PostError (hab, hwndFrame, IDS_ERR_CREATESEM);
      WinPostMsg (hwndClient, WM_QUIT, 0L, 0L);
      };

    // Start up the blitting thread.
    if ( DosCreateThread (&tidGameThread, (PFNTHREAD) GameThreadProc,
                          0L, 0L, 12288L) == NO_ERROR)
      {
      // Set the proiroty of the blitting thread
      DosSetPriority ( PRTYS_THREAD, PRTYC_REGULAR,
                         0, tidGameThread );
      }
    else
      {
      PostError (hab, hwndFrame, IDS_ERR_CREATETHREAD);
      WinPostMsg (hwndClient, WM_QUIT, 0L, 0L);
      };

/******** New Code End ********/

    // Process messages while there are some.
    while (WinGetMsg (hab, &qmsg, 0, 0, 0))
        WinDispatchMsg (hab, &qmsg);


/******** New Code Start ********/

    // Set the variable to end the running thread, and wait for it to end.
    DosStopTimer (htimer);
    bEndGameThread = TRUE;
    DosPostEventSem (hevTimerSem);

    // if the blit thread is paused, we must unpause it so that it is
    //  free to terminate.
    if (bPaused)
      {
      DosReleaseMutexSem (hmtxPause);
      };

    DosWaitThread (&tidGameThread, DCWW_WAIT );

    DosCloseEventSem (hevTimerSem);
    DosCloseMutexSem (hmtxModeChange);
    DosCloseMutexSem (hmtxAccess);
    DosCloseMutexSem (hmtxPause);

/******** New Code End ********/

    WinSetVisibleRegionNotify (hwndClient, FALSE);
    };

  if (bDiveHaveBuffer)
    {
    DiveFreeImageBuffer (hDive, ulDiveBufferNumber);
    ulDiveBufferNumber = 0;
    bDiveHaveBuffer = FALSE;
    };

  if (pcnvMainCanvas != NULL)
    {
    delete (pcnvMainCanvas);
    pcnvMainCanvas = NULL;
    };

  if (hDive != NULLHANDLE) DiveClose (hDive);

  WinDestroyWindow (hwndFrame);

  WinDestroyMsgQueue (hmq);
  WinTerminate (hab);
  return (0);
  };

//........................................................................
ERRORSTATUS InitializeAppWindow
//........................................................................
  (
  VOID
  )
{
PBYTE              pbySurface;
ULONG              ulWidth;
USHORT             usLastError;



ulDiveBufferNumber = 0;
bDiveHaveBuffer = FALSE;

// Create your display canvas.  Make it a bottom up canvas for use with DIVE
if (pcnvMainCanvas != NULL) delete (pcnvMainCanvas);
pcnvMainCanvas = new Canvas ((USHORT)ulIMAGE_WIDTH,
                             (USHORT)ulIMAGE_HEIGHT,
                             FALSE);
if ((usLastError = pcnvMainCanvas->QueryLastErrorCode ()) != 0)
  {
  PostError (hab, hwndFrame, usLastError);
  return (ES_ERROR);
  };

pbySurface = pcnvMainCanvas->QuerySurface ();
ulWidth    = (ULONG) pcnvMainCanvas->QueryWidth ();

// Associate the canvas with a DIVE handle
if (DiveAllocImageBuffer (hDive, &ulDiveBufferNumber, FOURCC_LUT8,
                          ulIMAGE_WIDTH, ulIMAGE_HEIGHT,
                          ulWidth,  pbySurface) == ES_ERROR)
  {
  // post error message here.
  PostError (hab, hwndFrame, IDS_ERR_CREATE_DIVEBUFFER);
  return (ES_ERROR);
  };
bDiveHaveBuffer = TRUE;

// Turn on visible region notification.
WinSetVisibleRegionNotify (hwndClient, TRUE);

// Send an invalidation message to the client.
WinPostMsg (hwndFrame, WM_VRNENABLED, 0L, 0L );

return (ES_NO_ERROR);
};

//........................................................................
ERRORSTATUS DrawTestPcx
//........................................................................
  (
  VOID
  )
{
PcxPainter         pcxPainter;
ULONG              ulFileSize;
PBYTE              pbyBlock;
PBYTE              pbyPalette;
FILE *             fp;


// Load the sample PCX file

// Open the file.
if ((fp = fopen ("test1.pcx", "rb")) == NULL)
  {
  return (ES_ERROR);
  };

// Get it's total size
fseek (fp, 0, SEEK_END);
ulFileSize = ftell (fp);
fseek (fp, 0, SEEK_SET);

// Allocate memory for the file
if ((pbyBlock = (PBYTE) malloc (ulFileSize)) == NULL)
  {
  return (ES_ERROR);
  };

// Read the entire file.
if (fread (pbyBlock, 1, ulFileSize, fp) != ulFileSize)
  {
  // Unable to read the entire file.
  return (ES_ERROR);
  };

fclose (fp);


// Tell the painter object which buffer to use as input.
if (pcxPainter.AssociateBuffer (pbyBlock, ulFileSize) == ES_ERROR)
  {
  PostError (hab, hwndFrame, pcxPainter.QueryLastErrorCode ());
  return (ES_ERROR);
  };

// Tell the painter object which canvas to use as output.
if (pcxPainter.AssociateCanvas (pcnvMainCanvas) == ES_ERROR)
  {
  PostError (hab, hwndFrame, pcxPainter.QueryLastErrorCode ());
  return (ES_ERROR);
  };

// Draw the PCX file to the main canvas
if (pcxPainter.PaintCanvas () == ES_ERROR)
  {
  PostError (hab, hwndFrame, pcxPainter.QueryLastErrorCode ());
  return (ES_ERROR);
  };

pcxPainter.DissociateBuffer ();
pcxPainter.DissociateCanvas ();

// Set the source palette to the PCX palette

// Get a pointer to the palette.
pbyPalette = pcxPainter.QueryPaletteBuffer ();

// Initialize the palette object from the PCX's palette.
pal2Image.SetValuesFromRaw8 (pbyPalette, 0, 256);

// Set the system palette
pal2Image.InitSystemPalette (hab, hwndClient, hdcClientHDC, hpsMainHPS);

// Tell DIVE what the source image's palette is.
pal2Image.SetAsDiveSource (hDive);

// Set the DIVE destination palette to the new system palette

pal2Real.LoadActualPalette (hpsMainHPS);
pal2Real.SetAsDiveDestination (hDive);

// or you can use:

//DiveSetDestinationPalette (hDive, 0, 256, 0 );

return (ES_NO_ERROR);
};

//........................................................................
VOID Snap1_1
//........................................................................
  (
  VOID
  )
{
LONG               lBorderWidth;
LONG               lBorderHeight;
LONG               lTitlebarHeight;
LONG               lMenuHeight;



lBorderWidth    = (LONG) WinQuerySysValue (HWND_DESKTOP, SV_CXDLGFRAME);
lBorderHeight   = (LONG) WinQuerySysValue (HWND_DESKTOP, SV_CYDLGFRAME);
lTitlebarHeight = (LONG) WinQuerySysValue (HWND_DESKTOP, SV_CYTITLEBAR);
lMenuHeight     = (LONG) WinQuerySysValue (HWND_DESKTOP, SV_CYMENU);

lTotalWidth  = ulIMAGE_WIDTH + lBorderWidth * 2;
lTotalHeight = ulIMAGE_HEIGHT + (lBorderHeight * 2) + lTitlebarHeight +
               lMenuHeight;

// Set the window size.
WinSetWindowPos (hwndFrame,
                 HWND_TOP,
                 0, 0, lTotalWidth, lTotalHeight,
                 SWP_SIZE | SWP_SHOW | SWP_ACTIVATE);
};

//........................................................................
VOID CenterWindow
//........................................................................
  (
  VOID
  )
{
LONG               lcxWindowPos;
LONG               lcyWindowPos;


lcxWindowPos   = ( (LONG)WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN)
                     - lTotalWidth ) / 2;
lcyWindowPos   = ( (LONG)WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN)
                     - lTotalHeight ) / 2;

// Set the window position.
WinSetWindowPos (hwndFrame,
                 HWND_TOP,
                 lcxWindowPos, lcyWindowPos, 0, 0,
                 SWP_MOVE | SWP_SHOW | SWP_ACTIVATE);
};

//........................................................................
MRESULT EXPENTRY ClientWndProc
//........................................................................
  (
  HWND             hwnd,
  ULONG            msg,
  MPARAM           mp1,
  MPARAM           mp2
  )
{
POINTL             pointl;         // Point to offset from Desktop
SWP                swp;            // Window position
HRGN               hrgn;           // Region handle
RECTL              rcls[50];       // Rectangle coordinates
RGNRECT            rgnCtl;         // Processing control structure
SETUP_BLITTER      SetupBlitter;   // structure for DiveSetupBlitter
SIZEL              sizl;
ULONG              ulcPaletteColors = 256;


switch (msg)
  {
  case WM_CREATE:
       sizl.cx = sizl.cy = 0;
       hdcClientHDC = WinOpenWindowDC (hwnd);
       hpsMainHPS = GpiCreatePS (hab, hdcClientHDC, &sizl,
                           PU_PELS | GPIF_DEFAULT | GPIT_MICRO | GPIA_ASSOC);

       // Code differs from game1.cpp starting here.

       // Set the palette to the default 16 palette

       pal2Image.Default16         ();
       pal2Image.SetFlag           (PC_RESERVED);
       pal2Image.Convert           (PAL_FMT_OS2);
       pal2Image.InitSystemPalette (hab, hwnd, hdcClientHDC, hpsMainHPS);
       pal2Image.SetAsDiveSource   (hDive);

       pal2Real.LoadActualPalette    (hpsMainHPS);
       pal2Real.SetAsDiveDestination (hDive);

       // Alternatively, if you don't need to look at the specific colors
       //   of the real palette, the above pal2Real code can be replaced
       //   with the single line:
       // DiveSetDestinationPalette (hDive, 0, 256, 0 );

       return (0);

  case WM_DESTROY:
       pal2Image.UninitSystemPalette ();
       if (hpsMainHPS != NULLHANDLE)  GpiDestroyPS (hpsMainHPS);
       return (0);


#ifdef ADJUST_PALETTE_ON_FOCUS

  case WM_ACTIVATE:
       bAppIsActive = (BOOL) SHORT1FROMMP(mp1);

       if (bAppIsActive)
         {
         // Set the palette like you want it.
         pal2Image.RestoreSystemPalette ();

         // Repaint the image
         WinInvalidateRect (hwndClient, NULL, TRUE);
         }
       else
         {
         // Release the palette
         pal2Image.SuspendSystemPalette ();
         };
       return(0);

#endif // ADJUST_PALETTE_ON_FOCUS


  case WM_PAINT:
       // Notice here that the HPS created during the WM_CREATE message
       //   is used for both WinBeginPaint() and WinEndPaint().  This saves
       //   resources since WinBeginPaint() doesn't have to create a new HPS.

       WinBeginPaint (hwnd, hpsMainHPS, NULL);

       // blit Dive buffer to screen.
       DiveBlitImage (hDive,
                      ulDiveBufferNumber,
                      DIVE_BUFFER_SCREEN );

       WinEndPaint (hpsMainHPS);
       return (0);

  case WM_COMMAND:
       switch (SHORT1FROMMP(mp1))
         {
         case IDM_QUIT:
           {
           WinPostMsg(hwndClient, WM_CLOSE, MPVOID, MPVOID);
           return(0);
           };
         case IDM_PAUSE:
           {
           // depending on the state of the pause flag, either pause or
           //  unpause the blit thread.

           if (bPaused)
             {
             // already paused, so start it again.
             DosReleaseMutexSem (hmtxPause);
             bPaused = FALSE;
             }
           else
             {
             // not paused yet, so request semaphore and pause it
             DosRequestMutexSem (hmtxPause, SEM_INDEFINITE_WAIT);
             bPaused = TRUE;
             };
           return (0);
           };
         case IDM_SCROLL:
           {
           // since both this thread and the blit thread must access the
           //  bScrolling variable, control access to it with a semaphore.

           DosRequestMutexSem (hmtxAccess, SEM_INDEFINITE_WAIT);

           if (bScrolling == TRUE)
             {
             bScrolling = FALSE;
             }
           else
             {
             bScrolling = TRUE;
             };

           DosReleaseMutexSem (hmtxAccess);
           };
         };
       break;

  case WM_REALIZEPALETTE:
       // This tells DIVE that the physical palette may have changed.
       DiveSetDestinationPalette (hDive, 0, 256, 0 );
       break;

  case WM_VRNDISABLED:
       DiveSetupBlitter (hDive, 0);
       break;

  case WM_VRNENABLED:
       if ( !hpsMainHPS )
          break;
       hrgn = GpiCreateRegion ( hpsMainHPS, 0L, NULL );
       if ( hrgn )
          {
          // NOTE: If mp1 is zero, then this was just a move message.
          // Illustrate the visible region on a WM_VRNENABLE.
          //
          WinQueryVisibleRegion ( hwnd, hrgn );
          rgnCtl.ircStart     = 0;
          rgnCtl.crc          = 50;
          rgnCtl.ulDirection  = 1;

          // Get the all ORed rectangles
          if ( GpiQueryRegionRects ( hpsMainHPS, hrgn, NULL, &rgnCtl, rcls) )
             {
             // Now find the window position and size, relative to parent.
             WinQueryWindowPos (hwndClient, &swp );

             // Convert the point to offset from desktop lower left.
             pointl.x = swp.x;
             pointl.y = swp.y;
             WinMapWindowPoints ( hwndFrame, HWND_DESKTOP, &pointl, 1 );

             // Tell DIVE about the new settings.
             SetupBlitter.ulStructLen = sizeof ( SETUP_BLITTER );
             SetupBlitter.fccSrcColorFormat = FOURCC_LUT8;
             SetupBlitter.ulSrcWidth   = ulIMAGE_WIDTH;
             SetupBlitter.ulSrcHeight  = ulIMAGE_HEIGHT;
             SetupBlitter.ulSrcPosX    = 0;
             SetupBlitter.ulSrcPosY    = 0;
             SetupBlitter.fInvert      = TRUE;
             SetupBlitter.ulDitherType = 1;

             SetupBlitter.fccDstColorFormat = FOURCC_SCRN;
             SetupBlitter.ulDstWidth        = swp.cx;
             SetupBlitter.ulDstHeight       = swp.cy;
             SetupBlitter.lDstPosX          = 0;
             SetupBlitter.lDstPosY          = 0;
             SetupBlitter.lScreenPosX       = pointl.x;
             SetupBlitter.lScreenPosY       = pointl.y;
             SetupBlitter.ulNumDstRects     = rgnCtl.crcReturned;
             SetupBlitter.pVisDstRects      = rcls;
             DiveSetupBlitter (hDive, &SetupBlitter);
             }
          else
             DiveSetupBlitter (hDive, 0);

          GpiDestroyRegion (hpsMainHPS, hrgn);
          }
       break;

  case WM_POST_ERROR:
       PostError (hab, hwndFrame, SHORT1FROMMP (mp1));
       if (SHORT1FROMMP (mp2) == 1)
         {
         WinPostMsg (hwndClient, WM_QUIT, 0L, 0L);
         };
       return (0);

  }; // switch (msg)

return (WinDefWindowProc(hwnd, msg, mp1, mp2));
};

//........................................................................
ERRORSTATUS InitializeDive
//........................................................................
  (
  VOID
  )
{


// Get the screen capabilities, and if the system supports only 16 colors
//  the program should be terminated.

DiveCaps.pFormatData    = fccFormats;
DiveCaps.ulFormatLength = 100;
DiveCaps.ulStructLen    = sizeof(DIVE_CAPS);

if ( DiveQueryCaps ( &DiveCaps, DIVE_BUFFER_SCREEN ))
   {
   WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
       (PSZ)"Error: DIVE routines cannot function in this system environment.",
       (PSZ)"   This program is unable to run.", 0, MB_OK | MB_INFORMATION );
   return (ES_ERROR);
   };

if ( DiveCaps.ulDepth < 8 )
   {
   WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
       (PSZ)"Error: Not enough screen colors to run DIVE.  Must be at least 256 colors.",
       (PSZ)"   This program is unable to run.", 0, MB_OK | MB_INFORMATION );
   return (ES_ERROR);
   };

// Get an instance of DIVE APIs.
if ( DiveOpen ( &hDive, FALSE, 0 ) )
   {
   WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
       (PSZ)"Error: Unable to open an instance of DIVE.",
       (PSZ)"   This program is unable to run.", 0, MB_OK | MB_INFORMATION );
   return (ES_ERROR);
   };

return (ES_NO_ERROR);
};


//........................................................................
VOID APIENTRY GameThreadProc
//........................................................................
  (
  ULONG parm1
  )
{
ULONG              ulSemCount;
Canvas             cnvBGCanvas (sBGCANVAS_WIDTH, sBGCANVAS_HEIGHT, TRUE);
Canvas             cnvSpriteCanvas (320, 200, TRUE);
USHORT             usLastError;

// Coordinate handling variables
SHORT              sTopY         = 0;
SHORT              sBufHeight1;
SHORT              sBufHeight2;

BOOL               bLocalScrolling;
BYTE               byBook;
USHORT             usIndex;


// Remove compiler warning, since we won't be using the passed parameter.
parm1 = parm1;

// here we will do some setup for the game.

// Make sure the Background canvas allocated ok (local variable above).
if ((usLastError = cnvBGCanvas.QueryLastErrorCode()) != 0)
  {
  // Note that we cannot display a message box from this thread, or "send"
  //  a message to another thread because this is a non-message queue
  //  thread.  Therefore we must "post" a message to the main message queue
  //  thread and have it display any error messages.
  // The WM_POST_ERROR message takes the error code in mp1, and uses that
  //  code to call PostError.  The mp2 parameter takes a TRUE or a FALSE,
  //  and specifies whether or not a WM_QUIT message should be posted after
  //  the error message is displayed.  This can be used to terminate the
  //  program if an unrecoverable error occurs.

  WinPostMsg (hwndClient, WM_POST_ERROR,
              MPFROMSHORT (usLastError), (MPARAM)TRUE);
  return;
  };


// load the background into the background canvas

FillCanvasWithPcx ("game3a.pcx", &cnvBGCanvas, TRUE);

// load the sprite pcx into the sprite canvas.  We already have a palette
//   from the BG PCX (it's the same as the sprite pcx palette), so we give
//   a "false" as the third parameter.
FillCanvasWithPcx ("game3b.pcx", &cnvSpriteCanvas, FALSE);

// tell the sprite manager which canvases to use
smSprites.SetDisplayCanvas (pcnvMainCanvas);
smSprites.SetEncodeCanvas  (&cnvSpriteCanvas);

// Find a spot to open a new book, and create it by telling how many members
//  it has
smSprites.FindEmptyBook (&byBook);
smSprites.SetNumSprites (byBook, 5);

// encode the sprites
for (usIndex = 0; usIndex < 5; ++usIndex)
  {
  smSprites.EncodeSprite  ((SHORT)(usIndex * 19),          0,
                           (SHORT)((usIndex * 19) + 18),  15,
                           byBook, usIndex);
  };

while ( !bEndGameThread )
  {
  // Here you need code to regulate the speed of the game by delaying the
  //  game/blit thread loop.  Currently I am using an event semaphore
  //  hooked to a timer, but this can be replaced by other timing methods.

  // block on the semaphore until the timer posts it.
  DosWaitEventSem  (hevTimerSem, SEM_INDEFINITE_WAIT);

  // clear the semaphore for the next iteration though the main loop
  DosResetEventSem (hevTimerSem, &ulSemCount);


  // check and see if the game is paused.  We request the pause semaphore
  //  to see if the game is paused.  If the game is not paused,
  //  DosRequestMutexSem will return immediately.  If the game is paused,
  //  the thread will block until the game is unpaused.
  DosRequestMutexSem (hmtxPause, SEM_INDEFINITE_WAIT);
  // We release the semaphore immediatly once we know that we can resume,
  //  so the main thread can pause this thread again.
  DosReleaseMutexSem (hmtxPause);


  //== Game state manipulation

  // Secure against this thread and the main thread from accessing a
  //  variable at the same time.
  // Since we will use these variables below to enter code that takes
  //  a while, we will move the variables to local storage and release the
  //  semaphore so that we don't hold up the main thread and the message
  //  queue if it needs to access the variables.

  DosRequestMutexSem (hmtxAccess, SEM_INDEFINITE_WAIT);
  bLocalScrolling = bScrolling;
  DosReleaseMutexSem (hmtxAccess);

  if (bLocalScrolling)
    {
    // move the position of the background

    sTopY -= 1;

    if (sTopY < -sBGCANVAS_HEIGHT) sTopY = 0;
    }
  else
    {
    // We set sTopY to zero so that if we resume scrolling, we will start
    //  from the stopped position.  Going from scrolling mode to no
    //  scrolling mode will cause the background to snap back to the top
    //  of the background buffer.  I do this to illustrate a straight one
    //  step canvas to canvas copy for erasing the background.  Scrolling
    //  requires that the copy be done in two steps since the background
    //  canvas will wrap around during scrolling.

    sTopY = 0;
    };




  //== Graphics screen construction


  // Secure against a mode change while blitting.  This will be needed for
  //  fullscreen DIVE support so that the game does not blit while DIVE
  //  is changing from a PM window to fullscreen, and vice versa.  If we
  //  do not stop blitting, there is a chance that our palette or graphics
  //  will be messed up.
  DosRequestMutexSem (hmtxModeChange, SEM_INDEFINITE_WAIT);


  // erase the display canvas with the background

  if (bLocalScrolling)
    {
    // if scrolling, then
    // the background buffer nee

    //* Calculate buffer split position.

    sBufHeight1 = (SHORT) min (ulIMAGE_HEIGHT, sBGCANVAS_HEIGHT + sTopY);
    sBufHeight2 = (SHORT) (ulIMAGE_HEIGHT - sBufHeight1);

    //* Draw first half of buffer to DIVE buffer.
    cnvBGCanvas.CopyDirtyRec (0, (SHORT)-sTopY, 0, 0,
                              ulIMAGE_WIDTH,
                              (USHORT) sBufHeight1,
                              pcnvMainCanvas, BOUNDS_NONE);

    //* Draw second half of buffer to DIVE buffer.
    if (sBufHeight2 > 0)
      {
      cnvBGCanvas.CopyDirtyRec (0, 0, 0, sBufHeight1,
                                ulIMAGE_WIDTH,
                                (USHORT) sBufHeight2,
                                pcnvMainCanvas, BOUNDS_NONE);
      };
    }
  else
    {
    // no scrolling
    cnvBGCanvas.CopyDirtyRec (0, 0, 0, 0,
                              ulIMAGE_WIDTH,
                              ulIMAGE_HEIGHT,
                              pcnvMainCanvas, BOUNDS_NONE);

    };

  // draw sprites

  DrawAlien (byBook);


  // == Send the image to the screen.
  // * blit Dive buffer to screen.
  DiveBlitImage (hDive,
                 ulDiveBufferNumber,
                 DIVE_BUFFER_SCREEN );


  DosReleaseMutexSem (hmtxModeChange);

  // Give other processes some time if there is still time left in
  //  this timeslice
  DosSleep ( 0 );

  //-Loop
  };

return;
};

//........................................................................
ERRORSTATUS FillCanvasWithPcx
//........................................................................
  (
  PCHAR            szFilenameIn,
  PCANVAS          pcnvCanvasIn,
  BOOL             bUsePaletteForSystem
  )
{
PcxPainter         pcxPainter;
ULONG              ulFileSize;
PBYTE              pbyBlock;
PBYTE              pbyPalette;
FILE *             fp;


// Load the sample PCX file

// Open the file.
if ((fp = fopen (szFilenameIn, "rb")) == NULL)
  {
  return (ES_ERROR);
  };

// Get it's total size
fseek (fp, 0, SEEK_END);
ulFileSize = ftell (fp);
fseek (fp, 0, SEEK_SET);

// Allocate memory for the file
if ((pbyBlock = (PBYTE) malloc (ulFileSize)) == NULL)
  {
  return (ES_ERROR);
  };

// Read the entire file.
if (fread (pbyBlock, 1, ulFileSize, fp) != ulFileSize)
  {
  // Unable to read the entire file.
  return (ES_ERROR);
  };

fclose (fp);


// Tell the painter object which buffer to use as input.
if (pcxPainter.AssociateBuffer (pbyBlock, ulFileSize) == ES_ERROR)
  {
  PostError (hab, hwndFrame, pcxPainter.QueryLastErrorCode ());
  return (ES_ERROR);
  };

// Tell the painter object which canvas to use as output.
if (pcxPainter.AssociateCanvas (pcnvCanvasIn) == ES_ERROR)
  {
  PostError (hab, hwndFrame, pcxPainter.QueryLastErrorCode ());
  return (ES_ERROR);
  };

// Draw the PCX file to the requested canvas
if (pcxPainter.PaintCanvas () == ES_ERROR)
  {
  PostError (hab, hwndFrame, pcxPainter.QueryLastErrorCode ());
  return (ES_ERROR);
  };

pcxPainter.DissociateBuffer ();
pcxPainter.DissociateCanvas ();

if (bUsePaletteForSystem)
  {
  // Set the system palette to the PCX palette

  // Get a pointer to the palette.
  pbyPalette = pcxPainter.QueryPaletteBuffer ();

  // Initialize the palette object from the PCX's palette.
  pal2Image.SetValuesFromRaw8 (pbyPalette, 0, 256);

  // Set the system palette
  pal2Image.InitSystemPalette (hab, hwndClient, hdcClientHDC, hpsMainHPS);

  // Tell DIVE what the source image's palette is.
  pal2Image.SetAsDiveSource (hDive);

  // Set the DIVE destination palette to the new system palette
  pal2Real.LoadActualPalette (hpsMainHPS);
  pal2Real.SetAsDiveDestination (hDive);
  };
return (ES_NO_ERROR);
};

//........................................................................
VOID DrawAlien
//........................................................................
  (
  BYTE             byBook
  )
{
static SHORT       sXPos         = 10;
static SHORT       sYPos         = 50;
static SHORT       sSpriteNumber = 0;
static SHORT       sDirection    = 0;
SHORT              sIncrement;


// we will increment sSpriteNumber every frame, but we will divide it by
//  two so the actual sprite number increments every other frame.
++sSpriteNumber;

if (sSpriteNumber >= 10) sSpriteNumber = 0;

// adjust X position depending on which frame of animation we are on
sIncrement = 0;
if ((sSpriteNumber & 2) == 0)
  {
  switch (sSpriteNumber / 2)
    {
    case 0:
      {
      sIncrement = 1;
      };
      break;
    case 1:
      {
      sIncrement = 0;
      };
      break;
    case 2:
      {
      sIncrement = 1;
      };
      break;
    case 3:
      {
      sIncrement = 3;
      };
      break;
    case 4:
      {
      sIncrement = 0;
      };
      break;
    };
  };

sXPos += sIncrement;
if (sXPos > 300) sXPos = 10;

smSprites.DisplayUnclippedSprite  (sXPos, sYPos,
                                   byBook, (USHORT)(sSpriteNumber / 2));
};







