//-------------------------------------------------------------------------
// This is the source for the scrollbar sample as provided with the EDM/2
// column _Introduction to PM Programming_.
//
// Written by:  Larry Salomon
//-------------------------------------------------------------------------
#define INCL_GPILCIDS
#define INCL_GPIPRIMITIVES
#define INCL_WINFRAMEMGR
#define INCL_WINSCROLLBARS
#define INCL_WINSYS
#define INCL_WINWINDOWMGR
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define CLS_CLIENT               "IntroClass"

#define MAX_WIDTH                96
#define MAX_HEIGHT               30

//-------------------------------------------------------------------------
// Instance data structure
//-------------------------------------------------------------------------
typedef struct {
   ULONG ulSzStruct;             // Size of the structure
   HAB habAnchor;                // Anchor block handle
   HWND hwndFrame;               // Frame window handle
   HWND hwndHorz;                // Horizontal scrollbar handle
   HWND hwndVert;                // Vertical scrollbar handle
   LONG lHorzPos;                // Position of the horizontal scrollbar
   LONG lHorzMin;                // Minimum value of the horizontal scrollbar
   LONG lHorzMax;                // Maximum value of the horizontal scrollbar
   LONG lVertPos;                // Position of the vertical scrollbar
   LONG lVertMin;                // Minimum value of the vertical scrollbar
   LONG lVertMax;                // Maximum value of the vertical scrollbar
   ULONG ulWidth;                // Width in characters
   ULONG ulHeight;               // Height in characters
   ULONG ulCxChar;               // Width of a character
   ULONG ulCyChar;               // Height of a character
} INSTDATA, *PINSTDATA;

MRESULT EXPENTRY wndProc(HWND hwndWnd,
                         ULONG ulMsg,
                         MPARAM mpParm1,
                         MPARAM mpParm2)
//-------------------------------------------------------------------------
// This is the window procedure.
//-------------------------------------------------------------------------
{
   PINSTDATA pidData;

   pidData=(PINSTDATA)WinQueryWindowPtr(hwndWnd,0);

   switch (ulMsg) {
   case WM_CREATE:
      {
         CHAR achFont[64];
         HPS hpsWnd;
         FONTMETRICS fmFont;

         //----------------------------------------------------------------
         // Allocate memory for and initialize the instance data for this
         // window.
         //----------------------------------------------------------------
         pidData=calloc(1,sizeof(INSTDATA));
         if (pidData==NULL) {
            WinAlarm(HWND_DESKTOP,WA_ERROR);
            return MRFROMSHORT(TRUE);
         } /* endif */

         pidData->ulSzStruct=sizeof(INSTDATA);

         WinSetWindowPtr(hwndWnd,0,pidData);

         pidData->habAnchor=WinQueryAnchorBlock(hwndWnd);
         pidData->hwndFrame=WinQueryWindow(hwndWnd,QW_PARENT);
         pidData->hwndHorz=WinWindowFromID(pidData->hwndFrame,FID_HORZSCROLL);
         pidData->hwndVert=WinWindowFromID(pidData->hwndFrame,FID_VERTSCROLL);

         //----------------------------------------------------------------
         // Note that these are initialized in the WM_SIZE processing.
         //----------------------------------------------------------------
         pidData->lHorzPos=0;
         pidData->lHorzMin=0;
         pidData->lHorzMax=0;
         pidData->lVertPos=0;
         pidData->lVertMin=0;
         pidData->lVertMax=0;
         pidData->ulWidth=0;
         pidData->ulHeight=0;

         //----------------------------------------------------------------
         // @11
         //
         // Set the font to be a fixed pitch font before we determine the
         // character width and height.
         //----------------------------------------------------------------
         strcpy(achFont,"10.System Monospaced");
         WinSetPresParam(hwndWnd,PP_FONTNAMESIZE,strlen(achFont)+1,achFont);

         hpsWnd=WinGetPS(hwndWnd);
         GpiQueryFontMetrics(hpsWnd,sizeof(fmFont),&fmFont);
         WinReleasePS(hpsWnd);

         pidData->ulCxChar=fmFont.lAveCharWidth;
         pidData->ulCyChar=fmFont.lMaxBaselineExt;
      }
      break;
   case WM_DESTROY:
      free(pidData);
      break;
   case WM_SIZE:
      //-------------------------------------------------------------------
      // @12
      //
      // Recalculate the size-dependent fields of the instance data.
      //-------------------------------------------------------------------
      pidData->ulWidth=SHORT1FROMMP(mpParm2)/pidData->ulCxChar;
      pidData->ulHeight=SHORT2FROMMP(mpParm2)/pidData->ulCyChar;

      //-------------------------------------------------------------------
      // Remember, the scrollbars allow you to see what is _not_ visible,
      // so subtract out the visible portion.
      //-------------------------------------------------------------------
      pidData->lHorzMax=MAX_WIDTH-pidData->ulWidth;
      if (pidData->lHorzMax<0) {
         pidData->lHorzMax=0;
      } /* endif */

      pidData->lVertMax=MAX_HEIGHT-pidData->ulHeight;
      if (pidData->lVertMax<0) {
         pidData->lVertMax=0;
      } /* endif */

      //-------------------------------------------------------------------
      // @13
      //
      // Set the scrollbar ranges and thumb sizes based on the values.
      //-------------------------------------------------------------------
      WinSendMsg(pidData->hwndHorz,
                 SBM_SETSCROLLBAR,
                 MPFROMSHORT(pidData->lHorzPos),
                 MPFROM2SHORT(0,pidData->lHorzMax));

      WinSendMsg(pidData->hwndVert,
                 SBM_SETSCROLLBAR,
                 MPFROMSHORT(pidData->lVertPos),
                 MPFROM2SHORT(0,pidData->lVertMax));

      WinSendMsg(pidData->hwndHorz,
                 SBM_SETTHUMBSIZE,
                 MPFROM2SHORT(pidData->ulWidth,MAX_WIDTH),
                 0);

      WinSendMsg(pidData->hwndVert,
                 SBM_SETTHUMBSIZE,
                 MPFROM2SHORT(pidData->ulHeight,MAX_HEIGHT),
                 0);
      break;
   case WM_HSCROLL:
      {
         LONG lDx;

         //----------------------------------------------------------------
         // @14
         //
         // We are the ones to define what a "line" and a "page" is.
         //----------------------------------------------------------------
         switch (SHORT2FROMMP(mpParm2)) {
         case SB_LINELEFT:
            lDx=-1;
            break;
         case SB_PAGELEFT:
            lDx=-5;
            break;
         case SB_LINERIGHT:
            lDx=1;
            break;
         case SB_PAGERIGHT:
            lDx=5;
            break;
         case SB_SLIDERPOSITION:
            //-------------------------------------------------------------
            // Determine what the delta should be to get from where we
            // were to where the message says we are now.
            //-------------------------------------------------------------
            lDx=SHORT1FROMMP(mpParm2)-pidData->lHorzPos;
            break;
         default:
            return MRFROMSHORT(FALSE);
         } /* endswitch */

         //----------------------------------------------------------------
         // Update the field, perform range checking, and tell the
         // scrollbar that it should use the new position.
         //----------------------------------------------------------------
         pidData->lHorzPos+=lDx;

         if (pidData->lHorzPos<pidData->lHorzMin) {
            pidData->lHorzPos=pidData->lHorzMin;
         } /* endif */

         if (pidData->lHorzPos>pidData->lHorzMax) {
            pidData->lHorzPos=pidData->lHorzMax;
         } /* endif */

         WinSendMsg(pidData->hwndHorz,
                    SBM_SETPOS,
                    MPFROMSHORT(pidData->lHorzPos),
                    0);

         //----------------------------------------------------------------
         // @15
         //
         // Invalidate and repaint.  _Extremely_ inefficient!
         //----------------------------------------------------------------
         WinInvalidateRect(hwndWnd,NULL,FALSE);
         WinUpdateWindow(hwndWnd);
      }
      break;
   case WM_VSCROLL:
      {
         LONG lDy;

         //----------------------------------------------------------------
         // We are the ones to define what a "line" and a "page" is.
         //----------------------------------------------------------------
         switch (SHORT2FROMMP(mpParm2)) {
         case SB_LINEUP:
            lDy=-1;
            break;
         case SB_PAGEUP:
            lDy=-5;
            break;
         case SB_LINEDOWN:
            lDy=1;
            break;
         case SB_PAGEDOWN:
            lDy=5;
            break;
         case SB_SLIDERPOSITION:
            //-------------------------------------------------------------
            // Determine what the delta should be to get from where we
            // were to where the message says we are now.
            //-------------------------------------------------------------
            lDy=SHORT1FROMMP(mpParm2)-pidData->lVertPos;
            break;
         default:
            return MRFROMSHORT(FALSE);
         } /* endswitch */

         //----------------------------------------------------------------
         // Update the field, perform range checking, and tell the
         // scrollbar that it should use the new position.
         //----------------------------------------------------------------
         pidData->lVertPos+=lDy;

         if (pidData->lVertPos<pidData->lVertMin) {
            pidData->lVertPos=pidData->lVertMin;
         } /* endif */

         if (pidData->lVertPos>pidData->lVertMax) {
            pidData->lVertPos=pidData->lVertMax;
         } /* endif */

         WinSendMsg(pidData->hwndVert,
                    SBM_SETPOS,
                    MPFROMSHORT(pidData->lVertPos),
                    0);

         //----------------------------------------------------------------
         // Invalidate and repaint.  _Extremely_ inefficient!
         //----------------------------------------------------------------
         WinInvalidateRect(hwndWnd,NULL,FALSE);
         WinUpdateWindow(hwndWnd);
      }
      break;
   case WM_PAINT:
      {
         HPS hpsPaint;
         RECTL rclPaint;
         CHAR achLine[8];
         CHAR achText[MAX_WIDTH+1];
         LONG lIndex;
         LONG lFirst;
         LONG lLast;
         RECTL rclWnd;
         POINTL ptlPoint;

         hpsPaint=WinBeginPaint(hwndWnd,NULLHANDLE,&rclPaint);

         WinFillRect(hpsPaint,&rclPaint,CLR_WHITE);

         //----------------------------------------------------------------
         // @16
         //
         // Determine the string that we're going to write out.  Don't
         // forget to take the horizontal scrollbar position into account!
         //----------------------------------------------------------------
         lFirst=pidData->lHorzPos;
         lLast=MAX_WIDTH;

         if (lLast-lFirst+1>pidData->ulWidth) {
            lLast=lFirst+pidData->ulWidth;
         } /* endif */

         memset(achText,0,sizeof(achText));

         for (lIndex=lFirst; lIndex<lLast; lIndex++) {
            achText[lIndex-lFirst]=32+lIndex;
         } /* endfor */

         //----------------------------------------------------------------
         // @17
         //
         // Determine the start and end lines to draw, initialize the
         // starting point, and loop-to-draw.
         //----------------------------------------------------------------
         lFirst=pidData->lVertPos;
         lLast=MAX_HEIGHT;

         if (lLast-lFirst+1>pidData->ulHeight) {
            lLast=lFirst+pidData->ulHeight;
         } /* endif */

         WinQueryWindowRect(hwndWnd,&rclWnd);

         ptlPoint.x=0;
         ptlPoint.y=rclWnd.yTop-1-pidData->ulCyChar;

         for (lIndex=lFirst; lIndex<lLast; lIndex++) {
            //-------------------------------------------------------------
            // Overwrite the first four characters with the line number,
            // so that we know we're doing things properly.
            //-------------------------------------------------------------
            sprintf(achLine,"%2d ",lIndex+1);
            strncpy(achText,achLine,strlen(achLine));

            GpiCharStringAt(hpsPaint,&ptlPoint,strlen(achText),achText);
            ptlPoint.y-=pidData->ulCyChar;
         } /* endfor */

         WinEndPaint(hpsPaint);
      }
      break;
   default:
      return WinDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
   } /* endswitch */

   return MRFROMSHORT(FALSE);
}

INT main(VOID)
//-------------------------------------------------------------------------
// This is the main procedure.
//-------------------------------------------------------------------------
{
   HAB habAnchor;
   HMQ hmqQueue;
   ULONG ulCreate;
   HWND hwndFrame;
   HWND hwndClient;
   BOOL bLoop;
   QMSG qmMsg;

   habAnchor=WinInitialize(0);
   hmqQueue=WinCreateMsgQueue(habAnchor,0);

   WinRegisterClass(habAnchor,CLS_CLIENT,wndProc,CS_SIZEREDRAW,sizeof(PVOID));

   ulCreate=FCF_SYSMENU | FCF_TITLEBAR | FCF_MAXBUTTON |
               FCF_HORZSCROLL | FCF_VERTSCROLL | FCF_SIZEBORDER |
               FCF_TASKLIST | FCF_SHELLPOSITION;

   hwndFrame=WinCreateStdWindow(HWND_DESKTOP,
                                WS_VISIBLE,
                                &ulCreate,
                                CLS_CLIENT,
                                "Scrollbar Sample 1",
                                0,
                                NULLHANDLE,
                                0,
                                &hwndClient);
   if (hwndFrame!=NULLHANDLE) {
      WinSetWindowPos(hwndFrame,NULLHANDLE,0,0,0,0,SWP_ACTIVATE);

      bLoop=WinGetMsg(habAnchor,&qmMsg,NULLHANDLE,0,0);
      while (bLoop) {
         WinDispatchMsg(habAnchor,&qmMsg);
         bLoop=WinGetMsg(habAnchor,&qmMsg,NULLHANDLE,0,0);
      } /* endwhile */

      WinDestroyWindow(hwndFrame);
   } /* endif */

   WinDestroyMsgQueue(hmqQueue);
   WinTerminate(habAnchor);
   return 0;
}
