/**************************************************************
*             protocoll.cpp                                   *
*                                                             *
* This file contains the implementation of the                *
* OProtocoll, OProcedure and OMethod classes.                 *
*                                                             *
* Written by Timm Morten Steinbeck for EDM/2 1994             *
* Internet: Timm_Steinbeck@AC3.maus.de                        *
*                                                             *
**************************************************************/

#define _PROTOCOLL_CPP_
#include "prot.h"
#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

// Global declaration of the central pointer to a protocoll instance
#if defined (DBG_PROT_TEXT) || defined(DBG_PROT_MSG) || defined(DBG_PROT_LO=
NG)
|| defined(DBG_PROT_PROC)
OProtocoll *ProtP=3DNULL;

// Constructor of the OProtocoll class
// arguments: char* for the filename where the protocoll is to be=
 stored

OProtocoll::OProtocoll(char* FileName) {
  int Handle;
#ifdef __EMX__                 // Find the full file name, in case=
 the program
changes the working directory
  char tmp[255];
  *tmp=3D0;
  _abspath(tmp, FileName, sizeof(tmp));
  PathName=3Dstrdup(tmp);
#else
  PathName=3DNULL;
  PathName=3D_fullpath(PathName, FileName, 0);
#endif
  Handle=3Dopen(PathName, O_CREAT|O_TRUNC|O_RDWR, S_IWRITE);
  if (Handle=3D=3D-1)
    IO=3D0;
  else
    IO=3D1;
  if (IO) {                // Get time and date and write them in=
 the file.
    time_t t;
    char tmp[40], *Zeit;
    time(&t);
    Zeit=3Dctime(&t);
    sprintf(tmp, "Start of session\n");
    write(Handle, tmp, strlen(tmp));
    strcpy(tmp, Zeit);
    write(Handle, tmp, strlen(tmp));
    close(Handle);                  // File is closed after every=
 use, so that
no information
                                     // is lost in some RTL internal=
 caches.
  }
}


// Destructor of the OProtocoll class
// arguments: None

OProtocoll::~OProtocoll(void) {
  int Handle;
  Handle=3Dopen(PathName, O_RDWR|O_APPEND);
  if (Handle=3D=3D-1)
    IO=3D0;
  if (IO) {             // Again take the time and date.
    time_t t;
    char tmp[40], *Zeit;
    time(&t);
    Zeit=3Dctime(&t);
    sprintf(tmp, "End of session\n");
    write(Handle, tmp, strlen(tmp));
    strcpy(tmp, Zeit);
    write(Handle, tmp, strlen(tmp));
    close(Handle);
  }
  free(PathName);
}


// OProtocoll::Text Writes text to protocoll file
// arguments: char* to the text to be written
// return value: none

void OProtocoll::Text(char* AText) {
  int Handle;
  Handle=3Dopen(PathName, O_RDWR|O_APPEND);
  if (Handle=3D=3D-1)
    IO=3D0;
  if (IO) {             // File could just now, or sometime before=
 not be
opened
    write(Handle, AText, strlen(AText));
    close(Handle);
  }
}


// OProtocll::Msg: Writes a complete received message, incl. window=
 handle,
//                 message number and parameters to file
// arguments: HWND, UINT, MPARAM, and MPARAM as passed to window function

void OProtocoll::Msg(HWND hWnd, UINT Msg, MPARAM P1, MPARAM P2) {
  char tmp[500];
  sprintf(tmp, "Message: 0x%lX\t0x%lX\t0x%lX\t0x%lX\n", hWnd, Msg,=
 P1, P2);
  Text(tmp);
}


// OProtocoll::Long: Writes a long integer to protocoll file
// arguments: char* as a comment about the long to be written and=
 the long

void OProtocoll::Long(char *c, long ALong) {
  char tmp[500];
  sprintf(tmp, "%s: 0x%lX\n", c, ALong);
  Text(tmp);
}

#endif

// Constructor of the OProcedure class
// arguments: char* name of the procedure

#if defined(DBG_PROT_PROC)

OProcedure::OProcedure(char *Name) {
  if (Name) {
    long Len=3Dstrlen(Name);
    ProcName=3Dnew char[Len+2];
    strcpy(ProcName, Name);
    char *tmp=3Dnew char[Len+16];
    sprintf(tmp, "Function --> %s\n", ProcName);
    if (ProtP)
      ProtP->Text(tmp);
    delete[] tmp;
  }
  else
    ProcName=3DNULL;
}


// Destructor of OProcedure
// arguments: none

OProcedure::~OProcedure() {
  if (ProcName) {
    char *tmp=3Dnew char[strlen(ProcName)+16];
    sprintf(tmp, "Function <-- %s\n", ProcName);
    if (ProtP)
      ProtP->Text(tmp);
    delete[] ProcName;
    delete[] tmp;
  }
}


// Constructor of OMethod
// arguments: void* to instance referenced, char* name of method

OMethod::OMethod(void *That, char *Name) {
  that=3DThat;
  if (Name) {
    long Len=3Dstrlen(Name);
    ProcName=3Dnew char[Len+2];
    strcpy(ProcName, Name);
    if (ProtP) {
      char *tmp=3Dnew char[Len+40];
      sprintf(tmp, "Object 0x%lX\tMethod --> %s\n", that,ProcName);
      if (ProtP)
        ProtP->Text(tmp);
      delete[] tmp;
    }
  }
  else
    ProcName=3DNULL;
}


// Destructor of OMethod
// arguments: none

OMethod::~OMethod() {
  if (ProcName) {
    char *tmp=3Dnew char[strlen(ProcName)+40];
    sprintf(tmp, "Object 0x%lX\tMethod <-- %s\n", that, ProcName);
    if (ProtP)
      ProtP->Text(tmp);
    delete[] ProcName;
    delete[] tmp;
  }
}

#endif

