#define INCL_DOSPROCESS
#define INCL_WINWINDOWMGR
#include "defs.h"
#include <stdlib.h>
#include <string.h>

VOID querySpaceRect(HWND hwndWnd,USHORT usX,USHORT usY,PRECTL prclSpace)
//-------------------------------------------------------------------------
// This function returns the rectangle for the coordinates (usX,usY).
//
// Input:  hwndWnd - specifies the saver window
//         usX, usY - specifies the coordinates
// Output:  prclSpace - points to the rectangle for the space
//-------------------------------------------------------------------------
{
   PSAVERDATA psdData;
   RECTL rclWnd;

   psdData=WinQueryWindowPtr(hwndWnd,0);
   WinQueryWindowRect(hwndWnd,&rclWnd);
   prclSpace->xLeft=rclWnd.xLeft+usX*psdData->szlSpace.cx;
   prclSpace->yBottom=rclWnd.yTop-(usY+1)*psdData->szlSpace.cy;
   prclSpace->xRight=prclSpace->xLeft+psdData->szlSpace.cx;
   prclSpace->yTop=prclSpace->yBottom+psdData->szlSpace.cy;
   return;                       // Avoid the "implicit return" warning.  Ugh!
}

USHORT queryNumNeighbors(PSAVERDATA psdData,USHORT usX,USHORT usY)
//-------------------------------------------------------------------------
// This function returns the number of neighbors of the space (usX,usY)
//
// Input:  psdData - points to the saver window instance data.  We pass this
//                   instead of the pointer to the board buffer because we
//                   also need the size of the board.  A better solution
//                   would be to typedef a BOARD datatype which includes
//                   the size...Nah...Too easy.  :)
//         usX, usY - coordinates of the space to check
// Returns:  number of neighbors
//
// In the notes below, 'X' is the space to be checked and the neighbors
// are number thusly:
//
// 1 2 3
// 4 X 6
// 7 8 9
//-------------------------------------------------------------------------
{
   USHORT usNum;

   usNum=0;

   if (usX>0) {
      //-------------------------------------------------------------------
      // Check neighbors 1, 4, and 7
      //-------------------------------------------------------------------
      if (psdData->psBoard[BCOORD(psdData,usX-1,usY)]!=-1) {
         usNum++;
      } /* endif */

      if ((usY>0) && (psdData->psBoard[BCOORD(psdData,usX-1,usY-1)]!=-1)) {
         usNum++;
      } /* endif */

      if ((usY<psdData->szlBoard.cy-1) &&
          (psdData->psBoard[BCOORD(psdData,usX-1,usY+1)]!=-1)) {
         usNum++;
      } /* endif */
   } /* endif */

   if (usX<psdData->szlBoard.cx-1) {
      //-------------------------------------------------------------------
      // Check neighbors 3, 6, and 9
      //-------------------------------------------------------------------
      if (psdData->psBoard[BCOORD(psdData,usX+1,usY)]!=-1) {
         usNum++;
      } /* endif */

      if ((usY>0) && (psdData->psBoard[BCOORD(psdData,usX+1,usY-1)]!=-1)) {
         usNum++;
      } /* endif */

      if ((usY<psdData->szlBoard.cy-1) &&
          (psdData->psBoard[BCOORD(psdData,usX+1,usY+1)]!=-1)) {
         usNum++;
      } /* endif */
   } /* endif */

   //----------------------------------------------------------------------
   // Check neighbors 2 and 8
   //----------------------------------------------------------------------
   if ((usY>0) && (psdData->psBoard[BCOORD(psdData,usX,usY-1)]!=-1)) {
      usNum++;
   } /* endif */

   if ((usY<psdData->szlBoard.cy-1) &&
       (psdData->psBoard[BCOORD(psdData,usX,usY+1)]!=-1)) {
      usNum++;
   } /* endif */

   return usNum;
}

VOID initDefaultPattern(PSAVERDATA psdData,PPATTERN ppDefault)
{
   ppDefault->szlPattern.cx=0;
   ppDefault->szlPattern.cy=0;
   memset(ppDefault->abData,0,sizeof(ppDefault->abData));

   //----------------------------------------------------------------------
   // In the patters below, 'x' indicates a filled space and '.' indicates
   // an empty space
   //----------------------------------------------------------------------
   switch (rand()%8) {
   case 0:
      //----------------------------------------------------------------
      // Pattern:
      //
      //   . x .
      //   x x x
      //   . x .
      //----------------------------------------------------------------
      ppDefault->szlPattern.cx=3;
      ppDefault->szlPattern.cy=3;

      ppDefault->abData[PCOORD(ppDefault,1,0)]=1;
      ppDefault->abData[PCOORD(ppDefault,0,1)]=1;
      ppDefault->abData[PCOORD(ppDefault,1,1)]=1;
      ppDefault->abData[PCOORD(ppDefault,2,1)]=1;
      ppDefault->abData[PCOORD(ppDefault,1,2)]=1;
      break;
   case 1:
      //----------------------------------------------------------------
      // Pattern:
      //
      //   x . . x
      //   x . . x
      //   x . . x
      //----------------------------------------------------------------
      ppDefault->szlPattern.cx=4;
      ppDefault->szlPattern.cy=3;

      ppDefault->abData[PCOORD(ppDefault,0,0)]=1;
      ppDefault->abData[PCOORD(ppDefault,3,0)]=1;
      ppDefault->abData[PCOORD(ppDefault,0,1)]=1;
      ppDefault->abData[PCOORD(ppDefault,3,1)]=1;
      ppDefault->abData[PCOORD(ppDefault,0,2)]=1;
      ppDefault->abData[PCOORD(ppDefault,3,2)]=1;
      break;
   case 2:
      //----------------------------------------------------------------
      // Pattern:
      //
      //   . x x
      //   . . x
      //   x x x
      //   x . .
      //   x x .
      //----------------------------------------------------------------
      ppDefault->szlPattern.cx=3;
      ppDefault->szlPattern.cy=5;

      ppDefault->abData[PCOORD(ppDefault,1,0)]=1;
      ppDefault->abData[PCOORD(ppDefault,2,0)]=1;
      ppDefault->abData[PCOORD(ppDefault,2,1)]=1;
      ppDefault->abData[PCOORD(ppDefault,0,2)]=1;
      ppDefault->abData[PCOORD(ppDefault,1,2)]=1;
      ppDefault->abData[PCOORD(ppDefault,2,2)]=1;
      ppDefault->abData[PCOORD(ppDefault,0,3)]=1;
      ppDefault->abData[PCOORD(ppDefault,0,4)]=1;
      ppDefault->abData[PCOORD(ppDefault,1,4)]=1;
      break;
   case 3:
      //----------------------------------------------------------------
      // Pattern:
      //
      // . x . . .
      // . . x . .
      // x x . x x
      // . . x . .
      // . . . x .
      //----------------------------------------------------------------
      ppDefault->szlPattern.cx=5;
      ppDefault->szlPattern.cy=5;

      ppDefault->abData[PCOORD(ppDefault,1,0)]=1;
      ppDefault->abData[PCOORD(ppDefault,2,1)]=1;
      ppDefault->abData[PCOORD(ppDefault,0,2)]=1;
      ppDefault->abData[PCOORD(ppDefault,1,2)]=1;
      ppDefault->abData[PCOORD(ppDefault,3,2)]=1;
      ppDefault->abData[PCOORD(ppDefault,4,2)]=1;
      ppDefault->abData[PCOORD(ppDefault,2,3)]=1;
      ppDefault->abData[PCOORD(ppDefault,3,4)]=1;
      break;
   case 4:
      //----------------------------------------------------------------
      // Pattern:
      //
      //   . x x .
      //   x x . x
      //   x . . x
      //   . x x .
      //----------------------------------------------------------------
      ppDefault->szlPattern.cx=4;
      ppDefault->szlPattern.cy=4;

      ppDefault->abData[PCOORD(ppDefault,1,0)]=1;
      ppDefault->abData[PCOORD(ppDefault,2,0)]=1;
      ppDefault->abData[PCOORD(ppDefault,0,1)]=1;
      ppDefault->abData[PCOORD(ppDefault,3,1)]=1;
      ppDefault->abData[PCOORD(ppDefault,0,2)]=1;
      ppDefault->abData[PCOORD(ppDefault,3,2)]=1;
      ppDefault->abData[PCOORD(ppDefault,1,3)]=1;
      ppDefault->abData[PCOORD(ppDefault,2,3)]=1;

      ppDefault->abData[PCOORD(ppDefault,1,1)]=1;
      break;
   case 5:
      //----------------------------------------------------------------
      // Pattern:
      //
      //   . x x .
      //   x . x x
      //   x . . x
      //   . x x .
      //----------------------------------------------------------------
      ppDefault->szlPattern.cx=4;
      ppDefault->szlPattern.cy=4;

      ppDefault->abData[PCOORD(ppDefault,1,0)]=1;
      ppDefault->abData[PCOORD(ppDefault,2,0)]=1;
      ppDefault->abData[PCOORD(ppDefault,0,1)]=1;
      ppDefault->abData[PCOORD(ppDefault,3,1)]=1;
      ppDefault->abData[PCOORD(ppDefault,0,2)]=1;
      ppDefault->abData[PCOORD(ppDefault,3,2)]=1;
      ppDefault->abData[PCOORD(ppDefault,1,3)]=1;
      ppDefault->abData[PCOORD(ppDefault,2,3)]=1;

      ppDefault->abData[PCOORD(ppDefault,2,1)]=1;
      break;
   case 6:
      //----------------------------------------------------------------
      // Pattern:
      //
      //   . x x .
      //   x . . x
      //   x . x x
      //   . x x .
      //----------------------------------------------------------------
      ppDefault->szlPattern.cx=4;
      ppDefault->szlPattern.cy=4;

      ppDefault->abData[PCOORD(ppDefault,1,0)]=1;
      ppDefault->abData[PCOORD(ppDefault,2,0)]=1;
      ppDefault->abData[PCOORD(ppDefault,0,1)]=1;
      ppDefault->abData[PCOORD(ppDefault,3,1)]=1;
      ppDefault->abData[PCOORD(ppDefault,0,2)]=1;
      ppDefault->abData[PCOORD(ppDefault,3,2)]=1;
      ppDefault->abData[PCOORD(ppDefault,1,3)]=1;
      ppDefault->abData[PCOORD(ppDefault,2,3)]=1;

      ppDefault->abData[PCOORD(ppDefault,2,2)]=1;
      break;
   case 7:
      //----------------------------------------------------------------
      // Pattern:
      //
      //   . x x .
      //   x . . x
      //   x x . x
      //   . x x .
      //----------------------------------------------------------------
      ppDefault->szlPattern.cx=4;
      ppDefault->szlPattern.cy=4;

      ppDefault->abData[PCOORD(ppDefault,1,0)]=1;
      ppDefault->abData[PCOORD(ppDefault,2,0)]=1;
      ppDefault->abData[PCOORD(ppDefault,0,1)]=1;
      ppDefault->abData[PCOORD(ppDefault,3,1)]=1;
      ppDefault->abData[PCOORD(ppDefault,0,2)]=1;
      ppDefault->abData[PCOORD(ppDefault,3,2)]=1;
      ppDefault->abData[PCOORD(ppDefault,1,3)]=1;
      ppDefault->abData[PCOORD(ppDefault,2,3)]=1;

      ppDefault->abData[PCOORD(ppDefault,1,2)]=1;
      break;
   default:
      break;
   } /* endswitch */

   return;
}

VOID initBoard(PSAVERDATA psdData)
//-------------------------------------------------------------------------
// This function reinitializes the universe.
//
// Input:  psdData - points to the saver window instance data
//-------------------------------------------------------------------------
{
   USHORT usX;
   USHORT usY;
   USHORT usNumPtrns;
   USHORT usIndex;
   USHORT usPattern;
   PPATTERN ppPattern;
   PATTERN pDefault;
   USHORT usBeginX;
   USHORT usBeginY;

   psdData->ulMaxTicks=rand()%MAX_TICKS+BASE_TICKS;
   psdData->ulRoamer=psdData->ulMaxTicks/4;
   psdData->ulNumTicks=0;

   for (usX=0; usX<psdData->szlBoard.cx; usX++) {
      for (usY=0; usY<psdData->szlBoard.cy; usY++) {
         psdData->psBoard[BCOORD(psdData,usX,usY)]=-1;
         psdData->psNew[BCOORD(psdData,usX,usY)]=-1;
      } /* endfor */
   } /* endfor */

   //----------------------------------------------------------------------
   // Generate a random number (3-5) of patterns.
   //----------------------------------------------------------------------
   usNumPtrns=rand()%3+3;

   for (usIndex=0; usIndex<usNumPtrns; usIndex++) {
      if (psdData->usNumPatterns>0) {
         usPattern=rand()%psdData->usNumPatterns;
         ppPattern=psdData->appPatterns[usPattern];
      } else {
         initDefaultPattern(psdData,&pDefault);
         ppPattern=&pDefault;
      } /* endif */

      usBeginX=rand()%(psdData->szlBoard.cx-MAX_MARGIN*4)+MAX_MARGIN*2;
      usBeginY=rand()%(psdData->szlBoard.cy-MAX_MARGIN*4)+MAX_MARGIN*2;

      for (usY=0; usY<ppPattern->szlPattern.cy; usY++) {
         for (usX=0; usX<ppPattern->szlPattern.cx; usX++) {
            if (((usBeginX+usX)<psdData->szlBoard.cx) &&
                ((usBeginY+usY)<psdData->szlBoard.cy) &&
                (ppPattern->abData[PCOORD(ppPattern,usX,usY)]!=0)) {
               psdData->psBoard[BCOORD(psdData,usBeginX+usX,usBeginY+usY)]=0;
            } /* endif */
         } /* endfor */
      } /* endfor */
   } /* endfor */

   return;
}

VOID initRoamer(PSAVERDATA psdData)
//-------------------------------------------------------------------------
// This function creates a roamer.
//
// Input:  psdData - points to the saver window instance data
//-------------------------------------------------------------------------
{
   USHORT usCorner;
   USHORT usDx;
   USHORT usDy;

   usCorner=rand()%4;
   usDx=rand()%5;
   usDy=rand()%5;

   switch (usCorner) {
   case 0:
      //-------------------------------------------------------------------
      // Start roamer in upper-left corner
      //-------------------------------------------------------------------
      psdData->psBoard[BCOORD(psdData,3+usDx,2+usDy)]=0;
      psdData->psBoard[BCOORD(psdData,4+usDx,3+usDy)]=0;
      psdData->psBoard[BCOORD(psdData,4+usDx,4+usDy)]=0;
      psdData->psBoard[BCOORD(psdData,3+usDx,4+usDy)]=0;
      psdData->psBoard[BCOORD(psdData,2+usDx,4+usDy)]=0;
      break;
   case 1:
      //-------------------------------------------------------------------
      // Start roamer in upper-right corner
      //-------------------------------------------------------------------
      psdData->psBoard[BCOORD(psdData,psdData->szlBoard.cx-3-usDx,2+usDy)]=0;
      psdData->psBoard[BCOORD(psdData,psdData->szlBoard.cx-4-usDx,3+usDy)]=0;
      psdData->psBoard[BCOORD(psdData,psdData->szlBoard.cx-4-usDx,4+usDy)]=0;
      psdData->psBoard[BCOORD(psdData,psdData->szlBoard.cx-3-usDx,4+usDy)]=0;
      psdData->psBoard[BCOORD(psdData,psdData->szlBoard.cx-2-usDx,4+usDy)]=0;
      break;
   case 2:
      //-------------------------------------------------------------------
      // Start roamer in lower-left corner
      //-------------------------------------------------------------------
      psdData->psBoard[BCOORD(psdData,3+usDx,psdData->szlBoard.cy-2-usDy)]=0;
      psdData->psBoard[BCOORD(psdData,4+usDx,psdData->szlBoard.cy-3-usDy)]=0;
      psdData->psBoard[BCOORD(psdData,4+usDx,psdData->szlBoard.cy-4-usDy)]=0;
      psdData->psBoard[BCOORD(psdData,3+usDx,psdData->szlBoard.cy-4-usDy)]=0;
      psdData->psBoard[BCOORD(psdData,2+usDx,psdData->szlBoard.cy-4-usDy)]=0;
      break;
   case 3:
      //-------------------------------------------------------------------
      // Start roamer in lower-right corner
      //-------------------------------------------------------------------
      psdData->psBoard[BCOORD(psdData,
                             psdData->szlBoard.cx-3-usDx,
                             psdData->szlBoard.cy-2-usDy)]=0;
      psdData->psBoard[BCOORD(psdData,
                             psdData->szlBoard.cx-4-usDx,
                             psdData->szlBoard.cy-3-usDy)]=0;
      psdData->psBoard[BCOORD(psdData,
                             psdData->szlBoard.cx-4-usDx,
                             psdData->szlBoard.cy-4-usDy)]=0;
      psdData->psBoard[BCOORD(psdData,
                             psdData->szlBoard.cx-3-usDx,
                             psdData->szlBoard.cy-4-usDy)]=0;
      psdData->psBoard[BCOORD(psdData,
                             psdData->szlBoard.cx-2-usDx,
                             psdData->szlBoard.cy-4-usDy)]=0;
      break;
   default:
      break;
   } /* endswitch */

   return;
}

VOID _Optlink loadPatternsThread(PSAVERDATA psdData)
{
   HAB habAnchor;
   HMQ hmqQueue;
   BOOL bSuccess;
   FILE *pfFile;
   USHORT usCount;
   PPATTERN ppPattern;
   CHAR achLine[256];
   LONG lOffset;
   SHORT sY;
   SHORT sMaxX;
   SHORT sX;
   CHAR achWord[8];

   habAnchor=WinInitialize(0);
   hmqQueue=WinCreateMsgQueue(habAnchor,0);

   bSuccess=FALSE;
   pfFile=NULL;
   usCount=0;
   ppPattern=NULL;

   pfFile=fopen(PATTERNS_FILE,"r");
   if (pfFile==NULL) {
      WinAlarm(HWND_DESKTOP,WA_ERROR);
      goto EXIT_PROC;
   } /* endif */

   //----------------------------------------------------------------------
   // Skip over any blank lines in the beginning
   //----------------------------------------------------------------------
   lOffset=ftell(pfFile);
   fgets(achLine,sizeof(achLine),pfFile);
   achLine[strlen(achLine)-1]=0;

   while ((CmnStrQueryWordCount(achLine)==0) &&
          !feof(pfFile) &&
          !ferror(pfFile)) {
      //-------------------------------------------------------------------
      // Save the file offset in case the line isn't blank
      //-------------------------------------------------------------------
      lOffset=ftell(pfFile);

      fgets(achLine,sizeof(achLine),pfFile);
      achLine[strlen(achLine)-1]=0;
   } /* endwhile */

   while ((usCount<MAX_PATTERNS) && !feof(pfFile) && !ferror(pfFile)) {
      ppPattern=calloc(1,sizeof(PATTERN));
      if (ppPattern==NULL) {
         WinAlarm(HWND_DESKTOP,WA_ERROR);
         goto EXIT_PROC;
      } /* endif */

      //-------------------------------------------------------------------
      // Determine the width and height of the pattern
      //-------------------------------------------------------------------
      ppPattern->szlPattern.cx=0;
      ppPattern->szlPattern.cy=0;

      while ((CmnStrQueryWordCount(achLine)>0) &&
             !feof(pfFile) &&
             !ferror(pfFile)) {
         ppPattern->szlPattern.cx=max(ppPattern->szlPattern.cx,
                                      CmnStrQueryWordCount(achLine));
         ppPattern->szlPattern.cy++;

         fgets(achLine,sizeof(achLine),pfFile);
         achLine[strlen(achLine)-1]=0;
      } /* endwhile */

      if (ferror(pfFile)) {
         WinAlarm(HWND_DESKTOP,WA_ERROR);
         goto EXIT_PROC;
      } /* endif */

      //-------------------------------------------------------------------
      // Return to the beginning of the pattern and store the data
      //-------------------------------------------------------------------
      fseek(pfFile,lOffset,SEEK_SET);

      for (sY=0; sY<ppPattern->szlPattern.cy; sY++) {
         fgets(achLine,sizeof(achLine),pfFile);
         achLine[strlen(achLine)-1]=0;

         for (sX=0; sX<ppPattern->szlPattern.cx; sX++) {
            ppPattern->abData[PCOORD(ppPattern,sX,sY)]=0;
         } /* endfor */

         sMaxX=CmnStrQueryWordCount(achLine);

         for (sX=0; sX<sMaxX; sX++) {
            CmnStrQueryWord(achLine,sX,achWord,sizeof(achWord));
            ppPattern->abData[PCOORD(ppPattern,sX,sY)]=(achWord[0]!='.');
         } /* endfor */
      } /* endfor */

      psdData->appPatterns[usCount]=ppPattern;
      ppPattern=NULL;
      usCount++;

      if (ferror(pfFile)) {
         WinAlarm(HWND_DESKTOP,WA_ERROR);
         goto EXIT_PROC;
      } /* endif */

      //-------------------------------------------------------------------
      // If we don't read the next line (which should be blank, according
      // to the loop logic above), the next loop will never execute.
      //-------------------------------------------------------------------
      fgets(achLine,sizeof(achLine),pfFile);
      achLine[strlen(achLine)-1]=0;

      //-------------------------------------------------------------------
      // Skip over any intervening blank lines between patterns
      //-------------------------------------------------------------------
      while ((CmnStrQueryWordCount(achLine)==0) &&
             !feof(pfFile) &&
             !ferror(pfFile)) {
         //----------------------------------------------------------------
         // Save the file offset in case the line isn't blank
         //----------------------------------------------------------------
         lOffset=ftell(pfFile);

         fgets(achLine,sizeof(achLine),pfFile);
         achLine[strlen(achLine)-1]=0;
      } /* endwhile */

      if (ferror(pfFile)) {
         WinAlarm(HWND_DESKTOP,WA_ERROR);
         goto EXIT_PROC;
      } /* endif */

      if (!feof(pfFile)) {
         ppPattern=calloc(1,sizeof(PATTERN));
         if (ppPattern==NULL) {
            WinAlarm(HWND_DESKTOP,WA_ERROR);
            goto EXIT_PROC;
         } /* endif */
      } /* endif */
   } /* endwhile */

   if (!ferror(pfFile)) {
      bSuccess=TRUE;
   } /* endif */

   EXIT_PROC:
   if (pfFile!=NULL) {
      fclose(pfFile);
   } /* endif */

   if (ppPattern!=NULL) {
      free(ppPattern);
   } /* endif */

   if (!bSuccess) {
      for (sX=0; sX<usCount; sX++) {
         free(psdData->appPatterns[sX]);
         psdData->appPatterns[sX]=NULL;
      } /* endfor */

      usCount=0;
   } else {
      WinAlarm(HWND_DESKTOP,WA_NOTE);
   } /* endif */

   //----------------------------------------------------------------------
   // Signal the main thread that the pattern loading processing is done.
   // It will check the bPatternsLoaded flag once a second in the WM_TIMER
   // processing.
   //----------------------------------------------------------------------
   psdData->usNumPatterns=usCount;
   psdData->bPatternsLoaded=TRUE;

   WinDestroyMsgQueue(hmqQueue);
   WinTerminate(habAnchor);
   return;
}
